/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.mapping.AbstractCompareInput;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.mapping.ResourceCompareInputChangeNotifier;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.SaveableComparison;

public class ResourceDiffCompareInput
extends AbstractCompareInput
implements ISynchronizationCompareInput,
IAdaptable,
IResourceProvider {
    private IDiff node;
    private final ISynchronizationContext context;

    public static int getCompareKind(IDiff node) {
        int compareKind = 0;
        if (node != null) {
            switch (node.getKind()) {
                case 1: {
                    compareKind = 1;
                    break;
                }
                case 2: {
                    compareKind = 2;
                    break;
                }
                case 4: {
                    compareKind = 3;
                }
            }
            if (node instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)node;
                switch (twd.getDirection()) {
                    case 256: {
                        compareKind |= 8;
                        break;
                    }
                    case 512: {
                        compareKind |= 4;
                        break;
                    }
                    case 768: {
                        compareKind |= 4;
                        compareKind |= 8;
                    }
                }
            }
        }
        return compareKind;
    }

    private static FileRevisionTypedElement getRightContributor(IDiff node) {
        if (node instanceof IResourceDiff) {
            IResourceDiff rd = (IResourceDiff)node;
            return ResourceDiffCompareInput.asTypedElement(rd.getAfterState(), ResourceDiffCompareInput.getLocalEncoding(node));
        }
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
            if (diff != null) {
                return ResourceDiffCompareInput.getRightContributor((IDiff)diff);
            }
            diff = (IResourceDiff)twd.getLocalChange();
            return ResourceDiffCompareInput.asTypedElement(diff.getBeforeState(), ResourceDiffCompareInput.getLocalEncoding(node));
        }
        return null;
    }

    private static LocalResourceTypedElement getLeftContributor(IDiff node) {
        return new LocalResourceTypedElement(ResourceDiffTree.getResourceFor((IDiff)node));
    }

    private static FileRevisionTypedElement getAncestor(IDiff node) {
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            IResourceDiff diff = (IResourceDiff)twd.getLocalChange();
            if (diff == null) {
                diff = (IResourceDiff)twd.getRemoteChange();
            }
            return ResourceDiffCompareInput.asTypedElement(diff.getBeforeState(), ResourceDiffCompareInput.getLocalEncoding(node));
        }
        return null;
    }

    private static String getLocalEncoding(IDiff node) {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)node);
        if (resource instanceof IEncodedStorage) {
            IEncodedStorage es = (IEncodedStorage)resource;
            try {
                return es.getCharset();
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return null;
    }

    private static FileRevisionTypedElement asTypedElement(IFileRevision state, String localEncoding) {
        if (state == null) {
            return null;
        }
        return new FileRevisionTypedElement(state, localEncoding);
    }

    public static void ensureContentsCached(IDiff diff, IProgressMonitor monitor) throws CoreException {
        if (diff != null) {
            ResourceDiffCompareInput.ensureContentsCached(ResourceDiffCompareInput.getAncestor(diff), ResourceDiffCompareInput.getRightContributor(diff), monitor);
        }
    }

    private static void ensureContentsCached(Object ancestor, Object right, IProgressMonitor monitor) throws CoreException {
        FileRevisionTypedElement fste;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (ancestor instanceof FileRevisionTypedElement) {
            fste = (FileRevisionTypedElement)ancestor;
            fste.cacheContents((IProgressMonitor)sm.newChild(50));
        } else {
            sm.setWorkRemaining(50);
        }
        if (right instanceof FileRevisionTypedElement) {
            fste = (FileRevisionTypedElement)right;
            fste.cacheContents((IProgressMonitor)sm.newChild(50));
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public ResourceDiffCompareInput(IDiff diff, ISynchronizationContext context) {
        super(ResourceDiffCompareInput.getCompareKind(diff), ResourceDiffCompareInput.getAncestor(diff), (ITypedElement)ResourceDiffCompareInput.getLeftContributor(diff), ResourceDiffCompareInput.getRightContributor(diff));
        this.node = diff;
        this.context = context;
    }

    @Override
    public void fireChange() {
        super.fireChange();
    }

    @Override
    public void prepareInput(CompareConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        configuration.setLabelProvider((ICompareInput)this, ((ResourceCompareInputChangeNotifier)this.getChangeNotifier()).getLabelProvider());
        ResourceDiffCompareInput.ensureContentsCached(this.getAncestor(), this.getRight(), monitor);
    }

    @Override
    public SaveableComparison getSaveable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class || adapter == IResource.class) {
            return ResourceDiffTree.getResourceFor((IDiff)this.node);
        }
        if (adapter == ResourceMapping.class) {
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)this.node);
            return resource.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public String getFullPath() {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)this.node);
        if (resource != null) {
            return resource.getFullPath().toString();
        }
        return this.getName();
    }

    @Override
    public boolean isCompareInputFor(Object object) {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)this.node);
        IResource other = Utils.getResource(object);
        if (resource != null && other != null) {
            return resource.equals((Object)other);
        }
        return false;
    }

    public IResource getResource() {
        return ResourceDiffTree.getResourceFor((IDiff)this.node);
    }

    @Override
    public CompareInputChangeNotifier getChangeNotifier() {
        return ResourceCompareInputChangeNotifier.getChangeNotifier(this.context);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ResourceDiffCompareInput) {
            ResourceDiffCompareInput otherInput = (ResourceDiffCompareInput)other;
            return this.isEqual(this.getLeft(), otherInput.getLeft()) && this.isEqual(this.getRight(), otherInput.getRight()) && this.isEqual(this.getAncestor(), otherInput.getAncestor());
        }
        return false;
    }

    private boolean isEqual(ITypedElement e1, ITypedElement e2) {
        if (e1 == null) {
            return e2 == null;
        }
        if (e2 == null) {
            return false;
        }
        return e1.equals(e2);
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    @Override
    public void update() {
        IDiff newNode = this.context.getDiffTree().getDiff(this.getResource());
        if (newNode == null) {
            this.setKind(0);
            this.fireChange();
        } else {
            LocalResourceTypedElement left = (LocalResourceTypedElement)this.getLeft();
            if (!this.node.equals(newNode) || !left.isSynchronized()) {
                this.node = newNode;
                this.setKind(ResourceDiffCompareInput.getCompareKind(this.node));
                left.update();
                FileRevisionTypedElement newRight = ResourceDiffCompareInput.getRightContributor(this.node);
                this.propogateAuthorIfSameRevision((FileRevisionTypedElement)this.getRight(), newRight);
                this.setRight(newRight);
                FileRevisionTypedElement newAncestor = ResourceDiffCompareInput.getAncestor(this.node);
                this.propogateAuthorIfSameRevision((FileRevisionTypedElement)this.getAncestor(), newAncestor);
                this.setAncestor(newAncestor);
                this.propogateAuthorIfSameRevision((FileRevisionTypedElement)this.getAncestor(), (FileRevisionTypedElement)this.getRight());
            }
            this.fireChange();
        }
    }

    private boolean propogateAuthorIfSameRevision(FileRevisionTypedElement oldContributor, FileRevisionTypedElement newContributor) {
        if (oldContributor == null || newContributor == null) {
            return false;
        }
        String author = oldContributor.getAuthor();
        if (newContributor.getAuthor() == null && author != null && oldContributor.getContentIdentifier().equals(newContributor.getContentIdentifier())) {
            newContributor.setAuthor(author);
            return true;
        }
        return false;
    }

    private boolean propogateAuthorIfSameRevision(FileRevisionTypedElement oldContributor, LocalResourceTypedElement newContributor) {
        if (oldContributor == null || newContributor == null) {
            return false;
        }
        String author = oldContributor.getAuthor();
        if (newContributor.getAuthor() == null && author != null && oldContributor.getContentIdentifier().equals(this.getLocalContentId())) {
            newContributor.setAuthor(author);
            return true;
        }
        return false;
    }

    @Override
    public boolean needsUpdate() {
        IDiff newNode = this.context.getDiffTree().getDiff(this.getResource());
        return newNode == null || !newNode.equals(this.node);
    }

    public String getLocalContentId() {
        return Utils.getLocalContentId(this.node);
    }

    public boolean updateAuthorInfo(IProgressMonitor monitor) throws CoreException {
        boolean fireEvent = false;
        FileRevisionTypedElement ancestor = (FileRevisionTypedElement)this.getAncestor();
        FileRevisionTypedElement right = (FileRevisionTypedElement)this.getRight();
        LocalResourceTypedElement left = (LocalResourceTypedElement)this.getLeft();
        if (ancestor != null && ancestor.getAuthor() == null) {
            ancestor.fetchAuthor(monitor);
            fireEvent |= ancestor.getAuthor() != null;
        }
        fireEvent |= this.propogateAuthorIfSameRevision(ancestor, right);
        fireEvent |= this.propogateAuthorIfSameRevision(ancestor, left);
        if (right != null && right.getAuthor() == null) {
            right.fetchAuthor(monitor);
            fireEvent |= right.getAuthor() != null;
        }
        fireEvent |= this.propogateAuthorIfSameRevision(right, left);
        if (left != null && left.getAuthor() == null) {
            left.fetchAuthor(monitor);
            boolean bl = fireEvent;
            fireEvent = left.getAuthor() != null;
            fireEvent = bl | fireEvent;
        }
        return fireEvent;
    }
}

