/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import java.util.Optional;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.editparts.FloatingLabelEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.RTPropertyPartEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleStructureDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public interface IInheritableEditPart
extends IGraphicalEditPart {
    default public Optional<UMLRTNamedElement> getUMLRTElement() {
        EObject semantic = null;
        View view = this.getNotationView();
        if (view == null || !view.eIsProxy()) {
            semantic = this.resolveSemanticElement();
        }
        return semantic instanceof NamedElement ? Optional.ofNullable(UMLRTFactory.create((NamedElement)((NamedElement)semantic))) : Optional.empty();
    }

    default public boolean isInherited() {
        boolean result = this.isDependentChild() ? ((IInheritableEditPart)this.getParent()).isInherited() : StyleUtil.getInheritedStyle(this.getNotationView()).map(BooleanValueStyle::isBooleanValue).orElseGet(this::canInherit).booleanValue();
        return result;
    }

    default public boolean canInherit() {
        EditPart parent = this.getParent();
        IInheritableEditPart inheritableParent = (IInheritableEditPart)TypeUtils.as((Object)parent, IInheritableEditPart.class);
        boolean result = inheritableParent != null && inheritableParent.isSemanticInherited() ? inheritableParent.isInherited() : this.isSemanticInherited();
        return result;
    }

    default public boolean isSemanticInherited() {
        return this.getUMLRTElement().map(UMLRTNamedElement::isInherited).orElse(false);
    }

    default public View getRedefinedView() {
        View result = null;
        if (this.isInherited()) {
            View parentView;
            View view = this.getNotationView();
            if (this.getParent() instanceof IInheritableEditPart) {
                IInheritableEditPart part = (IInheritableEditPart)this.getParent();
                Optional<UMLRTNamedElement> redefinition = part.getUMLRTElement();
                parentView = part.getRedefinedView();
            } else {
                Optional<UMLRTNamedElement> redefinition = this.getUMLRTElement();
                parentView = redefinition.map(UMLRTNamedElement::getRedefinedElement).map(this::getRedefinitionContext).map(this::getPrimaryDiagram).orElse(null);
            }
            if (parentView != null) {
                Element lookFor = (Element)view.getElement();
                if (UMLRTExtensionUtil.isInherited((Element)lookFor)) {
                    lookFor = UMLRTExtensionUtil.getRedefinedElement((Element)lookFor);
                }
                result = UMLRTEditPartUtils.findView(parentView, view.getType(), (EObject)lookFor);
            }
        }
        return result;
    }

    default public UMLRTNamedElement getRedefinitionContext(UMLRTNamedElement element) {
        return EditPartInheritanceUtils.getContextCapsule(element);
    }

    default public Diagram getPrimaryDiagram(UMLRTNamedElement context) {
        return UMLRTCapsuleStructureDiagramUtils.getCapsuleStructureDiagram((Class)context.toUML());
    }

    default public boolean isDependentChild() {
        return this instanceof FloatingLabelEditPart || this instanceof CompartmentEditPart;
    }

    default public org.eclipse.gef.commands.Command getReifyViewCommand() {
        return this.isDependentChild() ? ((IInheritableEditPart)this.getParent()).getReifyViewCommand() : (org.eclipse.gef.commands.Command)this.getUMLRTElement().map(rt -> {
            CompositeTransactionalCommand cc = new CompositeTransactionalCommand(this.getEditingDomain(), "Redefine View");
            View view = this.getNotationView();
            if (this.isInherited()) {
                cc.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)StyleUtil.getCreateInheritedStyle(view)));
            }
            return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
        }).orElse(null);
    }

    default public <T extends NamedElement> T resolveContext(java.lang.Class<T> contextType) {
        NamedElement result = null;
        EditPart parent = this.getParent();
        while (result == null && parent != null) {
            EObject context = this.resolveContext(parent);
            if (contextType.isInstance(context)) {
                result = (NamedElement)contextType.cast(context);
            }
            parent = parent.getParent();
        }
        return (T)result;
    }

    default public EObject resolveContext(EditPart editPart) {
        EObject result = null;
        if (editPart instanceof RTPropertyPartEditPart) {
            result = ((RTPropertyPartEditPart)editPart).getUMLRTElement().map(UMLRTCapsulePart.class::cast).map(UMLRTCapsulePart::getType).map(UMLRTCapsule::toUML).orElse(null);
        } else if (editPart instanceof IGraphicalEditPart) {
            result = ((IGraphicalEditPart)editPart).resolveSemanticElement();
        } else if (editPart instanceof DiagramEditPart) {
            DiagramEditPart diagram = (DiagramEditPart)editPart;
            result = EditPartInheritanceUtils.resolveSemanticElement((View)diagram.getDiagramView());
        } else if (editPart instanceof DiagramRootEditPart) {
            DiagramEditPart diagram = (DiagramEditPart)editPart.getChildren().get(0);
            result = EditPartInheritanceUtils.resolveSemanticElement((View)diagram.getDiagramView());
        }
        return result;
    }

    public static class StyleUtil {
        static final String INHERITED_STYLE = "papyrusrt.inherited";

        protected static <T extends NamedStyle> Optional<T> getStyle(View view, String name, java.lang.Class<T> type) {
            return Optional.ofNullable(view.getNamedStyle(StyleUtil.eClass(type), name)).map(type::cast);
        }

        protected static EClass eClass(java.lang.Class<?> interface_) {
            return (EClass)NotationPackage.eINSTANCE.getEClassifier(interface_.getSimpleName());
        }

        protected static <T extends NamedStyle> T demandStyle(View view, String name, java.lang.Class<T> type) {
            return (T)StyleUtil.getStyle(view, name, type).orElseGet(() -> StyleUtil.createStyle(view, name, type));
        }

        protected static <T extends NamedStyle> T createStyle(View view, String name, java.lang.Class<T> type) {
            NamedStyle result = (NamedStyle)type.cast(view.createStyle(StyleUtil.eClass(type)));
            result.setName(name);
            return (T)result;
        }

        protected static <T extends NamedStyle> Command getCreateStyle(View view, String name, java.lang.Class<T> type) {
            NamedStyle style = (NamedStyle)type.cast(EcoreUtil.create((EClass)StyleUtil.eClass(type)));
            style.setName(name);
            return AddCommand.create((EditingDomain)EMFHelper.resolveEditingDomain((EObject)view), (Object)view, (Object)NotationPackage.Literals.VIEW__STYLES, (Object)style);
        }

        public static Optional<BooleanValueStyle> getInheritedStyle(View view) {
            return Optional.ofNullable((BooleanValueStyle)view.getNamedStyle(NotationPackage.Literals.BOOLEAN_VALUE_STYLE, INHERITED_STYLE));
        }

        public static BooleanValueStyle demandInheritedStyle(View view) {
            return StyleUtil.getInheritedStyle(view).orElseGet(() -> {
                BooleanValueStyle result = (BooleanValueStyle)view.createStyle(NotationPackage.Literals.BOOLEAN_VALUE_STYLE);
                result.setName(INHERITED_STYLE);
                return result;
            });
        }

        public static Command getCreateInheritedStyle(View view) {
            return StyleUtil.getCreateStyle(view, INHERITED_STYLE, BooleanValueStyle.class);
        }

        public static Command getDeleteStyle(View view, String name, java.lang.Class<? extends NamedStyle> type) {
            return StyleUtil.getStyle(view, name, type).map(s -> RemoveCommand.create((EditingDomain)EMFHelper.resolveEditingDomain((EObject)s), (Object)s)).orElse(null);
        }

        public static Command getDeleteInheritedStyle(View view) {
            return StyleUtil.getDeleteStyle(view, INHERITED_STYLE, BooleanValueStyle.class);
        }
    }
}

