/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.requests.ShowHideRelatedLinkRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.EdgeWithNoSemanticElementRepresentationImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IDiagramInformationProviderEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.updater.DiagramUpdater;
import org.eclipse.papyrus.infra.gmfdiag.common.updater.UpdaterLinkDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.Domain2Notation;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;

public abstract class AbstractShowHideRelatedLinkEditPolicy
extends AbstractEditPolicy
implements IDiagramInformationProviderEditPolicy {
    public static final String SHOW_HIDE_RELATED_LINK_ROLE = "ShowHideRelatedLinkEditPolicy";

    public AbstractShowHideRelatedLinkEditPolicy(DiagramEditPart host) {
        this.setHost((EditPart)host);
    }

    public Command getCommand(Request req) {
        if (this.understandsRequest(req)) {
            ShowHideRelatedLinkRequest request = (ShowHideRelatedLinkRequest)req;
            Domain2Notation domain2NotationMap = new Domain2Notation();
            HashMap<EditPart, Set<EObject>> availableLinks = new HashMap<EditPart, Set<EObject>>();
            HashSet<EObject> visibleLinks = new HashSet<EObject>();
            HashSet<UpdaterLinkDescriptor> linksDescriptors = new HashSet<UpdaterLinkDescriptor>();
            EcoreUtil.resolveAll((ResourceSet)this.getEditingDomain().getResourceSet());
            this.getHost().refresh();
            domain2NotationMap.mapModel((View)this.getHost().getAdapter(View.class));
            for (EditPart currentEp : request.getSelectedEditParts()) {
                View view = (View)currentEp.getAdapter(View.class);
                if (view == null) continue;
                Collection<? extends UpdaterLinkDescriptor> desc = this.collectPartRelatedLinks(view, domain2NotationMap);
                linksDescriptors.addAll(desc);
                HashSet<EObject> modelLinks = new HashSet<EObject>();
                Iterator iter = desc.iterator();
                while (iter.hasNext()) {
                    View linkView;
                    UpdaterLinkDescriptor current = (UpdaterLinkDescriptor)iter.next();
                    EObject link = current.getModelElement();
                    EObject destination = current.getDestination();
                    View dest = domain2NotationMap.getFirstView(destination);
                    EObject source2 = current.getSource();
                    View source = domain2NotationMap.getFirstView(source2);
                    if (dest != null && source != null) {
                        modelLinks.add(link);
                    }
                    if ((linkView = domain2NotationMap.getFirstView(link)) == null || !linkView.isVisible()) continue;
                    visibleLinks.add(link);
                }
                availableLinks.put(currentEp, modelLinks);
            }
            switch (request.getMode()) {
                case OPEN_DIALOG: {
                    return this.getShowHideRelatedLinkCommandWithDialog(request.getSelectedEditParts(), availableLinks, visibleLinks, domain2NotationMap, linksDescriptors);
                }
                case SHOW_ALL_LINK_BETWEEN_SELECTED_ELEMENT: {
                    HashSet<EObject> possibleEnds = new HashSet<EObject>();
                    for (EditPart currentIGraphical : request.getSelectedEditParts()) {
                        possibleEnds.add((EObject)currentIGraphical.getAdapter(EObject.class));
                    }
                    ArrayList<UpdaterLinkDescriptor> toRemove = new ArrayList<UpdaterLinkDescriptor>();
                    for (UpdaterLinkDescriptor current : linksDescriptors) {
                        EObject source = current.getSource();
                        EObject target = current.getDestination();
                        if (possibleEnds.contains(source) && possibleEnds.contains(target)) continue;
                        toRemove.add(current);
                    }
                    linksDescriptors.removeAll(toRemove);
                }
                case SHOW_ALL_LINK_IN_DIAGRAM: {
                    HashSet allLinks = new HashSet();
                    for (Collection currentColl : availableLinks.values()) {
                        allLinks.addAll(currentColl);
                    }
                    return new ICommandProxy(this.getShowHideRelatedLinkCommand(this.getEditingDomain(), allLinks, Collections.emptyList(), domain2NotationMap, linksDescriptors));
                }
            }
        }
        return null;
    }

    protected Collection<? extends UpdaterLinkDescriptor> collectPartRelatedLinks(View view, Domain2Notation domain2NotationMap) {
        LinkedList<UpdaterLinkDescriptor> result = new LinkedList<UpdaterLinkDescriptor>();
        DiagramUpdater diagramUpdater = this.getDiagramUpdater();
        List<? extends UpdaterLinkDescriptor> outgoingDescriptors = diagramUpdater.getOutgoingLinks(view);
        this.cleanAdd(result, view, outgoingDescriptors, domain2NotationMap);
        List<? extends UpdaterLinkDescriptor> incomingDescriptors = diagramUpdater.getIncomingLinks(view);
        this.cleanAdd(result, view, incomingDescriptors, domain2NotationMap);
        if (!domain2NotationMap.containsKey(view.getElement()) || view.getEAnnotation("Shortcut") == null) {
            domain2NotationMap.putView(view);
        }
        return this.removeInvalidLinkDescriptor(result);
    }

    protected Diagram getCurrentDiagram() {
        return (Diagram)this.getHost().getAdapter(Diagram.class);
    }

    protected Collection<UpdaterLinkDescriptor> removeInvalidLinkDescriptor(Collection<UpdaterLinkDescriptor> descriptors) {
        ArrayList<UpdaterLinkDescriptor> toRemove = new ArrayList<UpdaterLinkDescriptor>();
        ArrayList<UpdaterLinkDescriptor> toAdd = new ArrayList<UpdaterLinkDescriptor>();
        for (UpdaterLinkDescriptor current : descriptors) {
            if (current.getModelElement() != null) continue;
            IElementType elementType = (IElementType)current.getSemanticAdapter().getAdapter(IElementType.class);
            EdgeWithNoSemanticElementRepresentationImpl noSemantic = new EdgeWithNoSemanticElementRepresentationImpl(current.getSource(), current.getDestination(), ((IHintedType)elementType).getSemanticHint());
            UpdaterLinkDescriptor replacement = new UpdaterLinkDescriptor(current.getSource(), current.getDestination(), (EObject)noSemantic, elementType, current.getVisualID());
            toRemove.add(current);
            toAdd.add(replacement);
        }
        descriptors.removeAll(toRemove);
        descriptors.addAll(toAdd);
        return descriptors;
    }

    protected void cleanAdd(Collection<UpdaterLinkDescriptor> result, View view, List<? extends UpdaterLinkDescriptor> descriptors, Domain2Notation domain2NotationMap) {
        for (UpdaterLinkDescriptor updaterLinkDescriptor : descriptors) {
            if (this.cleanContains(result, updaterLinkDescriptor) || !this.isOwner(view, updaterLinkDescriptor)) continue;
            result.add(updaterLinkDescriptor);
        }
    }

    private boolean isOwner(View view, UpdaterLinkDescriptor descriptor) {
        EObject source = descriptor.getSource();
        EObject dest = descriptor.getDestination();
        if (source != null && source.equals(view.getElement())) {
            return true;
        }
        return dest != null && dest.equals(view.getElement());
    }

    private boolean cleanContains(Collection<? extends UpdaterLinkDescriptor> collection, UpdaterLinkDescriptor umlLinkDescriptor) {
        for (UpdaterLinkDescriptor updaterLinkDescriptor : collection) {
            if (updaterLinkDescriptor.getModelElement() != umlLinkDescriptor.getModelElement() || updaterLinkDescriptor.getSource() != umlLinkDescriptor.getSource() || updaterLinkDescriptor.getDestination() != umlLinkDescriptor.getDestination() || !updaterLinkDescriptor.getVisualID().equals(umlLinkDescriptor.getVisualID())) continue;
            return true;
        }
        return false;
    }

    public boolean understandsRequest(Request request) {
        return request instanceof ShowHideRelatedLinkRequest;
    }

    protected abstract Command getShowHideRelatedLinkCommandWithDialog(Collection<EditPart> var1, Map<EditPart, Set<EObject>> var2, Set<EObject> var3, Domain2Notation var4, Collection<UpdaterLinkDescriptor> var5);

    protected final TransactionalEditingDomain getEditingDomain() {
        try {
            return ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain(this.getHost());
        }
        catch (ServiceException e) {
            Activator.log.error("Editing Domain not found", (Throwable)e);
            return null;
        }
    }

    protected ICommand getComputeCommandResultCommand(final TransactionalEditingDomain domain, final ICommand previousCommand, final Set<EObject> initialSelection, final Domain2Notation domain2NotationMap, final Collection<UpdaterLinkDescriptor> linkDescriptor) {
        AbstractTransactionalCommand computeCommand = new AbstractTransactionalCommand(domain, "Compute Result", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Object returnedValue = previousCommand.getCommandResult().getReturnValue();
                if (previousCommand.getCommandResult().getStatus().isOK()) {
                    if (returnedValue instanceof Collection) {
                        Collection res = (Collection)returnedValue;
                        HashSet toAdd = new HashSet(res);
                        toAdd.removeAll(initialSelection);
                        HashSet toHide = new HashSet(initialSelection);
                        toHide.removeAll(res);
                        ICommand cmd = AbstractShowHideRelatedLinkEditPolicy.this.getShowHideRelatedLinkCommand(domain, toAdd, toHide, domain2NotationMap, linkDescriptor);
                        if (cmd.canExecute()) {
                            cmd.execute(monitor, info);
                        } else {
                            Activator.log.error((Throwable)new IllegalStateException("The command is not executable"));
                        }
                    }
                } else {
                    return previousCommand.getCommandResult();
                }
                return CommandResult.newOKCommandResult((Object)returnedValue);
            }
        };
        return computeCommand;
    }

    protected final ICommand getShowHideRelatedLinkCommand(TransactionalEditingDomain domain, Collection<?> toShow, Collection<?> toHide, Domain2Notation domain2NotationMap, Collection<? extends UpdaterLinkDescriptor> linkDescriptors) {
        ICommand tmp;
        CompositeCommand compositeCommand = new CompositeCommand("Show/Hide Related Link");
        for (Object current : toShow) {
            if (!(current instanceof EObject) || (tmp = this.getShowLinkCommand(domain, (EObject)current, domain2NotationMap, linkDescriptors)) == null || !tmp.canExecute()) continue;
            compositeCommand.add((IUndoableOperation)tmp);
        }
        for (Object current : toHide) {
            if (!(current instanceof EObject) || (tmp = this.getHideLinkCommand(domain, (EObject)current, domain2NotationMap, linkDescriptors)) == null || !tmp.canExecute()) continue;
            compositeCommand.add((IUndoableOperation)tmp);
        }
        return compositeCommand;
    }

    protected ICommand getHideLinkCommand(TransactionalEditingDomain domain, EObject linkToHide, Domain2Notation domain2NotationMap, Collection<? extends UpdaterLinkDescriptor> linkDescriptors) {
        UpdaterLinkDescriptor descriptor = this.getLinkDescriptor(linkToHide, linkDescriptors);
        if (descriptor != null) {
            View view = domain2NotationMap.getFirstView(linkToHide);
            EditPart editPart = DiagramEditPartsUtil.getEditPartFromView(view, this.getHost());
            return new CommandProxy(editPart.getCommand((Request)new GroupRequest((Object)"delete")));
        }
        return null;
    }

    protected final UpdaterLinkDescriptor getLinkDescriptor(EObject link, Collection<? extends UpdaterLinkDescriptor> descriptors) {
        for (UpdaterLinkDescriptor updaterLinkDescriptor : descriptors) {
            if (updaterLinkDescriptor.getModelElement() != link) continue;
            return updaterLinkDescriptor;
        }
        return null;
    }

    protected final List<UpdaterLinkDescriptor> getLinkDescriptors(EObject link, Collection<? extends UpdaterLinkDescriptor> descriptors) {
        ArrayList<UpdaterLinkDescriptor> updaterLinkDescriptors = new ArrayList<UpdaterLinkDescriptor>();
        for (UpdaterLinkDescriptor updaterLinkDescriptor : descriptors) {
            if (updaterLinkDescriptor.getModelElement() != link) continue;
            updaterLinkDescriptors.add(updaterLinkDescriptor);
        }
        return updaterLinkDescriptors;
    }

    protected ICommand getShowLinkCommand(TransactionalEditingDomain domain, EObject linkToShow, Domain2Notation domain2NotationMap, Collection<? extends UpdaterLinkDescriptor> linkDescriptors) {
        domain2NotationMap.mapModel((View)this.getHost().getAdapter(View.class));
        View view = domain2NotationMap.getFirstView(linkToShow);
        if (view != null) {
            return new SetPropertyCommand(domain, "Restore related linksCommand show view", (IAdaptable)new EObjectAdapter((EObject)view), Properties.ID_ISVISIBLE, (Object)Boolean.TRUE);
        }
        UpdaterLinkDescriptor descriptor = this.getLinkDescriptor(linkToShow, linkDescriptors);
        if (linkToShow instanceof EdgeWithNoSemanticElementRepresentationImpl) {
            IElementType elementType = (IElementType)descriptor.getSemanticAdapter().getAdapter(IElementType.class);
            descriptor = new UpdaterLinkDescriptor(descriptor.getSource(), descriptor.getDestination(), elementType, descriptor.getVisualID());
        }
        if (descriptor != null) {
            Set sourceViewList = (Set)domain2NotationMap.get(descriptor.getSource());
            CompositeCommand compositeCommand = new CompositeCommand("Restor All Related Links");
            for (View sourceView : sourceViewList) {
                Set targetViewList = (Set)domain2NotationMap.get(descriptor.getDestination());
                for (View targetView : targetViewList) {
                    if (!this.canDisplayExistingLinkBetweenViews(linkToShow, sourceView, targetView)) continue;
                    EditPart sourceEditPart = this.getEditPartFromView(sourceView);
                    EditPart targetEditPart = this.getEditPartFromView(targetView);
                    if (sourceEditPart == null || targetEditPart == null) {
                        return null;
                    }
                    String semanticHint = this.getSemanticHint(linkToShow);
                    if (semanticHint == null) {
                        semanticHint = ((IHintedType)descriptor.getSemanticAdapter().getAdapter(IElementType.class)).getSemanticHint();
                    }
                    CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(descriptor.getSemanticAdapter(), semanticHint, -1, false, ((GraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
                    CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(viewDescriptor);
                    ccr.setType((Object)"connection start");
                    ccr.setSourceEditPart(sourceEditPart);
                    sourceEditPart.getCommand((Request)ccr);
                    ccr.setTargetEditPart(targetEditPart);
                    ccr.setType((Object)"connection end");
                    CommandProxy commandProxy = new CommandProxy(targetEditPart.getCommand((Request)ccr));
                    compositeCommand.add((IUndoableOperation)commandProxy);
                }
            }
            return compositeCommand;
        }
        return null;
    }

    public boolean canDisplayExistingLinkBetweenViews(EObject element, View sourceView, View targetView) {
        return true;
    }

    protected String getSemanticHint(EObject eobject) {
        return null;
    }

    protected EditPart getEditPart(EObject element, Domain2Notation domain2NotationMap) {
        View view = domain2NotationMap.getFirstView(element);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    protected EditPart getEditPartFromView(View view) {
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    protected abstract ILabelProvider getLabelProvider();

    public static class LinkContentProvider
    implements ITreeContentProvider {
        private final Map<EditPart, Set<EObject>> availableLinks;

        public LinkContentProvider(Map<EditPart, Set<EObject>> availableLinks) {
            this.availableLinks = availableLinks;
        }

        public void dispose() {
            this.availableLinks.clear();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (this.availableLinks.containsKey(parentElement)) {
                return this.availableLinks.get(parentElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            for (Map.Entry<EditPart, Set<EObject>> current : this.availableLinks.entrySet()) {
                if (!current.getValue().contains(element)) continue;
                return current.getKey();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (this.availableLinks.containsKey(element)) {
                return this.availableLinks.get(element).size() != 0;
            }
            return false;
        }
    }
}

