/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.ThreeWayTextDiff;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractConflictSearch<T extends Diff> {
    protected final T diff;
    protected final Comparison comparison;
    protected final ComparisonIndex index;
    protected final Monitor monitor;

    public AbstractConflictSearch(T diff, ComparisonIndex index, Monitor monitor) {
        Preconditions.checkNotNull(diff);
        if (diff.getMatch() == null || diff.getMatch().getComparison() == null) {
            throw new IllegalArgumentException();
        }
        this.comparison = diff.getMatch().getComparison();
        Preconditions.checkArgument((diff.getKind() != null && diff.getSource() != null ? 1 : 0) != 0);
        this.diff = diff;
        this.index = (ComparisonIndex)Preconditions.checkNotNull((Object)index);
        this.monitor = (Monitor)Preconditions.checkNotNull((Object)monitor);
    }

    public abstract void detectConflicts();

    protected EList<Diff> getDiffsInSameMatch() {
        return this.diff.getMatch().getDifferences();
    }

    protected boolean isFeatureMapChangeOrMergeableStringAttributeChange(Diff diff1, Diff diff2) {
        return this.isFeatureMapChange(diff1) || this.areMergeableStringAttributeChanges(diff1, diff2);
    }

    protected boolean isFeatureMapChange(Diff toCheck) {
        return toCheck instanceof FeatureMapChange;
    }

    protected boolean areMergeableStringAttributeChanges(Diff diff1, Diff diff2) {
        boolean mergeableStringAttributeChange;
        if (this.isStringAttributeChange(diff1)) {
            AttributeChange attributeChange1 = (AttributeChange)diff1;
            AttributeChange attributeChange2 = (AttributeChange)diff2;
            mergeableStringAttributeChange = this.isMergeable(attributeChange1, attributeChange2);
        } else {
            mergeableStringAttributeChange = false;
        }
        return mergeableStringAttributeChange;
    }

    protected boolean isStringAttributeChange(Diff toCheck) {
        return toCheck instanceof AttributeChange && ((AttributeChange)toCheck).getAttribute().getEAttributeType().getInstanceClass() == String.class;
    }

    protected boolean isMergeable(AttributeChange diff1, AttributeChange diff2) {
        String changedValue1 = this.getChangedValue(diff1);
        String changedValue2 = this.getChangedValue(diff2);
        EObject originalContainer = diff1.getMatch().getOrigin();
        EAttribute changedAttribute = diff1.getAttribute();
        String originalValue = (String)ReferenceUtil.safeEGet(originalContainer, (EStructuralFeature)changedAttribute);
        return this.isMergeableText(changedValue1, changedValue2, originalValue);
    }

    protected boolean isMergeableText(String left, String right, String origin) {
        ThreeWayTextDiff textDiff = new ThreeWayTextDiff(origin, left, right);
        return !textDiff.isConflicting();
    }

    protected String getChangedValue(AttributeChange attributeChange) {
        Match match = attributeChange.getMatch();
        String changedValue = DifferenceSource.LEFT.equals((Object)attributeChange.getSource()) ? (String)ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)attributeChange.getAttribute()) : (DifferenceSource.RIGHT.equals((Object)attributeChange.getSource()) ? (String)ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)attributeChange.getAttribute()) : (String)attributeChange.getValue());
        return changedValue;
    }

    protected void conflict(Diff other, ConflictKind kind) {
        ConflictKind conflictKind;
        Equivalence equivalence;
        ConflictKind conflictKind2;
        Conflict diffConflict = this.diff.getConflict();
        if (diffConflict != null && diffConflict.getDifferences().contains((Object)other)) {
            return;
        }
        Conflict conflict = null;
        Conflict toBeMerged = null;
        Conflict otherConflict = other.getConflict();
        if (diffConflict != null) {
            conflict = diffConflict;
            conflictKind2 = conflict.getKind();
            if (conflictKind2 == ConflictKind.PSEUDO && conflictKind2 != kind) {
                conflict.setKind(kind);
            }
            if (otherConflict != null) {
                toBeMerged = otherConflict;
            }
        } else if (otherConflict != null) {
            conflict = otherConflict;
            conflictKind2 = conflict.getKind();
            if (conflictKind2 == ConflictKind.PSEUDO && conflictKind2 != kind) {
                conflict.setKind(kind);
            }
        } else if (this.diff.getEquivalence() != null) {
            equivalence = this.diff.getEquivalence();
            for (Diff equ : equivalence.getDifferences()) {
                conflict = equ.getConflict();
                if (conflict == null) continue;
                conflictKind = conflict.getKind();
                if (conflictKind != ConflictKind.PSEUDO || conflictKind == kind) break;
                conflict.setKind(kind);
                break;
            }
        } else if (other.getEquivalence() != null) {
            equivalence = other.getEquivalence();
            for (Diff equ : equivalence.getDifferences()) {
                conflict = equ.getConflict();
                if (conflict == null) continue;
                conflictKind = conflict.getKind();
                if (conflictKind != ConflictKind.PSEUDO || conflictKind == kind) break;
                conflict.setKind(kind);
                break;
            }
        }
        if (conflict == null) {
            conflict = CompareFactory.eINSTANCE.createConflict();
            conflict.setKind(kind);
            this.comparison.getConflicts().add((Object)conflict);
        }
        EList<Diff> conflictDiffs = conflict.getDifferences();
        if (toBeMerged != null) {
            for (Diff aDiff : Lists.newArrayList(toBeMerged.getDifferences())) {
                conflictDiffs.add((Object)aDiff);
            }
            if (toBeMerged.getKind() == ConflictKind.REAL && conflict.getKind() != ConflictKind.REAL) {
                conflict.setKind(ConflictKind.REAL);
            }
            EcoreUtil.remove((EObject)toBeMerged);
            toBeMerged.getDifferences().clear();
        }
        LinkedHashSet toAdd = Sets.newLinkedHashSet();
        for (Diff conflicting : ImmutableSet.of(this.diff, (Object)other)) {
            if (conflicting.getEquivalence() == null) {
                toAdd.add(conflicting);
                continue;
            }
            toAdd.addAll(conflicting.getEquivalence().getDifferences());
        }
        conflictDiffs.addAll((Collection)toAdd);
    }

    protected MatchResource getMatchResource(Resource resource) {
        EList<MatchResource> matchedResources = this.comparison.getMatchedResources();
        int size = matchedResources.size();
        MatchResource soughtMatch = null;
        int i = 0;
        while (i < size && soughtMatch == null) {
            MatchResource matchRes = (MatchResource)matchedResources.get(i);
            if (matchRes.getRight() == resource || matchRes.getLeft() == resource || matchRes.getOrigin() == resource) {
                soughtMatch = matchRes;
            }
            ++i;
        }
        Preconditions.checkState((soughtMatch != null ? 1 : 0) != 0, (Object)EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingMatch", resource.getURI().lastSegment()));
        return soughtMatch;
    }

    protected EObject getRelatedModelElement(ResourceAttachmentChange rac) {
        EObject o;
        Match m = rac.getMatch();
        switch (rac.getSource()) {
            case LEFT: {
                o = m.getLeft();
                break;
            }
            case RIGHT: {
                o = m.getRight();
                break;
            }
            default: {
                o = null;
            }
        }
        return o;
    }

    protected EObject getValue(ResourceAttachmentChange rac) {
        EObject o;
        Match m = rac.getMatch();
        block0 : switch (rac.getKind()) {
            case ADD: 
            case CHANGE: 
            case MOVE: {
                switch (rac.getSource()) {
                    case LEFT: {
                        o = m.getLeft();
                        break block0;
                    }
                    case RIGHT: {
                        o = m.getRight();
                        break block0;
                    }
                }
                o = null;
                break;
            }
            case DELETE: {
                o = m.getOrigin();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Preconditions.checkState((o != null ? 1 : 0) != 0);
        return o;
    }

    protected Predicate<? super Match> isContainmentDelete() {
        return new Predicate<Match>(){

            public boolean apply(Match input) {
                return input.getOrigin() != null && (input.getLeft() == null || input.getRight() == null);
            }
        };
    }
}

