/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.internal.conflict.DiffTreeIterator;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ContainmentRefChangeConflictSearch {

    public static class Add
    extends AbstractConflictSearch<ReferenceChange> {
        public Add(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            EReference feature = ((ReferenceChange)this.diff).getReference();
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            for (ReferenceChange candidate : Iterables.filter(refChanges, (Predicate)Predicates.and(EMFComparePredicates.possiblyConflictingWith(this.diff), EMFComparePredicates.ofKind(DifferenceKind.ADD, DifferenceKind.CHANGE)))) {
                if (!candidate.getReference().isContainment()) continue;
                if (candidate.getReference() == feature && candidate.getMatch() == ((ReferenceChange)this.diff).getMatch() && MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidate.getValue())) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            if (!feature.isMany()) {
                for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.ADD, DifferenceKind.CHANGE)}))) {
                    if (this.comparison.getEqualityHelper().matchingValues(((ReferenceChange)candidate).getValue(), ((ReferenceChange)this.diff).getValue())) {
                        this.conflict(candidate, ConflictKind.PSEUDO);
                        continue;
                    }
                    this.conflict(candidate, ConflictKind.REAL);
                }
            }
        }
    }

    public static class Change
    extends AbstractConflictSearch<ReferenceChange> {
        public Change(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            block6: {
                EList<Diff> diffsInSameMatch;
                EReference feature;
                EObject value;
                block5: {
                    value = ((ReferenceChange)this.diff).getValue();
                    feature = ((ReferenceChange)this.diff).getReference();
                    Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
                    for (ReferenceChange candidate : Iterables.filter(refChanges, (Predicate)Predicates.and(EMFComparePredicates.possiblyConflictingWith(this.diff), EMFComparePredicates.ofKind(DifferenceKind.ADD, DifferenceKind.CHANGE)))) {
                        if (!candidate.getReference().isContainment()) continue;
                        if (candidate.getReference() == feature && candidate.getMatch() == ((ReferenceChange)this.diff).getMatch()) {
                            this.conflict(candidate, ConflictKind.PSEUDO);
                            continue;
                        }
                        this.conflict(candidate, ConflictKind.REAL);
                    }
                    diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
                    if (feature.isMany() || !ComparisonUtil.isAddOrSetDiff(this.diff)) break block5;
                    for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature)}))) {
                        if (this.comparison.getEqualityHelper().matchingValues(((ReferenceChange)candidate).getValue(), ((ReferenceChange)this.diff).getValue())) {
                            this.conflict(candidate, ConflictKind.PSEUDO);
                            continue;
                        }
                        this.conflict(candidate, ConflictKind.REAL);
                    }
                    break block6;
                }
                if (ComparisonUtil.isDeleteOrUnsetDiff(this.diff)) break block6;
                for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature)}))) {
                    if (ComparisonUtil.isDeleteOrUnsetDiff(candidate) || ((ReferenceChange)this.diff).getReference() != ((ReferenceChange)candidate).getReference() || !MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)((ReferenceChange)this.diff).getReference(), value, ((ReferenceChange)candidate).getValue())) continue;
                    this.conflict(candidate, ConflictKind.PSEUDO);
                }
            }
        }
    }

    public static class Delete
    extends AbstractConflictSearch<ReferenceChange> {
        public Delete(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            Predicate<Diff> possiblyConflictingWithDiff = EMFComparePredicates.possiblyConflictingWith(this.diff);
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            for (ReferenceChange candidate : Iterables.filter(refChanges, possiblyConflictingWithDiff)) {
                if (ComparisonUtil.isDeleteOrUnsetDiff(candidate)) continue;
                this.conflict(candidate, ConflictKind.REAL);
            }
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), possiblyConflictingWithDiff, EMFComparePredicates.valueMatches(this.comparison.getEqualityHelper(), value)}))) {
                if (ComparisonUtil.isDeleteOrUnsetDiff(candidate)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
            DiffTreeIterator diffIterator = new DiffTreeIterator(this.comparison.getMatch(value));
            diffIterator.setFilter(possiblyConflictingWithDiff);
            diffIterator.setPruningFilter(this.isContainmentDelete());
            while (diffIterator.hasNext()) {
                Diff extendedCandidate = diffIterator.next();
                if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) continue;
                this.conflict(extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    public static class Move
    extends AbstractConflictSearch<ReferenceChange> {
        public Move(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            EReference feature = ((ReferenceChange)this.diff).getReference();
            Predicate<Diff> possiblyConflictingWithDiff = EMFComparePredicates.possiblyConflictingWith(this.diff);
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            for (ReferenceChange candidate : Iterables.filter(refChanges, (Predicate)Predicates.and(EMFComparePredicates.ofKind(DifferenceKind.MOVE), possiblyConflictingWithDiff))) {
                if (!candidate.getReference().isContainment()) continue;
                if (candidate.getReference() == feature && candidate.getMatch() == ((ReferenceChange)this.diff).getMatch() && MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidate.getValue())) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), possiblyConflictingWithDiff, EMFComparePredicates.valueMatches(this.comparison.getEqualityHelper(), value)}))) {
                if (MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)((ReferenceChange)this.diff).getReference(), value, ((ReferenceChange)candidate).getValue())) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }
}

