/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.req;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

public class DefaultReqEngine
implements IReqEngine {
    private static final Logger LOGGER = Logger.getLogger(DefaultReqEngine.class);

    @Override
    public void computeRequirements(Comparison comparison, Monitor monitor) {
        long start = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("detect requirements - START", new Object[0]));
        }
        monitor.subTask(EMFCompareMessages.getString("DefaultReqEngine.monitor.req"));
        for (Diff difference : comparison.getDifferences()) {
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
            this.checkForRequiredDifferences(comparison, difference);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("detect requirement - END - Took %d ms", System.currentTimeMillis() - start));
        }
    }

    protected void checkForRequiredDifferences(Comparison comparison, Diff difference) {
        Match match = difference.getMatch();
        EObject value = DefaultReqEngine.getValue(comparison, difference);
        if (value != null) {
            boolean isDeletion;
            LinkedHashSet<Diff> requiredDifferences = new LinkedHashSet<Diff>();
            LinkedHashSet<Diff> requiredByDifferences = new LinkedHashSet<Diff>();
            DifferenceKind kind = difference.getKind();
            boolean isAddition = ComparisonUtil.isAddOrSetDiff(difference);
            boolean bl = isDeletion = !isAddition && ComparisonUtil.isDeleteOrUnsetDiff(difference);
            if (isAddition && this.isDeleteOrAddResourceAttachmentChange(comparison, difference)) {
                requiredDifferences.addAll(this.getDiffsThatShouldDependOn((ResourceAttachmentChange)difference));
            } else if (isAddition && DefaultReqEngine.isReferenceContainment(difference)) {
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value.eContainer(), difference.getSource(), DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDELOriginValueOnContainmentRefSingle(comparison, difference));
            } else if (isAddition && !ComparisonUtil.isFeatureMapContainment(difference)) {
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, difference.getSource(), DifferenceKind.ADD));
                EObject container = MatchUtil.getContainer(comparison, difference);
                if (container != null) {
                    requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, difference.getSource(), DifferenceKind.ADD));
                }
                requiredDifferences.addAll(Collections2.filter(match.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), EMFComparePredicates.ofKind(DifferenceKind.ADD))));
            } else if (isDeletion && this.isDeleteOrAddResourceAttachmentChange(comparison, difference)) {
                requiredByDifferences.addAll(this.getDiffsThatShouldDependOn((ResourceAttachmentChange)difference));
            } else if (isDeletion && DefaultReqEngine.isReferenceContainment(difference)) {
                requiredDifferences.addAll(this.getDELOutgoingReferences(comparison, difference));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, (List<EObject>)value.eContents(), difference.getSource(), DifferenceKind.DELETE));
                requiredDifferences.addAll(this.getMOVEContainedObjects(comparison, difference));
            } else if (isDeletion && !ComparisonUtil.isFeatureMapContainment(difference)) {
                requiredByDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, difference.getSource(), DifferenceKind.DELETE));
            } else if (kind == DifferenceKind.MOVE && DefaultReqEngine.isReferenceContainment(difference)) {
                EObject container = value.eContainer();
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, difference.getSource(), DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, difference.getSource(), DifferenceKind.MOVE));
            } else if (!(kind != DifferenceKind.CHANGE || isAddition || isDeletion || difference instanceof FeatureMapChange)) {
                requiredByDifferences.addAll(this.getDifferenceOnGivenObject(comparison, MatchUtil.getOriginValue(comparison, (ReferenceChange)difference), difference.getSource(), DifferenceKind.DELETE));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, difference.getSource(), DifferenceKind.ADD));
            }
            difference.getRequires().addAll(Collections2.filter(requiredDifferences, EMFComparePredicates.fromSide(difference.getSource())));
            difference.getRequiredBy().addAll(Collections2.filter(requiredByDifferences, EMFComparePredicates.fromSide(difference.getSource())));
        }
    }

    private boolean isDeleteOrAddResourceAttachmentChange(Comparison comparison, Diff diff) {
        EObject container;
        if (diff instanceof ResourceAttachmentChange && (diff.getKind() == DifferenceKind.ADD || diff.getKind() == DifferenceKind.DELETE) && (container = MatchUtil.getContainer(comparison, diff)) != null) {
            EList<Diff> differences = comparison.getDifferences(container);
            for (Diff containedDiff : differences) {
                if (!(containedDiff instanceof ReferenceChange) || !((ReferenceChange)containedDiff).getReference().isContainment() || containedDiff.getKind() != diff.getKind()) continue;
                return true;
            }
        }
        return false;
    }

    private Set<ReferenceChange> getDiffsThatShouldDependOn(ResourceAttachmentChange diff) {
        LinkedHashSet<ReferenceChange> result = new LinkedHashSet<ReferenceChange>();
        Comparison comparison = diff.getMatch().getComparison();
        EObject container = MatchUtil.getContainer(comparison, diff);
        for (ReferenceChange rc : Iterables.filter(comparison.getDifferences(container), ReferenceChange.class)) {
            if (diff.getSource() != rc.getSource() || diff.getKind() != rc.getKind()) continue;
            result.add(rc);
        }
        return result;
    }

    private Set<Diff> getDELOriginValueOnContainmentRefSingle(Comparison comparison, Diff sourceDifference) {
        Object originValue;
        EObject originContainer;
        Set<Diff> result = new LinkedHashSet<Diff>();
        if (!(sourceDifference instanceof ReferenceChange)) {
            return result;
        }
        EReference reference = ((ReferenceChange)sourceDifference).getReference();
        if (!reference.isMany() && (originContainer = MatchUtil.getOriginContainer(comparison, sourceDifference)) != null && (originValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)reference)) instanceof EObject) {
            result = this.getDifferenceOnGivenObject(comparison, (EObject)originValue, sourceDifference.getSource(), DifferenceKind.DELETE);
        }
        return result;
    }

    private Set<Diff> getDifferenceOnGivenObject(Comparison comparison, EObject object, DifferenceSource source, DifferenceKind kind) {
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        for (Diff diff : Iterables.filter(comparison.getDifferences(object), this.isRequiredContainmentChange(object, source, kind))) {
            result.add(diff);
        }
        return result;
    }

    private Predicate<? super Diff> isRequiredContainmentChange(final EObject object, final DifferenceSource source, final DifferenceKind kind) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input == null || input.getKind() != kind || input.getSource() != source) {
                    return false;
                }
                boolean result = false;
                if (input instanceof ReferenceChange && ((ReferenceChange)input).getReference().isContainment()) {
                    result = true;
                } else if (input instanceof ResourceAttachmentChange && object.eContainer() == null) {
                    result = true;
                }
                return result;
            }
        };
    }

    private Set<Diff> getDifferenceOnGivenObject(Comparison comparison, List<EObject> objects, DifferenceSource source, DifferenceKind kind) {
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        for (EObject object : objects) {
            result.addAll(this.getDifferenceOnGivenObject(comparison, object, source, kind));
        }
        return result;
    }

    private Set<Diff> getDELOutgoingReferences(Comparison comparison, Diff sourceDifference) {
        Match valueMatch;
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        EObject value = DefaultReqEngine.getValue(comparison, sourceDifference);
        if (value != null && (valueMatch = comparison.getMatch(value)) != null) {
            for (Diff candidate : Iterables.filter(valueMatch.getDifferences(), (Predicate)Predicates.or((Predicate)Predicates.instanceOf(ReferenceChange.class), (Predicate)Predicates.instanceOf(FeatureMapChange.class)))) {
                if (candidate.getSource() != sourceDifference.getSource() || candidate.getKind() != DifferenceKind.DELETE && !ComparisonUtil.isDeleteOrUnsetDiff(candidate)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private Set<ReferenceChange> getMOVEContainedObjects(Comparison comparison, Diff sourceDifference) {
        LinkedHashSet<ReferenceChange> result = new LinkedHashSet<ReferenceChange>();
        EObject value = DefaultReqEngine.getValue(comparison, sourceDifference);
        if (value != null) {
            EList contents = value.eContents();
            for (EObject content : contents) {
                EObject originObject = MatchUtil.getOriginObject(comparison, content);
                if (originObject == null) continue;
                for (ReferenceChange difference : Iterables.filter(comparison.getDifferences(originObject), ReferenceChange.class)) {
                    if (!difference.getReference().isContainment() || difference.getSource() != sourceDifference.getSource() || difference.getKind() != DifferenceKind.MOVE) continue;
                    result.add(difference);
                }
            }
        }
        return result;
    }

    private static boolean isReferenceContainment(Diff diff) {
        return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() || diff instanceof ResourceAttachmentChange || diff instanceof FeatureMapChange;
    }

    private static EObject getValue(Comparison comparison, Diff diff) {
        Object entryValue;
        Object entry;
        EObject value = null;
        if (diff instanceof ReferenceChange) {
            value = ((ReferenceChange)diff).getValue();
        } else if (diff instanceof ResourceAttachmentChange) {
            value = MatchUtil.getContainer(comparison, diff);
        } else if (diff instanceof FeatureMapChange && (entry = ((FeatureMapChange)diff).getValue()) instanceof FeatureMap.Entry && (entryValue = ((FeatureMap.Entry)entry).getValue()) instanceof EObject) {
            value = (EObject)entryValue;
        }
        return value;
    }
}

