/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.merge;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeSubscriber;
import org.eclipse.emf.compare.egit.internal.merge.LogicalModels;
import org.eclipse.emf.compare.egit.internal.merge.MergeText;
import org.eclipse.emf.compare.egit.internal.merge.TreeWalkResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.storage.AbstractGitResourceVariant;
import org.eclipse.emf.compare.egit.internal.storage.TreeParserResourceVariant;
import org.eclipse.emf.compare.egit.internal.wrapper.JGitProgressMonitorWrapper;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.RecursiveMerger;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceMappingMerger;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.core.variants.IResourceVariant;

public class RecursiveModelMerger
extends RecursiveMerger {
    private static final Logger LOGGER = Logger.getLogger(RecursiveModelMerger.class);
    private final Set<String> makeInSync = new LinkedHashSet<String>();
    private final Set<String> handledPaths = new HashSet<String>();

    public RecursiveModelMerger(Repository db, boolean inCore) {
        super(db, inCore);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean ignoreConflicts) throws IOException {
        if (RecursiveModelMerger.LOGGER.isInfoEnabled()) {
            RecursiveModelMerger.LOGGER.info((Object)"STARTING Recursive model merge.");
        }
        variantTreeProvider = new TreeWalkResourceVariantTreeProvider(this.getRepository(), treeWalk, 0, 1, 2);
        subscriber = new GitResourceVariantTreeSubscriber(variantTreeProvider);
        remoteMappingContext = new SubscriberResourceMappingContext((Subscriber)subscriber, true);
        try {
            this.refreshRoots(subscriber.roots());
        }
        catch (CoreException e) {
            Activator.logError((String)MergeText.RecursiveModelMerger_RefreshError, (Throwable)e);
            return super.mergeTreeWalk(treeWalk, ignoreConflicts);
        }
        this.monitor.beginTask(MergeText.RecursiveModelMerger_BuildLogicalModels, 0);
        logicalModels = new LogicalModels();
        logicalModels.build(variantTreeProvider.getKnownResources(), (RemoteResourceMappingContext)remoteMappingContext);
        this.monitor.endTask();
        if (!this.monitor.isCancelled()) ** GOTO lbl71
        throw new OperationCanceledException();
lbl-1000:
        // 1 sources

        {
            block21: {
                modeBase = treeWalk.getRawMode(0);
                modeOurs = treeWalk.getRawMode(1);
                modeTheirs = treeWalk.getRawMode(2);
                if (modeBase == 0 && modeOurs == 0 && modeTheirs == 0) continue;
                path = treeWalk.getPathString();
                if (this.handledPaths.contains(path)) {
                    if (treeWalk.isSubtree() && this.enterSubtree) {
                        treeWalk.enterSubtree();
                    }
                    if (this.unmergedPaths.contains(path)) continue;
                    this.registerMergedPath(path);
                    if (!RecursiveModelMerger.LOGGER.isDebugEnabled()) continue;
                    RecursiveModelMerger.LOGGER.debug((Object)("Ignoring previously handled file: " + path));
                    continue;
                }
                nonZeroMode = modeBase != 0 ? modeBase : (modeOurs != 0 ? modeOurs : modeTheirs);
                resource = variantTreeProvider.getResourceHandleForLocation(this.getRepository(), path, FileMode.fromBits((int)nonZeroMode) == FileMode.TREE);
                logicalModel = logicalModels.getModel(resource);
                modelMerger = null;
                if (logicalModel != null) {
                    try {
                        this.refreshRoots(subscriber.roots());
                        modelMerger = this.getResourceMappingMerger(logicalModel);
                    }
                    catch (CoreException e) {
                        Activator.logError((String)MergeText.RecursiveModelMerger_AdaptError, (Throwable)e);
                        if (this.fallBackToDefaultMerge(treeWalk, ignoreConflicts)) break block21;
                        this.cleanUp();
                        if (RecursiveModelMerger.LOGGER.isInfoEnabled()) {
                            RecursiveModelMerger.LOGGER.info((Object)"FAILED - Recursive model merge, could not find appropriate merger and default merge failed.");
                        }
                        return false;
                    }
                }
            }
            if (modelMerger != null) {
                this.enterSubtree = true;
                success = ModelMerge.access$1(new ModelMerge(this, subscriber, (RemoteResourceMappingContext)remoteMappingContext, path, logicalModel, modelMerger), new JGitProgressMonitorWrapper(this.monitor));
                if (!success) {
                    if (RecursiveModelMerger.LOGGER.isInfoEnabled()) {
                        RecursiveModelMerger.LOGGER.info((Object)"FAILED - Recursive model merge.");
                    }
                    return false;
                }
                if (!this.unmergedPaths.contains(path)) {
                    if (RecursiveModelMerger.LOGGER.isDebugEnabled()) {
                        RecursiveModelMerger.LOGGER.debug((Object)("Merged model file: " + path));
                    }
                    this.registerMergedPath(path);
                }
                if (treeWalk.isSubtree()) {
                    this.enterSubtree = true;
                }
            } else if (!this.fallBackToDefaultMerge(treeWalk, ignoreConflicts)) {
                this.cleanUp();
                if (RecursiveModelMerger.LOGGER.isInfoEnabled()) {
                    RecursiveModelMerger.LOGGER.info((Object)"FAILED - Recursive model merge, default merge failed.");
                }
                return false;
            }
            if (!treeWalk.isSubtree() || !this.enterSubtree) continue;
            treeWalk.enterSubtree();
lbl71:
            // 7 sources

            ** while (treeWalk.next())
        }
lbl72:
        // 1 sources

        if (!this.makeInSync.isEmpty()) {
            this.indexModelMergedFiles();
        }
        if (RecursiveModelMerger.LOGGER.isInfoEnabled()) {
            RecursiveModelMerger.LOGGER.info((Object)"SUCCESS - Recursive model merge.");
        }
        return true;
    }

    protected IResourceMappingMerger getResourceMappingMerger(Set<IResource> logicalModel) throws CoreException {
        return LogicalModels.findAdapter(logicalModel, IResourceMappingMerger.class);
    }

    private boolean fallBackToDefaultMerge(TreeWalk treeWalk, boolean ignoreConflicts) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        boolean hasWorkingTreeIterator = this.tw.getTreeCount() > 4;
        return this.processEntry((CanonicalTreeParser)treeWalk.getTree(0, CanonicalTreeParser.class), (CanonicalTreeParser)treeWalk.getTree(1, CanonicalTreeParser.class), (CanonicalTreeParser)treeWalk.getTree(2, CanonicalTreeParser.class), (DirCacheBuildIterator)treeWalk.getTree(3, DirCacheBuildIterator.class), hasWorkingTreeIterator ? (WorkingTreeIterator)treeWalk.getTree(4, WorkingTreeIterator.class) : null, ignoreConflicts);
    }

    private void indexModelMergedFiles() throws CorruptObjectException, MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TreeWalk syncingTreeWalk = new TreeWalk(this.getRepository());){
            syncingTreeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(this.dircache));
            syncingTreeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(this.getRepository()));
            syncingTreeWalk.setRecursive(true);
            syncingTreeWalk.setFilter(PathFilterGroup.createFromStrings(this.makeInSync));
            String lastAdded = null;
            while (syncingTreeWalk.next()) {
                String path = syncingTreeWalk.getPathString();
                if (path.equals(lastAdded)) continue;
                WorkingTreeIterator workingTree = (WorkingTreeIterator)syncingTreeWalk.getTree(1, WorkingTreeIterator.class);
                DirCacheIterator dirCache = (DirCacheIterator)syncingTreeWalk.getTree(0, DirCacheIterator.class);
                if (dirCache == null && workingTree != null && workingTree.isEntryIgnored()) continue;
                if (workingTree != null) {
                    if (dirCache == null || dirCache.getDirCacheEntry() == null || !dirCache.getDirCacheEntry().isAssumeValid()) {
                        DirCacheEntry dce;
                        block22: {
                            dce = new DirCacheEntry(path);
                            FileMode mode = workingTree.getIndexFileMode(dirCache);
                            dce.setFileMode(mode);
                            if (FileMode.GITLINK != mode) {
                                dce.setLength(workingTree.getEntryLength());
                                dce.setLastModified(workingTree.getEntryLastModified());
                                Throwable throwable2 = null;
                                Object var11_14 = null;
                                try (InputStream is = workingTree.openEntryStream();){
                                    dce.setObjectId((AnyObjectId)this.getObjectInserter().insert(3, workingTree.getEntryContentLength(), is));
                                    break block22;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            dce.setObjectId((AnyObjectId)workingTree.getEntryObjectId());
                        }
                        this.builder.add(dce);
                        lastAdded = path;
                        continue;
                    }
                    this.builder.add(dirCache.getDirCacheEntry());
                    continue;
                }
                if (dirCache == null || FileMode.GITLINK != dirCache.getEntryFileMode()) continue;
                this.builder.add(dirCache.getDirCacheEntry());
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static String getRepoRelativePath(IResource file) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
        if (mapping != null) {
            return mapping.getRepoRelativePath(file);
        }
        return null;
    }

    private void refreshRoots(IResource[] resources) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            if (root.isAccessible()) {
                root.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
    }

    private void markConflict(String filePath, DirCacheBuilder cacheBuilder, TreeParserResourceVariant baseVariant, TreeParserResourceVariant ourVariant, TreeParserResourceVariant theirVariant) {
        this.add(filePath, cacheBuilder, baseVariant, 1);
        this.add(filePath, cacheBuilder, ourVariant, 2);
        this.add(filePath, cacheBuilder, theirVariant, 3);
    }

    private void add(String path, DirCacheBuilder cacheBuilder, TreeParserResourceVariant variant, int stage) {
        if (variant != null && !FileMode.TREE.equals(variant.getRawMode())) {
            DirCacheEntry e = new DirCacheEntry(path, stage);
            e.setFileMode(FileMode.fromBits((int)variant.getRawMode()));
            e.setObjectId((AnyObjectId)variant.getObjectId());
            e.setLastModified(0L);
            e.setLength(0);
            cacheBuilder.add(e);
        }
    }

    private void addSyncPath(IResource resource) {
        String repoRelativePath = RecursiveModelMerger.getRepoRelativePath(resource);
        this.registerMergedPath(repoRelativePath);
    }

    private boolean registerMergedPath(String path) {
        if (path != null && !this.unmergedPaths.contains(path)) {
            return this.makeInSync.add(path);
        }
        return false;
    }

    private static class GitMergeContext
    extends SubscriberMergeContext {
        private final RecursiveModelMerger merger;

        public GitMergeContext(RecursiveModelMerger merger, Subscriber subscriber, ISynchronizationScopeManager scopeManager) {
            super(subscriber, scopeManager);
            this.merger = merger;
            this.initialize();
        }

        public void markAsMerged(IDiff node, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
            IResource resource = this.getDiffTree().getResource(node);
            this.merger.addSyncPath(resource);
        }

        public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        }

        protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
            IResource resource = this.getDiffTree().getResource(diff);
            this.merger.addSyncPath(resource);
        }
    }

    private static class ModelMerge {
        private final RecursiveModelMerger merger;
        private final GitResourceVariantTreeSubscriber subscriber;
        private final RemoteResourceMappingContext remoteMappingContext;
        private final String path;
        private final Set<IResource> logicalModel;
        private final IResourceMappingMerger modelMerger;

        public ModelMerge(RecursiveModelMerger merger, GitResourceVariantTreeSubscriber subscriber, RemoteResourceMappingContext remoteMappingContext, String path, Set<IResource> logicalModel, IResourceMappingMerger modelMerger) {
            this.merger = merger;
            this.subscriber = subscriber;
            this.remoteMappingContext = remoteMappingContext;
            this.path = path;
            this.logicalModel = logicalModel;
            this.modelMerger = modelMerger;
        }

        private boolean run(IProgressMonitor monitor) throws CorruptObjectException, IOException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            try {
                IMergeContext mergeContext = this.prepareMergeContext();
                IStatus status = this.modelMerger.merge(mergeContext, (IProgressMonitor)progress.newChild(1));
                this.registerHandledFiles(mergeContext, status);
            }
            catch (CoreException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
                this.merger.cleanUp();
                return false;
            }
            catch (OperationCanceledException e) {
                String message = NLS.bind((String)MergeText.RecursiveModelMerger_ScopeInitializationInterrupted, (Object)this.path);
                Activator.logError((String)message, (Throwable)e);
                this.merger.cleanUp();
                return false;
            }
            return true;
        }

        private void registerHandledFiles(IMergeContext mergeContext, IStatus status) throws TeamException, CoreException {
            for (IResource handledFile : this.logicalModel) {
                String filePath = RecursiveModelMerger.getRepoRelativePath(handledFile);
                if (filePath == null) {
                    IResourceVariant sourceVariant = this.subscriber.getSourceTree().getResourceVariant(handledFile);
                    IResourceVariant remoteVariant = this.subscriber.getRemoteTree().getResourceVariant(handledFile);
                    IResourceVariant baseVariant = this.subscriber.getBaseTree().getResourceVariant(handledFile);
                    if (sourceVariant instanceof AbstractGitResourceVariant) {
                        filePath = ((AbstractGitResourceVariant)sourceVariant).getPath();
                    }
                    if (filePath == null && remoteVariant instanceof AbstractGitResourceVariant) {
                        filePath = ((AbstractGitResourceVariant)remoteVariant).getPath();
                    }
                    if (filePath == null && baseVariant instanceof AbstractGitResourceVariant) {
                        filePath = ((AbstractGitResourceVariant)baseVariant).getPath();
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Registering handled file " + filePath));
                }
                if (this.merger.handledPaths.contains(filePath)) continue;
                if (filePath != null) {
                    this.merger.modifiedFiles.add(filePath);
                    this.merger.handledPaths.add(filePath);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Impossible to compute a repo-relative filePath for file " + handledFile));
                }
                if (mergeContext.getDiffTree().getDiff(handledFile) == null) {
                    this.merger.registerMergedPath(filePath);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("Merged non-modified file: " + filePath));
                    continue;
                }
                if (filePath == null || status.getSeverity() == 0) continue;
                if (this.merger.makeInSync.contains(filePath)) {
                    this.merger.makeInSync.remove(filePath);
                }
                this.merger.unmergedPaths.add(filePath);
                this.merger.mergeResults.put(filePath, new MergeResult(Collections.emptyList()));
                TreeParserResourceVariant baseVariant = (TreeParserResourceVariant)this.subscriber.getBaseTree().getResourceVariant(handledFile);
                TreeParserResourceVariant ourVariant = (TreeParserResourceVariant)this.subscriber.getSourceTree().getResourceVariant(handledFile);
                TreeParserResourceVariant theirVariant = (TreeParserResourceVariant)this.subscriber.getRemoteTree().getResourceVariant(handledFile);
                this.merger.markConflict(filePath, this.merger.builder, baseVariant, ourVariant, theirVariant);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Marking conflict on " + filePath));
            }
        }

        private IMergeContext prepareMergeContext() throws CoreException, OperationCanceledException {
            Set<ResourceMapping> allMappings = LogicalModels.getResourceMappings(this.logicalModel, (ResourceMappingContext)this.remoteMappingContext);
            ResourceMapping[] mappings = allMappings.toArray(new ResourceMapping[allMappings.size()]);
            SubscriberScopeManager manager = new SubscriberScopeManager(this.subscriber.getName(), mappings, (Subscriber)this.subscriber, this.remoteMappingContext, true){

                public ISchedulingRule getSchedulingRule() {
                    return RuleUtil.getRule((Repository)ModelMerge.this.merger.getRepository());
                }
            };
            manager.initialize((IProgressMonitor)new NullProgressMonitor());
            GitMergeContext context = new GitMergeContext(this.merger, (Subscriber)this.subscriber, (ISynchronizationScopeManager)manager);
            this.waitForScope((IMergeContext)context);
            return context;
        }

        private void waitForScope(IMergeContext context) {
            boolean joined = false;
            while (!joined) {
                try {
                    Job.getJobManager().join((Object)context, (IProgressMonitor)new NullProgressMonitor());
                    joined = true;
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        static /* synthetic */ boolean access$1(ModelMerge modelMerge, IProgressMonitor iProgressMonitor) throws CorruptObjectException, IOException {
            return modelMerge.run(iProgressMonitor);
        }
    }
}

