/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.StandardVM;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.ILibraryLocationResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.osgi.util.NLS;

public class StandardVMType
extends AbstractVMInstallType {
    private static final String RT_JAR = "rt.jar";
    private static final String SRC = "src";
    private static final String SRC_ZIP = "src.zip";
    private static final String SRC_JAR = "src.jar";
    private static final String JRE = "jre";
    private static final String LIB = "lib";
    private static final String BAR = "|";
    public static final String ID_STANDARD_VM_TYPE = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    public static final String MIN_VM_SIZE = "-Xmx16m";
    private static FilenameFilter fgArchiveFilter = new FilenameFilter(){

        @Override
        public boolean accept(File arg0, String arg1) {
            return arg1.endsWith(".zip") || arg1.endsWith(".jar");
        }
    };
    private String fDefaultRootPath = "";
    private static Map<String, LibraryInfo> fgFailedInstallPath = new HashMap<String, LibraryInfo>();
    private static Map<String, List<LibraryLocation>> fgDefaultLibLocs = new HashMap<String, List<LibraryLocation>>();
    private static final String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
    private static final String[] fgCandidateJavaLocations = new String[]{"bin" + File.separatorChar, "jre" + File.separatorChar + "bin" + File.separatorChar};
    private static ILibraryLocationResolver[] fgLibraryLocationResolvers = null;

    public static File findJavaExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateJavaFiles.length) {
            int j = 0;
            while (j < fgCandidateJavaLocations.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i]);
                if (javaFile.isFile()) {
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static ILibraryLocationResolver[] getLibraryLocationResolvers() {
        if (fgLibraryLocationResolvers == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.launching", "libraryLocationResolvers");
            IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
            Arrays.sort(configs, new Comparator<IConfigurationElement>(){

                @Override
                public int compare(IConfigurationElement e1, IConfigurationElement e2) {
                    return e1.getNamespaceIdentifier().compareTo(e2.getNamespaceIdentifier());
                }
            });
            ArrayList<ILibraryLocationResolver> resolvers = new ArrayList<ILibraryLocationResolver>(configs.length);
            int i = 0;
            while (i < configs.length) {
                IConfigurationElement e = configs[i];
                try {
                    resolvers.add((ILibraryLocationResolver)e.createExecutableExtension("class"));
                }
                catch (CoreException e1) {
                    LaunchingPlugin.log(e1.getStatus());
                }
                ++i;
            }
            fgLibraryLocationResolvers = resolvers.toArray(new ILibraryLocationResolver[0]);
        }
        return fgLibraryLocationResolvers;
    }

    @Override
    public String getName() {
        return LaunchingMessages.StandardVMType_Standard_VM_3;
    }

    @Override
    protected IVMInstall doCreateVMInstall(String id) {
        return new StandardVM(this, id);
    }

    protected synchronized LibraryInfo getLibraryInfo(File javaHome, File javaExecutable) {
        String installPath = javaHome.getAbsolutePath();
        LibraryInfo info = LaunchingPlugin.getLibraryInfo(installPath);
        if ((info == null || LaunchingPlugin.timeStampChanged(installPath)) && (info = fgFailedInstallPath.get(installPath)) == null) {
            info = this.generateLibraryInfo(javaHome, javaExecutable);
            if (info == null) {
                info = this.getDefaultLibraryInfo(javaHome);
                fgFailedInstallPath.put(installPath, info);
            } else {
                LaunchingPlugin.setLibraryInfo(installPath, info);
            }
        }
        return info;
    }

    protected boolean canDetectDefaultSystemLibraries(File javaHome, File javaExecutable) {
        LibraryLocation[] locations = this.getDefaultLibraryLocations(javaHome);
        String version = this.getVMVersion(javaHome, javaExecutable);
        return locations.length > 0 && !version.startsWith("1.1");
    }

    protected String getVMVersion(File javaHome, File javaExecutable) {
        LibraryInfo info = this.getLibraryInfo(javaHome, javaExecutable);
        return info.getVersion();
    }

    @Override
    public File detectInstallLocation() {
        if ("macosx".equals(Platform.getOS())) {
            return null;
        }
        return this.getJavaHomeLocation();
    }

    protected File getJavaHomeLocation() {
        File parent;
        File javaHome;
        try {
            javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
            return null;
        }
        if (!javaHome.exists()) {
            return null;
        }
        File javaExecutable = StandardVMType.findJavaExecutable(javaHome);
        if (javaExecutable == null) {
            return null;
        }
        boolean foundLibraries = false;
        if (javaHome.getName().equalsIgnoreCase(JRE) && this.canDetectDefaultSystemLibraries(parent = new File(javaHome.getParent()), javaExecutable)) {
            javaHome = parent;
            foundLibraries = true;
        }
        if (!foundLibraries && !this.canDetectDefaultSystemLibraries(javaHome, javaExecutable)) {
            return null;
        }
        return javaHome;
    }

    protected IPath getDefaultSystemLibrary(File javaHome) {
        IPath jreLibPath = new Path(javaHome.getPath()).append(LIB).append(RT_JAR);
        if (jreLibPath.toFile().isFile()) {
            return jreLibPath;
        }
        return new Path(javaHome.getPath()).append(JRE).append(LIB).append(RT_JAR);
    }

    protected IPath getDefaultSystemLibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        while (parent != null) {
            File parentsrc = new File(parent, SRC_JAR);
            if (parentsrc.isFile()) {
                this.setDefaultRootPath(SRC);
                return new Path(parentsrc.getPath());
            }
            parentsrc = new File(parent, SRC_ZIP);
            if (parentsrc.isFile()) {
                this.setDefaultRootPath("");
                return new Path(parentsrc.getPath());
            }
            parent = parent.getParentFile();
        }
        IPath result = this.checkForJ9LibrarySource(libLocation);
        if (result != null) {
            return result;
        }
        Path libName = new Path(libLocation.getName());
        String extension = libName.getFileExtension();
        String prefix = libName.removeFileExtension().lastSegment();
        if (extension != null) {
            Path srcPath = new Path(libLocation.getPath());
            srcPath = srcPath.removeLastSegments(1);
            StringBuffer buf = new StringBuffer();
            buf.append(prefix);
            buf.append("-src.");
            buf.append(extension);
            srcPath = srcPath.append(buf.toString());
            if (srcPath.toFile().exists()) {
                return srcPath;
            }
        }
        this.setDefaultRootPath("");
        return Path.EMPTY;
    }

    private IPath checkForJ9LibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        String name = libLocation.getName();
        if (name.equalsIgnoreCase("classes.zip")) {
            File source = new File(parent, "source/source.zip");
            return source.isFile() ? new Path(source.getPath()) : Path.EMPTY;
        }
        if (name.equalsIgnoreCase("locale.zip")) {
            File source = new File(parent, "source/locale-src.zip");
            return source.isFile() ? new Path(source.getPath()) : Path.EMPTY;
        }
        if (name.equalsIgnoreCase("charconv.zip")) {
            File source = new File(parent, "charconv-src.zip");
            return source.isFile() ? new Path(source.getPath()) : Path.EMPTY;
        }
        return null;
    }

    protected IPath getDefaultPackageRootPath() {
        return new Path(this.getDefaultRootPath());
    }

    @Override
    public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        List<LibraryLocation> allLibs = fgDefaultLibLocs.get(installLocation.getAbsolutePath());
        if (allLibs == null) {
            File javaExecutable = StandardVMType.findJavaExecutable(installLocation);
            LibraryInfo libInfo = javaExecutable == null ? this.getDefaultLibraryInfo(installLocation) : this.getLibraryInfo(installLocation, javaExecutable);
            allLibs = new ArrayList<LibraryLocation>(StandardVMType.gatherAllLibraries(libInfo.getEndorsedDirs()));
            String[] bootpath = libInfo.getBootpath();
            ArrayList<LibraryLocation> boot = new ArrayList<LibraryLocation>(bootpath.length);
            URL url = this.getDefaultJavadocLocation(installLocation);
            int i = 0;
            while (i < bootpath.length) {
                Path path = new Path(bootpath[i]);
                File lib = path.toFile();
                if (lib.exists() && lib.isFile()) {
                    LibraryLocation libraryLocation = new LibraryLocation((IPath)path, this.getDefaultSystemLibrarySource(lib), this.getDefaultPackageRootPath(), url);
                    boot.add(libraryLocation);
                }
                ++i;
            }
            allLibs.addAll(boot);
            allLibs.addAll(StandardVMType.gatherAllLibraries(libInfo.getExtensionDirs()));
            HashSet<String> set = new HashSet<String>();
            LibraryLocation lib = null;
            ListIterator<LibraryLocation> liter = allLibs.listIterator();
            while (liter.hasNext()) {
                lib = liter.next();
                IPath systemLibraryPath = lib.getSystemLibraryPath();
                String device = systemLibraryPath.getDevice();
                if (device != null) {
                    systemLibraryPath = systemLibraryPath.setDevice(device.toUpperCase());
                }
                if (set.add(systemLibraryPath.toOSString())) continue;
                liter.remove();
            }
            fgDefaultLibLocs.put(installLocation.getAbsolutePath(), allLibs);
        }
        return allLibs.toArray(new LibraryLocation[allLibs.size()]);
    }

    protected LibraryInfo getDefaultLibraryInfo(File installLocation) {
        IPath rtjar = this.getDefaultSystemLibrary(installLocation);
        File extDir = this.getDefaultExtensionDirectory(installLocation);
        File endDir = this.getDefaultEndorsedDirectory(installLocation);
        String[] dirs = null;
        dirs = extDir == null ? new String[]{} : new String[]{extDir.getAbsolutePath()};
        String[] endDirs = null;
        endDirs = endDir == null ? new String[]{} : new String[]{endDir.getAbsolutePath()};
        return new LibraryInfo("???", new String[]{rtjar.toOSString()}, dirs, endDirs);
    }

    public static List<LibraryLocation> gatherAllLibraries(String[] dirPaths) {
        ArrayList<LibraryLocation> libraries = new ArrayList<LibraryLocation>();
        int i = 0;
        while (i < dirPaths.length) {
            String[] names;
            File extDir = new File(dirPaths[i]);
            if (extDir.isDirectory() && (names = extDir.list(fgArchiveFilter)) != null) {
                int j = 0;
                while (j < names.length) {
                    File jar = new File(extDir, names[j]);
                    if (jar.isFile()) {
                        try {
                            Path libPath = new Path(jar.getCanonicalPath());
                            Path sourcePath = Path.EMPTY;
                            Path packageRoot = Path.EMPTY;
                            URL javadocLocation = null;
                            URL indexLocation = null;
                            ILibraryLocationResolver[] iLibraryLocationResolverArray = StandardVMType.getLibraryLocationResolvers();
                            int n = iLibraryLocationResolverArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILibraryLocationResolver resolver = iLibraryLocationResolverArray[n2];
                                try {
                                    sourcePath = resolver.getSourcePath((IPath)libPath);
                                    packageRoot = resolver.getPackageRoot((IPath)libPath);
                                    javadocLocation = resolver.getJavadocLocation((IPath)libPath);
                                    indexLocation = resolver.getIndexLocation((IPath)libPath);
                                    if (sourcePath != Path.EMPTY || packageRoot != Path.EMPTY || javadocLocation != null || indexLocation != null) {
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    LaunchingPlugin.log(e);
                                }
                                ++n2;
                            }
                            LibraryLocation library = new LibraryLocation((IPath)libPath, (IPath)sourcePath, (IPath)packageRoot, javadocLocation, indexLocation);
                            libraries.add(library);
                        }
                        catch (IOException e) {
                            LaunchingPlugin.log(e);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return libraries;
    }

    protected File getDefaultExtensionDirectory(File installLocation) {
        File jre = null;
        jre = installLocation.getName().equalsIgnoreCase(JRE) ? installLocation : new File(installLocation, JRE);
        File lib = new File(jre, LIB);
        File ext = new File(lib, "ext");
        return ext;
    }

    protected File getDefaultEndorsedDirectory(File installLocation) {
        File lib = new File(installLocation, LIB);
        File ext = new File(lib, "endorsed");
        return ext;
    }

    protected String getDefaultRootPath() {
        return this.fDefaultRootPath;
    }

    protected void setDefaultRootPath(String defaultRootPath) {
        this.fDefaultRootPath = defaultRootPath;
    }

    @Override
    public IStatus validateInstallLocation(File javaHome) {
        Status status = null;
        File javaExecutable = StandardVMType.findJavaExecutable(javaHome);
        status = javaExecutable == null ? new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_Not_a_JDK_Root__Java_executable_was_not_found_1, null) : (this.canDetectDefaultSystemLibraries(javaHome, javaExecutable) ? new Status(0, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_ok_2, null) : new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_Not_a_JDK_root__System_library_was_not_found__1, null));
        return status;
    }

    protected LibraryInfo generateLibraryInfo(File javaHome, File javaExecutable) {
        LibraryInfo info;
        block16: {
            info = null;
            IPath classesZip = new Path(javaHome.getAbsolutePath()).append(LIB).append("classes.zip");
            if (classesZip.toFile().exists()) {
                return new LibraryInfo("1.1.x", new String[]{classesZip.toOSString()}, new String[0], new String[0]);
            }
            File file = LaunchingPlugin.getFileInPlugin((IPath)new Path("lib/launchingsupport.jar"));
            if (file != null && file.exists()) {
                String javaExecutablePath = javaExecutable.getAbsolutePath();
                String[] cmdLine = new String[]{javaExecutablePath, MIN_VM_SIZE, "-classpath", file.getAbsolutePath(), "org.eclipse.jdt.internal.launching.support.LibraryDetector"};
                Process p = null;
                try {
                    try {
                        Map map;
                        String[] envp = null;
                        if ("macosx".equals(Platform.getOS()) && (map = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved()).remove("JAVA_JVM_VERSION") != null) {
                            envp = new String[map.size()];
                            Iterator iterator = map.entrySet().iterator();
                            int i = 0;
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                envp[i] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
                                ++i;
                            }
                        }
                        p = DebugPlugin.exec((String[])cmdLine, null, envp);
                        IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"Library Detection");
                        int i = 0;
                        while (i < 600) {
                            if (process.isTerminated()) break;
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++i;
                        }
                        info = this.parseLibraryInfo(process);
                    }
                    catch (CoreException ioe) {
                        LaunchingPlugin.log(ioe);
                        if (p != null) {
                            p.destroy();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        p.destroy();
                    }
                    throw throwable;
                }
                if (p != null) {
                    p.destroy();
                }
            }
        }
        if (info == null) {
            LaunchingPlugin.log(NLS.bind((String)"Failed to retrieve default libraries for {0}", (Object[])new String[]{javaHome.getAbsolutePath()}));
        }
        return info;
    }

    protected LibraryInfo parseLibraryInfo(IProcess process) {
        int index;
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String text = null;
        if (streamsProxy != null) {
            text = streamsProxy.getOutputStreamMonitor().getContents();
        }
        if (text != null && text.length() > 0 && (index = text.indexOf(BAR)) > 0) {
            String version = text.substring(0, index);
            if ((index = (text = text.substring(index + 1)).indexOf(BAR)) > 0) {
                String bootPaths = text.substring(0, index);
                String[] bootPath = this.parsePaths(bootPaths);
                if ((index = (text = text.substring(index + 1)).indexOf(BAR)) > 0) {
                    String extDirPaths = text.substring(0, index);
                    String endorsedDirsPath = text.substring(index + 1);
                    String[] extDirs = this.parsePaths(extDirPaths);
                    String[] endDirs = this.parsePaths(endorsedDirsPath);
                    return new LibraryInfo(version, bootPath, extDirs, endDirs);
                }
            }
        }
        return null;
    }

    protected String[] parsePaths(String paths) {
        String path;
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        int index = paths.indexOf(File.pathSeparatorChar, pos);
        while (index > 0) {
            path = paths.substring(pos, index);
            list.add(path);
            pos = index + 1;
            index = paths.indexOf(File.pathSeparatorChar, pos);
        }
        path = paths.substring(pos);
        if (!path.equals("null")) {
            list.add(path);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void disposeVMInstall(String id) {
        IVMInstall vm = this.findVMInstall(id);
        if (vm != null) {
            String path = vm.getInstallLocation().getAbsolutePath();
            LaunchingPlugin.setLibraryInfo(path, null);
            fgFailedInstallPath.remove(path);
            fgDefaultLibLocs.remove(path);
        }
        super.disposeVMInstall(id);
    }

    @Override
    public URL getDefaultJavadocLocation(File installLocation) {
        LibraryInfo libInfo;
        File javaExecutable = StandardVMType.findJavaExecutable(installLocation);
        if (javaExecutable != null && (libInfo = this.getLibraryInfo(installLocation, javaExecutable)) != null) {
            String version = libInfo.getVersion();
            return StandardVMType.getDefaultJavadocLocation(version);
        }
        return null;
    }

    public static URL getDefaultJavadocLocation(String version) {
        try {
            if (version.startsWith("1.8")) {
                return new URL("https://docs.oracle.com/javase/8/docs/api/");
            }
            if (version.startsWith("1.7")) {
                return new URL("https://docs.oracle.com/javase/7/docs/api/");
            }
            if (version.startsWith("1.6")) {
                return new URL("https://docs.oracle.com/javase/6/docs/api/");
            }
            if (version.startsWith("1.5")) {
                return new URL("https://docs.oracle.com/javase/1.5.0/docs/api/");
            }
            if (version.startsWith("1.4")) {
                return new URL("https://docs.oracle.com/javase/1.5.0/docs/api/");
            }
            if (version.startsWith("1.3")) {
                return new URL("https://docs.oracle.com/javase/1.5.0/docs/api/");
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }
}

