/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class UntrackOperation
implements IEGitOperation {
    private final Collection<? extends IResource> rsrcList;
    private final IdentityHashMap<Repository, DirCacheEditor> edits;

    public UntrackOperation(Collection<? extends IResource> rsrcs) {
        this.rsrcList = rsrcs;
        this.edits = new IdentityHashMap();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.rsrcList.size() * 2));
        progress.setTaskName(CoreText.UntrackOperation_adding);
        this.edits.clear();
        try {
            try {
                for (IResource obj : this.rsrcList) {
                    this.remove(obj);
                    progress.worked(1);
                }
                progress.setWorkRemaining(this.edits.size());
                for (Map.Entry e : this.edits.entrySet()) {
                    db = (Repository)e.getKey();
                    editor = (DirCacheEditor)e.getValue();
                    progress.setTaskName(NLS.bind((String)CoreText.UntrackOperation_writingIndex, (Object)db.getDirectory()));
                    editor.commit();
                    progress.worked(1);
                }
            }
            catch (RuntimeException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
            catch (IOException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
        }
        finally {
            ** for (editor : this.edits.values())
        }
lbl-1000:
        // 1 sources

        {
            if (editor.getDirCache() == null) continue;
            editor.getDirCache().unlock();
            continue;
        }
lbl30:
        // 1 sources

        this.edits.clear();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.rsrcList.toArray(new IResource[this.rsrcList.size()]));
    }

    private void remove(IResource path) throws CoreException {
        IProject proj = path.getProject();
        if (proj == null) {
            return;
        }
        GitProjectData pd = GitProjectData.get(proj);
        if (pd == null) {
            return;
        }
        RepositoryMapping rm = pd.getRepositoryMapping(path);
        if (rm == null) {
            return;
        }
        Repository db = rm.getRepository();
        DirCacheEditor e = this.edits.get(db);
        if (e == null) {
            try {
                e = db.lockDirCache().editor();
            }
            catch (IOException err) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, err));
            }
            this.edits.put(db, e);
        }
        if (path instanceof IContainer) {
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(rm.getRepoRelativePath(path)));
        } else {
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(rm.getRepoRelativePath(path)));
        }
    }
}

