/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.advice;

import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.types.internal.ui.advice.RuntimeValuesAdviceEditHelperAdvice;
import org.eclipse.papyrus.infra.emf.types.ui.advices.values.RuntimeValuesAdviceConfiguration;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.tooling.types.umlrttypes.UMLRTNewElementConfigurator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.advice.ConfiguratorDialog;
import org.eclipse.swt.widgets.Display;

public class UMLRTNewElementConfiguratorAdvice
extends RuntimeValuesAdviceEditHelperAdvice {
    private static final String DEFAULT_DIALOG_TITLE_PATTERN = "Create {0}";
    private final String dialogTitlePattern;

    public UMLRTNewElementConfiguratorAdvice(UMLRTNewElementConfigurator adviceConfiguration) {
        super((RuntimeValuesAdviceConfiguration)adviceConfiguration);
        this.dialogTitlePattern = adviceConfiguration.getDialogTitlePattern() == null ? DEFAULT_DIALOG_TITLE_PATTERN : adviceConfiguration.getDialogTitlePattern();
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        ICommand result = null;
        EObject newElement = request.getElementToConfigure();
        if (newElement != null) {
            result = this.edit(newElement, ElementTypeUtils.dialogCancellable((IEditCommandRequest)request), request);
        }
        return result;
    }

    public String getDialogTitlePattern() {
        return this.dialogTitlePattern;
    }

    protected ICommand edit(EObject newElement, boolean allowCancel, ConfigureRequest request) {
        IElementType elementType = request.getTypeToConfigure();
        String dialogTitle = NLS.bind((String)this.getDialogTitlePattern(), (Object)elementType.getDisplayName());
        class Command
        extends AbstractTransactionalCommand {
            private final /* synthetic */ boolean val$allowCancel;
            private final /* synthetic */ String val$dialogTitle;
            private final /* synthetic */ EObject val$newElement;

            Command(IEditCommandRequest request, IElementType iElementType, EObject eObject, boolean bl, String string) {
                this.val$newElement = eObject;
                this.val$allowCancel = bl;
                this.val$dialogTitle = string;
                super(request.getEditingDomain(), NLS.bind((String)"Configure {0}", (Object)iElementType.getDisplayName()), Command.getWorkspaceFiles((EObject)eObject));
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int dialogResult = 0;
                Set dialogContent = UMLRTNewElementConfiguratorAdvice.this.getViewsToDisplay();
                if (!dialogContent.isEmpty()) {
                    ConfiguratorDialog dialog = new ConfiguratorDialog(Display.getCurrent().getActiveShell(), this.val$allowCancel);
                    dialog.setTitle(this.val$dialogTitle);
                    dialog.setViews(dialogContent);
                    dialog.setInput(this.val$newElement);
                    dialogResult = dialog.open();
                }
                return dialogResult == 0 ? CommandResult.newOKCommandResult((Object)this.val$newElement) : CommandResult.newCancelledCommandResult();
            }
        }
        return new Command((IEditCommandRequest)request, elementType, newElement, allowCancel, dialogTitle);
    }
}

