/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.IBuildConsoleStreamDecorator;
import org.eclipse.jface.text.ITypedRegion;

public class BuildConsolePartitionerEditData {
    private int fMaxLines;
    private List<BuildConsolePartition> fEditPartitions = new ArrayList<BuildConsolePartition>();
    private boolean fClearDocumentMarkerManager = false;
    private StringBuilder fEditStringBuilder = new StringBuilder();
    private int fEditLineCount = 0;
    private Set<IBuildConsoleStreamDecorator> fEditStreams = new HashSet<IBuildConsoleStreamDecorator>();

    public BuildConsolePartitionerEditData(int maxLines) {
        this.fMaxLines = maxLines;
    }

    public int getMaxLines() {
        return this.fMaxLines;
    }

    public void setMaxLines(int fMaxLines) {
        this.fMaxLines = fMaxLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        BuildConsolePartitionerEditData buildConsolePartitionerEditData = this;
        synchronized (buildConsolePartitionerEditData) {
            this.fEditPartitions.clear();
            this.fClearDocumentMarkerManager = true;
            this.fEditStringBuilder.setLength(0);
            this.fEditLineCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String text, IBuildConsoleStreamDecorator stream, ProblemMarkerInfo marker) {
        int newlines = (int)text.chars().filter(ch -> ch == 10).count();
        BuildConsolePartitionerEditData buildConsolePartitionerEditData = this;
        synchronized (buildConsolePartitionerEditData) {
            this.fEditStreams.add(stream);
            if (text.length() > 0) {
                String partitionType = marker == null ? BuildConsolePartition.CONSOLE_PARTITION_TYPE : (marker.severity == 0 ? BuildConsolePartition.INFO_PARTITION_TYPE : (marker.severity == 1 ? BuildConsolePartition.WARNING_PARTITION_TYPE : BuildConsolePartition.ERROR_PARTITION_TYPE));
                if (this.fEditPartitions.isEmpty()) {
                    this.fEditPartitions.add(new BuildConsolePartition(stream, this.fEditStringBuilder.length(), text.length(), partitionType, marker, newlines));
                } else {
                    int index = this.fEditPartitions.size() - 1;
                    BuildConsolePartition last = this.fEditPartitions.get(index);
                    boolean canBeCombined = marker == null && last.getMarker() == null;
                    canBeCombined = canBeCombined && (this.fMaxLines <= 0 || last.getNewlines() + newlines < this.fMaxLines);
                    canBeCombined = canBeCombined && Objects.equals(last.getType(), partitionType);
                    boolean bl = canBeCombined = canBeCombined && Objects.equals(last.getStream(), stream);
                    if (canBeCombined) {
                        int combinedOffset = last.getOffset();
                        int combinedLength = last.getLength() + text.length();
                        int combinedNewlines = last.getNewlines() + newlines;
                        BuildConsolePartition partition2 = new BuildConsolePartition(last.getStream(), combinedOffset, combinedLength, BuildConsolePartition.CONSOLE_PARTITION_TYPE, null, combinedNewlines);
                        this.fEditPartitions.set(index, partition2);
                    } else {
                        this.fEditPartitions.add(new BuildConsolePartition(stream, this.fEditStringBuilder.length(), text.length(), partitionType, marker, newlines));
                    }
                }
                this.fEditStringBuilder.append(text);
                this.fEditLineCount += newlines;
                this.checkOverflow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkOverflow() {
        if (this.fMaxLines <= 0) {
            return;
        }
        BuildConsolePartitionerEditData buildConsolePartitionerEditData = this;
        synchronized (buildConsolePartitionerEditData) {
            if (this.fEditLineCount <= this.fMaxLines * 2) {
                return;
            }
            int newHeadIndex = this.fEditPartitions.size();
            int newNewlineCount = 0;
            while (newHeadIndex > 0 && newNewlineCount < this.fMaxLines) {
                BuildConsolePartition part = this.fEditPartitions.get(--newHeadIndex);
                newNewlineCount += part.getNewlines();
            }
            if (newHeadIndex == 0) {
                return;
            }
            int newPartCount = this.fEditPartitions.size() - newHeadIndex;
            int offsetToOffset = this.fEditPartitions.get(newHeadIndex).getOffset();
            ArrayList<BuildConsolePartition> newParitions = new ArrayList<BuildConsolePartition>(newPartCount);
            ListIterator<BuildConsolePartition> partitions = this.fEditPartitions.listIterator(newHeadIndex);
            while (partitions.hasNext()) {
                BuildConsolePartition partition = (BuildConsolePartition)((Object)partitions.next());
                BuildConsolePartition newPartition = new BuildConsolePartition(partition.getStream(), partition.getOffset() - offsetToOffset, partition.getLength(), partition.getType(), partition.getMarker(), partition.getNewlines());
                newParitions.add(newPartition);
            }
            this.fEditPartitions = newParitions;
            this.fClearDocumentMarkerManager = true;
            this.fEditStringBuilder.delete(0, offsetToOffset);
            this.fEditLineCount = newNewlineCount;
        }
    }

    public void printDocumentPartitioning() {
        System.out.println("Document partitioning: ");
        for (ITypedRegion iTypedRegion : this.fEditPartitions) {
            BuildConsolePartition p = (BuildConsolePartition)iTypedRegion;
            int start = p.getOffset();
            int end = p.getOffset() + p.getLength();
            String isError = "U";
            String type = p.getType();
            if (type == BuildConsolePartition.ERROR_PARTITION_TYPE) {
                isError = "E";
            } else if (type == BuildConsolePartition.WARNING_PARTITION_TYPE) {
                isError = "W";
            } else if (type == BuildConsolePartition.INFO_PARTITION_TYPE) {
                isError = "I";
            } else if (type == BuildConsolePartition.CONSOLE_PARTITION_TYPE) {
                isError = "C";
            }
            String text = this.fEditStringBuilder.substring(p.getOffset(), p.getLength());
            if (text.endsWith("\n")) {
                text = text.substring(0, text.length() - 1);
            }
            System.out.println("    " + isError + " " + start + "-" + end + ":[" + text + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateUIData getUpdate() {
        ArrayList<IBuildConsoleStreamDecorator> streamsNeedingNotifcation;
        boolean clearDocumentMarkerManager;
        ArrayList<BuildConsolePartition> newPartitions;
        String newConents;
        BuildConsolePartitionerEditData buildConsolePartitionerEditData = this;
        synchronized (buildConsolePartitionerEditData) {
            newConents = this.fEditStringBuilder.toString();
            newPartitions = new ArrayList<BuildConsolePartition>(this.fEditPartitions);
            clearDocumentMarkerManager = this.fClearDocumentMarkerManager;
            this.fClearDocumentMarkerManager = false;
            streamsNeedingNotifcation = new ArrayList<IBuildConsoleStreamDecorator>(this.fEditStreams);
            this.fEditStreams.clear();
        }
        return new UpdateUIData(){

            @Override
            public boolean needsClearDocumentMarkerManager() {
                return clearDocumentMarkerManager;
            }

            @Override
            public List<IBuildConsoleStreamDecorator> getStreamsNeedingNotifcation() {
                return streamsNeedingNotifcation;
            }

            @Override
            public List<ITypedRegion> getNewPartitions() {
                return newPartitions;
            }

            @Override
            public String getNewContents() {
                return newConents;
            }
        };
    }

    public static interface UpdateUIData {
        public boolean needsClearDocumentMarkerManager();

        public String getNewContents();

        public List<ITypedRegion> getNewPartitions();

        public List<IBuildConsoleStreamDecorator> getStreamsNeedingNotifcation();
    }
}

