/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTLiteralNode;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.IToggleRefactoringStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleFileCreator;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleNodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.utils.CPPASTAllVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;

public class ToggleFromImplementationToHeaderOrClassStrategy
implements IToggleRefactoringStrategy {
    private ToggleRefactoringContext context;
    private TextEditGroup infoText;
    private IASTTranslationUnit otherAst;
    private ASTLiteralNode includeNode;

    public ToggleFromImplementationToHeaderOrClassStrategy(ToggleRefactoringContext context) {
        this.context = context;
        this.infoText = new TextEditGroup(Messages.EditGroupName);
    }

    private boolean isFreeFunction(IASTFunctionDefinition definition) {
        return definition.getDeclarator().getName() instanceof ICPPASTQualifiedName;
    }

    @Override
    public void run(ModificationCollector modifications) throws CoreException {
        this.newFileCheck();
        ASTRewrite implAst = modifications.rewriterForTranslationUnit(this.context.getDefinitionAST());
        List leadingComments = implAst.getComments((IASTNode)this.context.getDefinition(), ASTRewrite.CommentPosition.leading);
        this.removeDefinitionFromImplementation(implAst);
        if (this.includeNode != null) {
            implAst.insertBefore((IASTNode)this.context.getDefinitionAST(), this.context.getDefinitionAST().getChildren()[0], (IASTNode)this.includeNode, this.infoText);
        }
        if (this.context.getDeclarationAST() != null) {
            this.addDefinitionToClass(modifications, leadingComments);
        } else {
            this.addDefinitionToHeader(modifications, leadingComments);
        }
    }

    private void newFileCheck() throws CoreException {
        if (this.context.getDeclarationAST() == null) {
            if (this.isFreeFunction(this.context.getDefinition())) {
                throw new NotSupportedException(Messages.ToggleFromImplementationToHeaderOrClassStrategy_CanNotToggle);
            }
            this.otherAst = this.context.getASTForPartnerFile();
            if (this.otherAst == null) {
                ToggleFileCreator fileCreator = new ToggleFileCreator(this.context, ".h");
                if (fileCreator.askUserForFileCreation(this.context)) {
                    IFile file = fileCreator.createNewFile();
                    this.otherAst = this.context.getAST(file, null);
                    this.includeNode = new ASTLiteralNode(String.valueOf(fileCreator.getIncludeStatement()) + "\n\n");
                } else {
                    throw new NotSupportedException(Messages.ToggleFromImplementationToHeaderOrClassStrategy_CanNotCreateNewFile);
                }
            }
        }
    }

    private void addDefinitionToHeader(ModificationCollector modifications, List<IASTComment> leadingComments) {
        ASTRewrite headerRewrite = modifications.rewriterForTranslationUnit(this.otherAst);
        ICPPASTFunctionDefinition newDefinition = ToggleNodeHelper.createFunctionSignatureWithEmptyBody(this.context.getDefinition().getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations), this.context.getDefinition().getDeclarator().copy(IASTNode.CopyStyle.withLocations), this.context.getDefinition().copy(IASTNode.CopyStyle.withLocations));
        newDefinition.setParent((IASTNode)this.otherAst);
        headerRewrite.insertBefore((IASTNode)this.otherAst.getTranslationUnit(), null, (IASTNode)newDefinition, this.infoText);
        this.restoreBody(headerRewrite, (IASTFunctionDefinition)newDefinition, modifications);
        for (IASTComment comment : leadingComments) {
            headerRewrite.addComment((IASTNode)newDefinition, comment, ASTRewrite.CommentPosition.leading);
        }
    }

    private void addDefinitionToClass(ModificationCollector modifications, List<IASTComment> leadingComments) {
        ASTRewrite headerRewrite = modifications.rewriterForTranslationUnit(this.context.getDeclarationAST());
        IASTFunctionDefinition newDefinition = ToggleNodeHelper.createInClassDefinition(this.context.getDeclaration(), this.context.getDefinition(), this.context.getDeclarationAST());
        newDefinition.setParent(this.getParent());
        this.restoreBody(headerRewrite, newDefinition, modifications);
        headerRewrite.replace(this.context.getDeclaration().getParent(), (IASTNode)newDefinition, this.infoText);
        for (IASTComment comment : leadingComments) {
            headerRewrite.addComment((IASTNode)newDefinition, comment, ASTRewrite.CommentPosition.leading);
        }
    }

    private IASTNode getParent() {
        IASTNode parent = ASTQueries.findAncestorWithType((IASTNode)this.context.getDefinition(), ICPPASTCompositeTypeSpecifier.class);
        Object parentnode = null;
        parentnode = parent != null ? parent : this.context.getDeclarationAST();
        return parentnode;
    }

    private void restoreBody(ASTRewrite headerRewrite, IASTFunctionDefinition newDefinition, ModificationCollector modifications) {
        IASTFunctionDefinition oldDefinition = this.context.getDefinition();
        newDefinition.setBody(oldDefinition.getBody().copy(IASTNode.CopyStyle.withLocations));
        if (newDefinition instanceof ICPPASTFunctionWithTryBlock && oldDefinition instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTFunctionWithTryBlock newTryDef = (ICPPASTFunctionWithTryBlock)newDefinition;
            ICPPASTFunctionWithTryBlock oldTryDef = (ICPPASTFunctionWithTryBlock)oldDefinition;
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = oldTryDef.getCatchHandlers();
            int n = iCPPASTCatchHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler handler = iCPPASTCatchHandlerArray[n2];
                newTryDef.addCatchHandler(handler.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
        }
        this.copyAllCommentsToNewLocation((IASTNode)oldDefinition, modifications.rewriterForTranslationUnit(oldDefinition.getTranslationUnit()), headerRewrite);
    }

    private void copyAllCommentsToNewLocation(IASTNode node, final ASTRewrite oldRw, final ASTRewrite newRw) {
        node.accept((ASTVisitor)new CPPASTAllVisitor(){

            @Override
            public int visitAll(IASTNode node) {
                this.copyComments(oldRw, newRw, node, ASTRewrite.CommentPosition.leading);
                this.copyComments(oldRw, newRw, node, ASTRewrite.CommentPosition.trailing);
                this.copyComments(oldRw, newRw, node, ASTRewrite.CommentPosition.freestanding);
                return 3;
            }

            private void copyComments(ASTRewrite oldRw2, ASTRewrite newRw2, IASTNode node, ASTRewrite.CommentPosition pos) {
                List comments = oldRw2.getComments(node, pos);
                for (IASTComment comment : comments) {
                    newRw2.addComment(node, comment, pos);
                }
            }
        });
    }

    private void removeDefinitionFromImplementation(ASTRewrite implast) {
        ICPPASTNamespaceDefinition ns = this.findOutermostNonemptyNamspace();
        if (ns != null) {
            implast.remove((IASTNode)ns, this.infoText);
        } else {
            implast.remove((IASTNode)this.context.getDefinition(), this.infoText);
        }
    }

    private ICPPASTNamespaceDefinition findOutermostNonemptyNamspace() {
        List<ICPPASTNamespaceDefinition> namespaces = ToggleNodeHelper.findSurroundingNamespaces((IASTNode)this.context.getDefinition());
        Collections.reverse(namespaces);
        IASTFunctionDefinition definition = this.context.getDefinition();
        ICPPASTNamespaceDefinition ns = null;
        for (ICPPASTNamespaceDefinition namespace : namespaces) {
            if (!this.isSingleElementInNamespace(namespace, definition)) break;
            ns = namespace;
        }
        return ns;
    }

    private boolean isSingleElementInNamespace(ICPPASTNamespaceDefinition ns, IASTFunctionDefinition definition) {
        return ns.getChildren().length == 2 && ns.contains((IASTNode)definition);
    }
}

