/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class LogicalComparison
extends Expression {
    private final Operator operator;
    private final Expression lhs;
    private final Expression rhs;

    public LogicalComparison(Expression lhs, Operator operator, Expression rhs) {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    protected Type createType() {
        return PrimitiveType.BOOL;
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return this.operator.precedence;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.lhs.addDependencies(deps) && this.rhs.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        return this.lhs.write(fmt, this) && fmt.space() && this.operator.write(fmt) && fmt.space() && this.rhs.write(fmt, this);
    }

    public static enum Operator {
        AND("&&", Expression.Precedence.Precedence13),
        OR("||", Expression.Precedence.Precedence14),
        LESS_THAN("<", Expression.Precedence.Precedence08),
        GREATER_THAN(">", Expression.Precedence.Precedence08),
        LESS_THAN_EQUAL("<=", Expression.Precedence.Precedence08),
        GREATER_THAN_EQUAL(">=", Expression.Precedence.Precedence08),
        EQUIVALENT("==", Expression.Precedence.Precedence09),
        NOT_EQUIVALENT("!=", Expression.Precedence.Precedence09);

        private final String token;
        public final Expression.Precedence precedence;

        private Operator(String token, Expression.Precedence precedence) {
            this.token = token;
            this.precedence = precedence;
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.token);
        }
    }
}

