/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeDependentsRequest;
import org.eclipse.papyrusrt.umlrt.core.types.advice.IInheritanceEditHelperAdvice;
import org.eclipse.papyrusrt.umlrt.core.utils.NewElementUtil;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnector;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.VisibilityKind;

public class CapsulePartEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInheritanceEditHelperAdvice {
    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = this.getInheritanceEditCommand(request);
        if (result == null) {
            result = super.getBeforeEditCommand(request);
        }
        return result;
    }

    @Override
    public ICommand getExcludeDependentsCommand(ExcludeDependentsRequest request) {
        UMLRTCapsulePart part;
        ICommand result = IInheritanceEditHelperAdvice.super.getExcludeDependentsCommand(request);
        if (request.isExclude() && request.getElementToExclude() instanceof Property && (part = UMLRTCapsulePart.getInstance((Property)((Property)request.getElementToExclude()))) != null) {
            ICommand excludeConnectors;
            Predicate<UMLRTNamedElement> alreadyExcluded = UMLRTNamedElement::isExcluded;
            List connectorsToExclude = part.getConnectorsOfPorts().stream().filter(alreadyExcluded.negate()).map(UMLRTConnector::toUML).collect(Collectors.toList());
            if (!connectorsToExclude.isEmpty() && (excludeConnectors = request.getExcludeDependentsCommand(connectorsToExclude)) != null) {
                result = CompositeCommand.compose((ICommand)result, (ICommand)excludeConnectors);
            }
        }
        return result;
    }

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        final Property capsulePart = (Property)request.getElementToConfigure();
        request.setParameter("DIALOG_CANCELLABLE", (Object)true);
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                capsulePart.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                capsulePart.setName(null);
                capsulePart.setIsOrdered(true);
                capsulePart.setVisibility(VisibilityKind.PROTECTED_LITERAL);
                return CommandResult.newOKCommandResult((Object)capsulePart);
            }
        };
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        Property property = (Property)request.getElementToConfigure();
        NewElementUtil.elementCreated((EObject)property);
        CompositeCommand compositeCommand = new CompositeCommand("Before Configure CapsulePart");
        return compositeCommand.isEmpty() ? super.getBeforeConfigureCommand(request) : compositeCommand;
    }
}

