/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList2;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;

abstract class GetRTStructuralFeaturesQuery<T extends Feature>
implements IJavaQuery2<Class, List<T>> {
    private final java.lang.Class<T> type;

    protected GetRTStructuralFeaturesQuery(java.lang.Class<T> type) {
        this.type = type;
    }

    public List<T> evaluate(Class context, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        List result = Collections.emptyList();
        ParameterValue param = (ParameterValue)parameterValues.get(0);
        boolean rtSpecific = (Boolean)param.getValue();
        param = (ParameterValue)parameterValues.get(1);
        boolean inherited = (Boolean)param.getValue();
        param = (ParameterValue)parameterValues.get(2);
        boolean includeVirtual = (Boolean)param.getValue();
        UMLRTCapsule capsule = UMLRTCapsule.getInstance((Class)context);
        if (capsule != null) {
            List<UMLRTNamedElement> rtFeatures = this.getFeatures(capsule);
            if (!rtSpecific) {
                ArrayList features = new ArrayList(this.getFeatures(context));
                rtFeatures.forEach(rt -> {
                    boolean bl = features.remove(rt.toUML());
                });
                result = features;
            } else {
                result = rtFeatures.stream().map(UMLRTNamedElement::toUML).map(this.type::cast).collect(Collectors.toList());
                Predicate<Element> filter = UMLRTExtensionUtil::isInherited;
                if (inherited) {
                    filter = filter.negate();
                    if (!includeVirtual) {
                        filter = filter.or(UMLRTExtensionUtil::isVirtualElement);
                    }
                }
                result.removeIf(filter);
            }
        }
        return result;
    }

    protected abstract List<? extends UMLRTNamedElement> getFeatures(UMLRTCapsule var1);

    protected abstract List<T> getFeatures(Class var1);
}

