/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.labelprovider;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.providers.DelegatingItemLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.TransitionUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;

public class UMLRTLabelProvider
extends UMLFilteredLabelProvider {
    private static final String UI_PLUGIN_ID = "org.eclipse.papyrusrt.umlrt.tooling.ui";
    private static final String OVERLAY_PATH = "$nl$/icons/full/ovr16/";
    private static ImageDescriptor EXCLUDED_OVERLAY = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)"$nl$/icons/full/ovr16/excluded_ovr.png");
    private static ImageDescriptor INHERITED_OVERLAY = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)"$nl$/icons/full/ovr16/inherited_ovr.png");
    private static ImageDescriptor REDEFINITION_OVERLAY = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)"$nl$/icons/full/ovr16/redefinition_ovr.png");
    private static ImageDescriptor WARNING_OVERLAY = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)"$nl$/icons/full/ovr16/warning_ovr.png");
    public final Map<String, String> typeIdtoIconPath;
    protected static String ICON_PATH = "/icons/";
    protected static final String RT_PSEUDO_STATE_CHOICE_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_choice.gif";
    protected static final String RT_PSEUDO_STATE_DEEP_HISTORY_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_deepHistory.gif";
    protected static final String RT_PSEUDO_STATE_ENTRY_POINT_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_entryPoint.gif";
    protected static final String RT_PSEUDO_STATE_EXIT_POINT_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_exitPoint.gif";
    protected static final String RT_PSEUDO_STATE_FORK_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_fork.gif";
    protected static final String RT_PSEUDO_STATE_INITIAL_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_initial.gif";
    protected static final String RT_PSEUDO_STATE_JOIN_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_join.gif";
    protected static final String RT_PSEUDO_STATE_JUNCTION_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_junction.gif";
    protected static final String RT_PSEUDO_STATE_SHALLOW_HISTORY_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_shallowHistory.gif";
    protected static final String RT_PSEUDO_STATE_TERMINATE_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_terminate.gif";
    protected static final String RT_TRANSITION_ICON = String.valueOf(ICON_PATH) + "rt_transition.gif";
    protected static final String RT_TRANSITION_INTERNAL_ICON = String.valueOf(ICON_PATH) + "rt_transition_internal.gif";
    protected static String RT_MESSAGE_IN_ICON = String.valueOf(ICON_PATH) + "protocolmessage_in.gif";
    protected static String RT_MESSAGE_IN_OUT_ICON = String.valueOf(ICON_PATH) + "protocolmessage_inout.gif";
    protected static String RT_MESSAGE_OUT_ICON = String.valueOf(ICON_PATH) + "protocolmessage_out.gif";
    protected static String RT_MESSAGE_UNDEFINED_ICON = String.valueOf(ICON_PATH) + "protocolmessage_undefined.gif";
    protected static final IItemLabelProvider labelProvider = new DelegatingItemLabelProvider();
    private final CopyOnWriteArrayList<ILabelProviderListener> listeners = new CopyOnWriteArrayList();
    protected final INotifyChangedListener changeForwarder = this::forwardChange;

    public UMLRTLabelProvider() {
        this.typeIdtoIconPath = new HashMap<String, String>();
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.Capsule", String.valueOf(ICON_PATH) + "capsule.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.CapsulePart", String.valueOf(ICON_PATH) + "capsule_part.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolContainer", String.valueOf(ICON_PATH) + "protocol_container.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.Protocol", String.valueOf(ICON_PATH) + "protocol.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTConnector", String.valueOf(ICON_PATH) + "rt_connector.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTRExcludedElement", String.valueOf(ICON_PATH) + "rt_excludedElement.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTMessageSet", String.valueOf(ICON_PATH) + "rt_messageset.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPort", String.valueOf(ICON_PATH) + "rt_port.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageIn", RT_MESSAGE_IN_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageInOut", RT_MESSAGE_IN_OUT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageOut", RT_MESSAGE_OUT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage", RT_MESSAGE_UNDEFINED_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTStateMachine", String.valueOf(ICON_PATH) + "rt_statemachine.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTRegion", String.valueOf(ICON_PATH) + "rt_region.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTState", String.valueOf(ICON_PATH) + "rt_state.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState", String.valueOf(ICON_PATH) + "rt_pseudostate.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Choice", RT_PSEUDO_STATE_CHOICE_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_DeepHistory", RT_PSEUDO_STATE_DEEP_HISTORY_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_EntryPoint", RT_PSEUDO_STATE_ENTRY_POINT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_ExitPoint", RT_PSEUDO_STATE_EXIT_POINT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Fork", RT_PSEUDO_STATE_FORK_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Initial", RT_PSEUDO_STATE_INITIAL_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Join", RT_PSEUDO_STATE_JOIN_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Junction", RT_PSEUDO_STATE_JUNCTION_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_ShallowHistory", RT_PSEUDO_STATE_SHALLOW_HISTORY_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Terminate", RT_PSEUDO_STATE_TERMINATE_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.TransitionInternal", RT_TRANSITION_INTERNAL_ICON);
        if (labelProvider instanceof IChangeNotifier) {
            ((IChangeNotifier)labelProvider).addListener(this.changeForwarder);
        }
    }

    public void dispose() {
        if (labelProvider instanceof IChangeNotifier) {
            ((IChangeNotifier)labelProvider).removeListener(this.changeForwarder);
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        EObject eObject;
        Image result = element instanceof IStructuredSelection ? this.getImage((IStructuredSelection)element) : ((eObject = EMFHelper.getEObject((Object)element)) != null ? this.getImage(eObject) : super.getImage(element));
        return result;
    }

    protected Image getImage(EObject element) {
        List<Object> overlays;
        Image result = this.doGetImage(element);
        if (result != null && (overlays = this.getOverlays(element, null)) != null && !overlays.isEmpty()) {
            UMLRTComposedImage composed = new UMLRTComposedImage(Lists.asList((Object)result, (Object[])overlays.toArray()));
            result = ExtendedImageRegistry.getInstance().getImage((Object)composed);
        }
        return result;
    }

    protected Image doGetImage(EObject element) {
        if (!(element instanceof Element)) {
            Activator.log.debug("Trying to display an UMLRT image for a non UML-RT element");
            return null;
        }
        String matchingTypeMatcher = this.getMatchingType(element);
        Image image = null;
        switch (matchingTypeMatcher) {
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageIn": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_MESSAGE_IN_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageOut": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_MESSAGE_OUT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageInOut": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_MESSAGE_IN_OUT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Choice": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_CHOICE_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_DeepHistory": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_DEEP_HISTORY_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_EntryPoint": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_ENTRY_POINT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_ExitPoint": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_EXIT_POINT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Fork": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_FORK_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Initial": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_INITIAL_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Join": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_JOIN_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Junction": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_JUNCTION_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_ShallowHistory": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_SHALLOW_HISTORY_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Terminate": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, RT_PSEUDO_STATE_TERMINATE_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTMessageSet": {
                RTMessageKind kind = MessageSetUtils.getMessageKind((Object)element);
                if (kind == RTMessageKind.IN) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, String.valueOf(ICON_PATH) + "rt_messageset_in.gif");
                    break;
                }
                if (kind == RTMessageKind.OUT) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, String.valueOf(ICON_PATH) + "rt_messageset_out.gif");
                    break;
                }
                if (kind == RTMessageKind.IN_OUT) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, String.valueOf(ICON_PATH) + "rt_messageset_inout.gif");
                    break;
                }
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, this.typeIdtoIconPath.get("org.eclipse.papyrusrt.umlrt.core.RTMessageSet"));
                break;
            }
            default: {
                image = this.getElementImage(matchingTypeMatcher, element);
            }
        }
        return image;
    }

    protected List<Object> getOverlays(EObject element, List<Object> images) {
        Image overlay;
        List<Object> result = images;
        if (element instanceof NamedElement && (overlay = this.getInheritanceOverlay((NamedElement)element)) != null) {
            if (result == null) {
                result = new ArrayList<Object>(3);
            }
            result.add(overlay);
        }
        if (element instanceof Transition && TransitionUtils.hasNameAndNoTriggers((Transition)((Transition)element)) && (overlay = this.getWarningOverlay()) != null) {
            if (result == null) {
                result = new ArrayList<Object>(3);
            }
            result.add(overlay);
        }
        return result;
    }

    protected Image getWarningOverlay() {
        return ExtendedImageRegistry.getInstance().getImage((Object)WARNING_OVERLAY);
    }

    protected Image getInheritanceOverlay(NamedElement element) {
        Image result;
        UMLRTTrigger trigger;
        UMLRTInheritanceKind inheritance = element instanceof Trigger ? ((trigger = UMLRTTrigger.getInstance((Trigger)((Trigger)element))) != null ? trigger.getInheritanceKind() : UMLRTInheritanceKind.of((Element)element)) : UMLRTInheritanceKind.of((Element)element);
        switch (inheritance) {
            case INHERITED: {
                result = ExtendedImageRegistry.getInstance().getImage((Object)INHERITED_OVERLAY);
                break;
            }
            case REDEFINED: {
                result = ExtendedImageRegistry.getInstance().getImage((Object)REDEFINITION_OVERLAY);
                break;
            }
            case EXCLUDED: {
                result = ExtendedImageRegistry.getInstance().getImage((Object)EXCLUDED_OVERLAY);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public String getText(Object element) {
        EObject eObject;
        String result = element instanceof IStructuredSelection ? this.getText((IStructuredSelection)element) : ((eObject = EMFHelper.getEObject((Object)element)) != null ? this.getText(eObject) : super.getText(element));
        return result;
    }

    protected String getText(EObject element) {
        if (element instanceof MultiplicityElement) {
            MultiplicityElement mult = (MultiplicityElement)element;
            if (mult.getLowerValue() != null) {
                this.getText((EObject)mult.getLowerValue());
            }
            if (mult.getUpperValue() != null) {
                this.getText((EObject)mult.getUpperValue());
            }
        }
        if (element instanceof Operation) {
            Operation operation = (Operation)element;
            operation.getOwnedParameters().forEach(this::getText);
        }
        return labelProvider.getText((Object)element);
    }

    protected String getMatchingType(EObject semanticObject) {
        for (IElementType type : UMLRTElementTypesEnumerator.getAllRTTypes()) {
            if (!(type instanceof ISpecializationType) || !((ISpecializationType)type).getMatcher().matches(semanticObject)) continue;
            return type.getId();
        }
        return null;
    }

    protected Image getElementImage(String id, EObject semanticObject) {
        String iconPath = this.typeIdtoIconPath.get(id);
        if (iconPath != null) {
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(UI_PLUGIN_ID, iconPath);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    private void forwardChange(Notification notification) {
        ViewerNotification vnot;
        if (notification instanceof ViewerNotification && (vnot = (ViewerNotification)notification).isLabelUpdate() && !this.listeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, vnot.getElement());
            this.listeners.forEach(l -> {
                try {
                    l.labelProviderChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in label provider listener", (Throwable)e);
                }
            });
        }
    }

    private static class UMLRTComposedImage
    extends ComposedImage {
        UMLRTComposedImage(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            List result = super.getDrawPoints(size);
            if (result.size() > 2) {
                int position = 1;
                int i = 2;
                while (i < result.size()) {
                    ComposedImage.Point next = (ComposedImage.Point)result.get(i);
                    ComposedImage.Size deco = (ComposedImage.Size)this.imageSizes.get(i);
                    if (position & true) {
                        next.x = size.width - deco.width;
                    }
                    if ((position & 2) != 0) {
                        next.y = size.height - deco.height;
                    }
                    position = (position + 1) % 3;
                    ++i;
                }
            }
            return result;
        }
    }
}

