/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp;

import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.codegen.lang.io.CodeFormatter;

public class HeaderFile
implements Comparable<HeaderFile> {
    private final FileName name;

    public HeaderFile(String filename) {
        this.name = new FileName(filename);
    }

    public HeaderFile(FileName name) {
        this.name = name;
    }

    public FileName getName() {
        return this.name;
    }

    protected String getIncludeTarget(String filename) {
        return "\"" + filename + '\"';
    }

    @Override
    public int compareTo(HeaderFile o) {
        String incPath1 = this.getIncludeTarget(this.name.getIncludePath());
        String incPath2 = o.getIncludeTarget(o.name.getIncludePath());
        return incPath1.compareTo(incPath2);
    }

    public boolean writeInclude(CodeFormatter fmt) {
        return fmt.write("#include ") && fmt.write(this.getIncludeTarget(this.name.getIncludePath())) && fmt.newline();
    }
}

