/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;

public class ComparisonStream
extends OutputStream {
    private final String pathname;
    private final byte[] inBuff;
    private int pos;
    private int end;
    private int len = 0;
    private char lastChar = '\u0000';
    private File existing;
    private InputStream in;
    private OutputStream out;
    private boolean provisional = false;
    private StringBuilder provisionalBuffer;

    public static ComparisonStream create(String pathname, int buffLen) {
        ComparisonStream stm = new ComparisonStream(pathname, buffLen);
        try {
            stm.createFile();
        }
        catch (IOException e) {
            CodeGenPlugin.error((Throwable)e);
            return null;
        }
        return stm;
    }

    public static ComparisonStream createProvisional(String pathname, int buffLen) {
        ComparisonStream stm = new ComparisonStream(pathname, buffLen);
        stm.provisional = true;
        stm.provisionalBuffer = new StringBuilder(512);
        return stm;
    }

    public static ComparisonStream create(String pathname) {
        return ComparisonStream.create(pathname, 65536);
    }

    public static ComparisonStream createProvisional(String pathname) {
        return ComparisonStream.createProvisional(pathname, 65536);
    }

    private ComparisonStream(String pathname, int buffLen) {
        this.pathname = pathname;
        this.inBuff = new byte[buffLen];
        this.pos = 0;
        this.end = 0;
    }

    private int next() throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.pos >= this.end) {
            this.end = this.in.read(this.inBuff);
            this.len += this.end;
            this.pos = 0;
        }
        return this.pos >= this.end ? -1 : this.inBuff[this.pos++];
    }

    public char getLastChar() {
        return this.lastChar;
    }

    public void enableWrites() {
        this.provisional = false;
    }

    public boolean isProvisional() {
        return this.provisional || this.provisionalBuffer != null;
    }

    private void createFile() throws IOException {
        File file = new File(this.pathname);
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        if (file.exists()) {
            this.in = new FileInputStream(file);
        }
        this.existing = file;
    }

    private void flushProvisionalBuffer() throws IOException {
        if (this.provisional || this.provisionalBuffer == null) {
            return;
        }
        this.createFile();
        StringBuilder buff = this.provisionalBuffer;
        this.provisionalBuffer = null;
        this.write(buff.toString().getBytes());
    }

    private void changeToWriteMode(boolean truncateExisting) throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
        FileOutputStream stm = new FileOutputStream(this.existing, true);
        if (truncateExisting) {
            stm.getChannel().truncate(this.len - this.end + this.pos - 1);
        }
        this.out = new BufferedOutputStream(stm);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.provisional && this.provisionalBuffer != null) {
            this.provisionalBuffer.append((char)b);
            return;
        }
        this.flushProvisionalBuffer();
        this.lastChar = (char)b;
        if (this.out != null) {
            this.out.write(b);
            return;
        }
        int next = this.next();
        if (next == b) {
            return;
        }
        this.changeToWriteMode(next >= 0);
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int o, int l) throws IOException {
        if (this.provisional && this.provisionalBuffer != null) {
            while (o < l) {
                this.provisionalBuffer.append((char)b[o++]);
            }
            return;
        }
        this.flushProvisionalBuffer();
        while (l > 0) {
            if (this.out != null) {
                this.out.write(b, o, l);
                this.lastChar = (char)b[o + l - 1];
                return;
            }
            int next = this.next();
            if (next != b[o]) {
                this.changeToWriteMode(next >= 0);
                this.out.write(b, o, l);
                this.lastChar = (char)b[o + l - 1];
                return;
            }
            this.lastChar = (char)b[o];
            ++o;
            --l;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isProvisional()) {
            new File(this.pathname).delete();
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.in != null) {
            block20: {
                int newLen = this.len - this.end + this.pos;
                if (this.existing.length() > (long)newLen) {
                    FileOutputStream stm = null;
                    try {
                        try {
                            stm = new FileOutputStream(this.existing, true);
                            stm.getChannel().truncate(newLen);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (stm != null) {
                                try {
                                    stm.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stm != null) {
                            try {
                                stm.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (stm != null) {
                        try {
                            stm.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.in.close();
        }
    }

    public ComparisonStream(ByteArrayOutputStream out) {
        this.pathname = "";
        this.inBuff = new byte[0];
        this.pos = 0;
        this.end = 0;
        this.out = out;
    }
}

