/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Capsule;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ClassEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            return this.approveCreateElementRequest(request);
        }
        if (request instanceof MoveRequest) {
            return this.approveMoveRequest(request);
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreateElementRequest(IEditCommandRequest request) {
        IElementType umlPortType;
        CreateElementRequest createElementRequest = (CreateElementRequest)request;
        IElementType type = createElementRequest.getElementType();
        Element container = (Element)createElementRequest.getContainer();
        if (!UMLRTProfileUtils.isUMLRTProfileApplied(container)) {
            return super.approveRequest((IEditCommandRequest)createElementRequest);
        }
        Capsule capsule = (Capsule)UMLUtil.getStereotypeApplication((Element)container, Capsule.class);
        boolean isCapsule = capsule != null;
        IElementType rtStateMachineType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTStateMachine");
        if (rtStateMachineType != null) {
            if (ElementTypeUtils.isTypeCompatible(type, rtStateMachineType)) {
                return isCapsule;
            }
        } else {
            Activator.log.debug("Impossible to find element type for RT StateMachine");
        }
        if ((umlPortType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.Port")) != null) {
            if (ElementTypeUtils.isTypeCompatible(type, umlPortType)) {
                return isCapsule;
            }
        } else {
            Activator.log.debug("Impossible to find element type for UML Port");
        }
        return super.approveRequest(request);
    }

    protected boolean approveMoveRequest(IEditCommandRequest request) {
        MoveRequest moveRequest = (MoveRequest)request;
        EObject targetContainer = moveRequest.getTargetContainer();
        if (targetContainer instanceof Element && !UMLRTProfileUtils.isUMLRTProfileApplied((Element)targetContainer)) {
            return super.approveRequest(request);
        }
        Map elementsToMove = moveRequest.getElementsToMove();
        for (Object elementToMove : elementsToMove.keySet()) {
            if (!(elementToMove instanceof Port) || ((Port)elementToMove).eContainer() == null) continue;
            return false;
        }
        return super.approveRequest(request);
    }
}

