/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.internal.postprocessor.AbstractUMLChangeFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.AbstractUMLRTChangeFactory;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTCompareFactory;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTProtocolMessageParameterChangeFactory
extends AbstractUMLRTChangeFactory {
    public boolean handles(Diff input) {
        return this.isAddDeleteOfProtocolMessageParameter(input) || this.isTypeChangeOfProtocolMessageParameter(input) || this.isAttributeChangeOfProtocolMessageParameter(input);
    }

    private boolean isTypeChangeOfProtocolMessageParameter(Diff input) {
        if (input instanceof ReferenceChange) {
            ReferenceChange referenceChange = (ReferenceChange)input;
            EReference reference = referenceChange.getReference();
            EObject changedEObject = UMLRTCompareUtil.getChangedEObject(input);
            return UMLPackage.Literals.TYPED_ELEMENT__TYPE == reference && RTMessageUtils.isRTMessageParameter((EObject)changedEObject) && !this.requiresAddDeleteOfParameter(input);
        }
        return false;
    }

    private boolean isAddDeleteOfProtocolMessageParameter(Diff input) {
        return this.addDeleteOfParameter().apply((Object)input);
    }

    private boolean requiresAddDeleteOfParameter(Diff input) {
        return Iterables.any((Iterable)input.getRequires(), this.addDeleteOfParameter()) || Iterables.any((Iterable)input.getRequiredBy(), this.addDeleteOfParameter());
    }

    private Predicate<? super Diff> addDeleteOfParameter() {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (!(input instanceof ReferenceChange)) {
                    return false;
                }
                ReferenceChange referenceChange = (ReferenceChange)input;
                EObject value = referenceChange.getValue();
                EReference reference = referenceChange.getReference();
                return UMLPackage.Literals.BEHAVIORAL_FEATURE__OWNED_PARAMETER == reference && RTMessageUtils.isRTMessageParameter((EObject)value) && (referenceChange.getKind() == DifferenceKind.ADD || referenceChange.getKind() == DifferenceKind.DELETE);
            }
        };
    }

    private boolean isAttributeChangeOfProtocolMessageParameter(Diff input) {
        if (input instanceof AttributeChange) {
            EObject changedEObject = UMLRTCompareUtil.getChangedEObject(input);
            boolean result = RTMessageUtils.isRTMessageParameter((EObject)changedEObject);
            return result;
        }
        return false;
    }

    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        super.setRefiningChanges(extension, extensionKind, refiningDiff);
        if (refiningDiff instanceof AttributeChange) {
            extension.getRefinedBy().add((Object)refiningDiff);
        }
    }

    protected Switch<Set<EObject>> getDiscriminantsGetter() {
        return new AbstractUMLChangeFactory.DiscriminantsGetter(this){

            public Set<EObject> caseParameter(Parameter parameter) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.add((Object)parameter);
                return builder.build();
            }
        };
    }

    protected DifferenceKind getRelatedExtensionKind(Diff input) {
        return input.getKind();
    }

    protected EObject getDiscriminant(Diff input) {
        return (EObject)Iterables.find((Iterable)this.getDiscriminants(input), (Predicate)Predicates.instanceOf(Parameter.class), null);
    }

    public Diff createExtension() {
        return UMLRTCompareFactory.eINSTANCE.createProtocolMessageParameterChange();
    }
}

