/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.PropertyPartEditPartCN;
import org.eclipse.papyrusrt.umlrt.core.utils.MultiplicityElementAdapter;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPropertyUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTCommandUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.figures.RTPropertyPartFigure;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.InheritanceEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.PortContainerEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.RTSemanticEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.DrawFigureUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.util.ReificationListener;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Property;

public class RTPropertyPartEditPart
extends PropertyPartEditPartCN
implements IInheritableEditPart {
    private static final int LAYER_OPACITY = 255;
    private static final int X_OFFSET = 3;
    private static final int Y_OFFSET = 3;
    private static final int LAYER_NUMBER = 1;
    private static final String PATTERN_PATH = "/icons/hash_pattern_grey.png";
    private MultiplicityElementAdapter multiplicityValueListener;
    private ReificationListener reificationListener = this::reificationStateChanged;

    public RTPropertyPartEditPart(View view) {
        super(view);
    }

    public EObject resolveSemanticElement() {
        return EditPartInheritanceUtils.resolveSemanticElement(this, super.resolveSemanticElement());
    }

    public Object getAdapter(Class key) {
        return EditPartInheritanceUtils.getAdapter(this, key, super.getAdapter(key));
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("umlrtInheritance", (EditPolicy)new InheritanceEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new RTSemanticEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new PortContainerEditPolicy());
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        if (this.hasNotationView() && this.getNotationView().isSetElement()) {
            this.getMultiplicityListener().adapt((Notifier)this.getUMLElement());
        }
        this.getUMLRTElement().ifPresent(rt -> rt.addReificationListener(this.reificationListener));
    }

    protected void removeSemanticListeners() {
        this.getUMLRTElement().ifPresent(rt -> rt.removeReificationListener(this.reificationListener));
        super.removeSemanticListeners();
        if (this.multiplicityValueListener != null) {
            MultiplicityElement target = this.multiplicityValueListener.getTarget();
            if (target != null) {
                this.multiplicityValueListener.unadapt((Notifier)target);
            }
            this.multiplicityValueListener = null;
        }
    }

    protected MultiplicityElementAdapter getMultiplicityListener() {
        if (this.multiplicityValueListener == null) {
            this.multiplicityValueListener = new MultiplicityElementAdapter(){

                protected void handleMultiplicityChanged(Notification notification) {
                    RTPropertyPartEditPart.this.refreshVisuals();
                }
            };
        }
        return this.multiplicityValueListener;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new RTPropertyPartFigure();
        return this.primaryShape;
    }

    public RTPropertyPartFigure getPrimaryShape() {
        return (RTPropertyPartFigure)this.primaryShape;
    }

    protected void refreshVisuals() {
        boolean stack = false;
        if (this.hasNotationView() && this.getUMLElement() != null) {
            MultiplicityElement mult = (MultiplicityElement)this.getUMLElement();
            boolean isHash = mult.getLower() == 0;
            this.getPrimaryShape().setHashed(isHash);
            if (RTPropertyUtils.isReplicated((Property)((Property)this.getUMLElement()))) {
                stack = true;
            }
            this.getPrimaryShape().setStack(stack);
        }
        this.getPrimaryShape().setLayerNumber(1);
        this.getPrimaryShape().setXOffSet(3.0);
        this.getPrimaryShape().setYOffSet(3.0);
        this.getPrimaryShape().setPathPattern(PATTERN_PATH);
        this.getPrimaryShape().setLayerOpacity(this.isSemanticInherited() ? DrawFigureUtils.getLighterAlpha(255) : 255);
        super.refreshVisuals();
    }

    protected void refreshBackgroundColor() {
        super.refreshBackgroundColor();
        UMLRTEditPartUtils.updateBackgroundColor(this, (NodeFigure)this.getPrimaryShape());
    }

    protected void refreshForegroundColor() {
        super.refreshForegroundColor();
        UMLRTEditPartUtils.updateForegroundColor(this, (Figure)this.getPrimaryShape());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        boolean result;
        if (IRTPortEditPart.isPortOnPart(childEditPart)) {
            IRTPortEditPart portOnPart = (IRTPortEditPart)childEditPart;
            if (this.hasNotationView() && this.getNotationView().isSetElement()) {
                RTPortPositionLocator locator = new RTPortPositionLocator((Element)portOnPart.getPort(), this.getMainFigure(), 0, portOnPart.getDefaultScaleFactor());
                this.getBorderedFigure().getBorderItemContainer().add(portOnPart.getFigure(), (Object)locator);
            }
            result = true;
        } else {
            result = super.addFixedChild(childEditPart);
        }
        return result;
    }

    private void reificationStateChanged(UMLRTNamedElement element, boolean reified) {
        if (reified) {
            UMLRTCommandUtils.isUndoRedoInProgress((Notifier)element.toUML());
        }
    }
}

