/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.decorators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ScaledImageFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.TransitionEditPart;
import org.eclipse.papyrusrt.umlrt.core.utils.TransitionUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.DecorationEditPolicyEx;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.labelprovider.LabelUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Transition;

public class TransitionDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    public boolean provides(IOperation operation) {
        IDecoratorTarget target = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
        TransitionEditPart editPart = (TransitionEditPart)TypeUtils.as((Object)target.getAdapter(EditPart.class), TransitionEditPart.class);
        Transition transition = (Transition)TypeUtils.as((Object)target.getAdapter(EObject.class), Transition.class);
        return editPart != null && transition != null;
    }

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        View node = (View)decoratorTarget.getAdapter(View.class);
        if (node != null) {
            decoratorTarget.installDecorator((Object)"transition_decoration", (IDecorator)new TransitionDecorator(decoratorTarget));
        }
    }

    private static final class TransitionDecorator
    implements IDecorator,
    NotificationListener {
        public static final String KEY = "transition_decoration";
        private static final int IMAGE_SIZE = 32;
        private static final int DECORATION_SIZE = 16;
        private static final double DISTANCE_FROM_SOURCE = 10.0;
        private static final double SPACE = 20.0;
        private static final int MAX_LINES = 20;
        private static final String ELLIPSIS = "[...]";
        private List<Decoration> decorations = new ArrayList<Decoration>();
        private DecorationEditPolicyEx.TransitionDecoratorTarget decoratorTarget;
        private IDisposable listenerRegistration;

        TransitionDecorator(IDecoratorTarget decoratorTarget) {
            Assert.isTrue((boolean)(decoratorTarget instanceof DecorationEditPolicyEx.TransitionDecoratorTarget));
            this.decoratorTarget = (DecorationEditPolicyEx.TransitionDecoratorTarget)decoratorTarget;
        }

        protected DecorationEditPolicyEx.TransitionDecoratorTarget getDecoratorTarget() {
            return this.decoratorTarget;
        }

        public void activate() {
            TransactionalEditingDomain domain;
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null) {
                return;
            }
            EObject semantic = EMFHelper.getEObject((Object)editPart);
            if (semantic instanceof Transition && (domain = TransactionUtil.getEditingDomain((EObject)semantic)) != null) {
                DiagramEventBroker broker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
                broker.addNotificationListener(semantic, (NotificationListener)this);
                this.listenerRegistration = () -> broker.removeNotificationListener(semantic, (NotificationListener)this);
            }
            this.refresh();
        }

        public void deactivate() {
            if (this.listenerRegistration != null) {
                this.listenerRegistration.dispose();
                this.listenerRegistration = null;
            }
            this.removeDecorations();
        }

        public void addDecoration(IDecoration decoration) {
            Assert.isTrue((boolean)(decoration instanceof Decoration));
            this.decorations.add((Decoration)decoration);
        }

        protected void removeDecorations() {
            this.decorations.stream().forEach(dec -> this.getDecoratorTarget().removeDecoration((IDecoration)dec));
            this.decorations.clear();
        }

        public void refresh() {
            Behavior effect;
            ScaledImageFigure imageFigure;
            List guards;
            this.removeDecorations();
            double position = 10.0;
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            IFigure editPartFigure = ((IGraphicalEditPart)editPart).getFigure();
            final Transition transition = (Transition)TypeUtils.as((Object)this.getDecoratorTarget().getAdapter(EObject.class), Transition.class);
            if (transition == null) {
                return;
            }
            if (TransitionUtils.hasNameAndNoTriggers((Transition)transition)) {
                ScaledImageFigure imageFigure2 = new ScaledImageFigure(){

                    public IFigure getToolTip() {
                        Label tooltip = new Label("This transition has a specific name set, and no triggers.");
                        tooltip.setIconAlignment(1);
                        tooltip.setIcon(Activator.getImage("obj16_warning"));
                        this.setToolTip((IFigure)tooltip);
                        return super.getToolTip();
                    }
                };
                imageFigure2.setImage(Activator.getImage("obj_warning"));
                IMapMode mm = MapModeUtil.getMapMode((IFigure)editPartFigure);
                imageFigure2.setSize(mm.DPtoLP(16), mm.DPtoLP(16));
                imageFigure2.setScale(0.5);
                this.addDecoration(this.getDecoratorTarget().addFixedConnectionDecoration((IFigure)imageFigure2, position, false));
                position += 20.0;
            }
            if (!(guards = TransitionUtils.getGuards((Transition)transition)).isEmpty()) {
                final UMLRTInheritanceKind inheritance = guards.stream().map(UMLRTInheritanceKind::of).max(Comparator.naturalOrder()).orElse(UMLRTInheritanceKind.NONE);
                final IMapMode mm = MapModeUtil.getMapMode((IFigure)editPartFigure);
                imageFigure = new ScaledImageFigure(){

                    public IFigure getToolTip() {
                        String tooltipText = LabelUtils.abbreviateLines((String)LabelUtils.getGuardTooltip((Transition)transition), (int)20, (String)TransitionDecorator.ELLIPSIS);
                        Label tooltip = new Label(tooltipText);
                        tooltip.setIcon(Activator.getImage(Activator.getGuardSmallKey(inheritance)));
                        tooltip.setSize(mm.DPtoLP(16), mm.DPtoLP(16));
                        tooltip.setIconAlignment(1);
                        this.setToolTip((IFigure)tooltip);
                        return super.getToolTip();
                    }
                };
                imageFigure.setImage(Activator.getImage(Activator.getGuardKey(inheritance)));
                imageFigure.setSize(mm.DPtoLP(16), mm.DPtoLP(16));
                imageFigure.setScale(0.5);
                this.addDecoration(this.getDecoratorTarget().addFixedConnectionDecoration((IFigure)imageFigure, position, false));
                position += 20.0;
            }
            if ((effect = transition.getEffect()) != null) {
                final UMLRTInheritanceKind inheritance = UMLRTInheritanceKind.of((Element)effect);
                imageFigure = new ScaledImageFigure(){

                    public IFigure getToolTip() {
                        String effectText = LabelUtils.abbreviateLines((String)LabelUtils.getEffectTooltip((Behavior)effect), (int)20, (String)TransitionDecorator.ELLIPSIS);
                        Label tooltip = new Label(effectText);
                        tooltip.setIcon(Activator.getImage(Activator.getEffectSmallKey(inheritance)));
                        tooltip.setIconAlignment(1);
                        this.setToolTip((IFigure)tooltip);
                        return super.getToolTip();
                    }
                };
                imageFigure.setImage(Activator.getImage(Activator.getEffectKey(inheritance)));
                IMapMode mm = MapModeUtil.getMapMode((IFigure)editPartFigure);
                imageFigure.setSize(mm.DPtoLP(16), mm.DPtoLP(16));
                imageFigure.setScale(0.5);
                this.addDecoration(this.getDecoratorTarget().addFixedConnectionDecoration((IFigure)imageFigure, position, false));
                position += 20.0;
            }
        }

        public void notifyChanged(Notification notification) {
            this.refresh();
        }
    }
}

