/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.core.commands.ExclusionCommand;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.IFilteredObservableList;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade.IFacadeProperty;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade.IFilteredListProperty;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.provider.UMLRTEditPlugin;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

class FacadeListProperty<S extends UMLRTNamedElement, T extends UMLRTNamedElement>
extends SimpleListProperty<S, T>
implements IFilteredListProperty<S, T>,
IFacadeProperty {
    private final Class<T> elementType;
    private final EStructuralFeature facadeFeature;
    private final EStructuralFeature umlFeature;
    private List<T> listView;

    FacadeListProperty(Class<T> elementType, EStructuralFeature facadeFeature, EStructuralFeature umlFeature) {
        this.elementType = elementType;
        this.facadeFeature = facadeFeature;
        this.umlFeature = umlFeature;
    }

    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public String getPropertyName() {
        return UMLRTEditPlugin.INSTANCE.getString(String.format("_UI_%s_%s_feature", this.facadeFeature.getEContainingClass().getName(), this.facadeFeature.getName()));
    }

    @Override
    public IObservableList<T> observe(Realm realm, S source) {
        return IFilteredObservableList.wrap(super.observe(realm, source));
    }

    protected List<T> doGetList(S source) {
        if (this.listView == null) {
            Stream elements = this.eList(source).stream();
            Stream<UMLRTNamedElement> excluded = source.getExcludedElements().stream().filter(this.elementType::isInstance).map(this.elementType::cast);
            this.listView = Stream.concat(elements, excluded).sorted(UMLRTInheritanceKind.facadeComparator()).collect(Collectors.toList());
        }
        return this.listView;
    }

    protected <E> EList<E> eList(S source) {
        return this.eList((EObject)source, this.facadeFeature);
    }

    protected <E> EList<E> eList(NamedElement uml) {
        return this.eList(this.umlOwner(uml), this.umlFeature);
    }

    protected EObject umlOwner(NamedElement uml) {
        return uml;
    }

    private <E> EList<E> eList(EObject source, EStructuralFeature feature) {
        return (EList)source.eGet(feature);
    }

    protected void doSetList(S source, List<T> list, ListDiff<T> diff) {
        TransactionalEditingDomain domain;
        CompositeTransactionalCommand command;
        List<ICommand> commands = this.getCommands(source, diff);
        if (!commands.isEmpty() && (command = new CompositeTransactionalCommand(domain = TransactionUtil.getEditingDomain((EObject)source.toUML()), "Edit " + this.getPropertyName(), commands)).canExecute()) {
            domain.getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)command.reduce()));
            this.listView = null;
            this.doGetList(source);
        }
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ListDiff<T>> listener) {
        class NativeListener
        extends AdapterImpl
        implements INativePropertyListener<S> {
            private S source;
            private final /* synthetic */ ISimplePropertyListener val$listener;

            NativeListener(ISimplePropertyListener iSimplePropertyListener) {
                this.val$listener = iSimplePropertyListener;
            }

            public void addTo(S source) {
                ((Notifier)source).eAdapters().add((Object)this);
                this.source = source;
                this.addToMembers(source);
            }

            public void removeFrom(S source) {
                if (this.source == source) {
                    this.removeFromMembers(source);
                    ((Notifier)source).eAdapters().remove((Object)this);
                    this.source = null;
                }
            }

            private void addToMembers(S source) {
                FacadeListProperty.this.eList(source).forEach(this::addToElement);
            }

            private void removeFromMembers(S source) {
                FacadeListProperty.this.eList(source).forEach(this::removeFromElement);
            }

            private void addToElement(T facade) {
                EList adapters = facade.toUML().eAdapters();
                if (!adapters.contains((Object)this)) {
                    adapters.add(this);
                }
            }

            private void removeFromElement(T facade) {
                facade.toUML().eAdapters().remove((Object)this);
            }

            public void notifyChanged(Notification msg) {
                List<UMLRTNamedElement> added = Collections.emptyList();
                List<UMLRTNamedElement> removed = Collections.emptyList();
                List<Object> changed = Collections.emptyList();
                if (FacadeListProperty.this.listView != null && !msg.isTouch()) {
                    UMLRTNamedElement notifier;
                    if (msg.getNotifier() == this.source && msg.getFeature() == FacadeListProperty.this.facadeFeature) {
                        switch (msg.getEventType()) {
                            case 3: {
                                UMLRTNamedElement newElement = (UMLRTNamedElement)FacadeListProperty.this.elementType.cast(msg.getNewValue());
                                this.addToElement(newElement);
                                added = Collections.singletonList(newElement);
                                break;
                            }
                            case 5: {
                                List<UMLRTNamedElement> newElements = (List<UMLRTNamedElement>)msg.getNewValue();
                                newElements.forEach(this::addToElement);
                                added = newElements;
                                break;
                            }
                            case 4: {
                                UMLRTNamedElement oldElement = (UMLRTNamedElement)FacadeListProperty.this.elementType.cast(msg.getOldValue());
                                this.removeFromElement(oldElement);
                                removed = Collections.singletonList(oldElement);
                                break;
                            }
                            case 6: {
                                List<UMLRTNamedElement> oldElements = (List<UMLRTNamedElement>)msg.getOldValue();
                                oldElements.forEach(this::removeFromElement);
                                removed = oldElements;
                                break;
                            }
                            case 7: {
                                UMLRTNamedElement movedElement = (UMLRTNamedElement)FacadeListProperty.this.elementType.cast(msg.getNewValue());
                                removed = Collections.singletonList(movedElement);
                                added = Collections.singletonList(movedElement);
                                break;
                            }
                            case 1: 
                            case 9: {
                                UMLRTNamedElement newElement = (UMLRTNamedElement)FacadeListProperty.this.elementType.cast(msg.getNewValue());
                                this.addToElement(newElement);
                                UMLRTNamedElement oldElement = (UMLRTNamedElement)FacadeListProperty.this.elementType.cast(msg.getOldValue());
                                this.removeFromElement(oldElement);
                                removed = Collections.singletonList(oldElement);
                                added = Collections.singletonList(newElement);
                            }
                        }
                    } else if (msg.getNotifier() instanceof NamedElement && (notifier = (UMLRTNamedElement)TypeUtils.as((Object)UMLRTFactory.create((NamedElement)((NamedElement)msg.getNotifier())), (Class)FacadeListProperty.this.elementType)) != null) {
                        changed = Collections.singletonList(notifier);
                    }
                }
                if (!added.isEmpty() || !removed.isEmpty()) {
                    ArrayList oldListView = new ArrayList(FacadeListProperty.this.listView);
                    FacadeListProperty.this.listView = null;
                    ListDiff diff = Diffs.computeListDiff(oldListView, FacadeListProperty.this.doGetList(this.source));
                    if (!diff.isEmpty()) {
                        this.val$listener.handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, this.source, (IProperty)FacadeListProperty.this, (IDiff)diff));
                    }
                } else if (!changed.isEmpty()) {
                    UMLRTNamedElement changed_ = (UMLRTNamedElement)changed.get(0);
                    int position = FacadeListProperty.this.listView.indexOf(changed_);
                    this.val$listener.handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, this.source, (IProperty)FacadeListProperty.this, (IDiff)Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)position, (boolean)false, (Object)changed_), (ListDiffEntry)Diffs.createListDiffEntry((int)position, (boolean)true, (Object)changed_))));
                }
            }
        }
        return new NativeListener(listener);
    }

    protected List<? extends ICommand> getCommands(S source, ListDiff<T> diff) {
        final TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)source.toUML());
        final ArrayList result = new ArrayList();
        diff.accept(new ListDiffVisitor<T>((UMLRTNamedElement)source){
            private final /* synthetic */ UMLRTNamedElement val$source;
            {
                this.val$source = uMLRTNamedElement;
            }

            public void handleMove(int oldIndex, int newIndex, final T element) {
                EList newContainment;
                NamedElement elementAtOldPosition = ((UMLRTNamedElement)FacadeListProperty.this.listView.get(oldIndex)).toUML();
                NamedElement elementAtNewPosition = ((UMLRTNamedElement)FacadeListProperty.this.listView.get(newIndex)).toUML();
                EList containment = (EList)elementAtOldPosition.eContainer().eGet((EStructuralFeature)elementAtOldPosition.eContainmentFeature());
                if (containment == (newContainment = (EList)elementAtNewPosition.eContainer().eGet((EStructuralFeature)elementAtNewPosition.eContainmentFeature()))) {
                    oldIndex = containment.indexOf((Object)elementAtOldPosition);
                    newIndex = containment.indexOf((Object)elementAtNewPosition);
                    if (oldIndex >= 0 && newIndex >= 0) {
                        class MoveCommand
                        extends AbstractTransactionalCommand {
                            private EList<?> list;
                            private int oldIndex;
                            private int newIndex;

                            MoveCommand(TransactionalEditingDomain domain, String label, EList<?> list, int oldIndex, int newIndex) {
                                super(domain, label, MoveCommand.getWorkspaceFiles((EObject)var7_7.toUML()));
                                this.list = list;
                                this.oldIndex = oldIndex;
                                this.newIndex = newIndex;
                            }

                            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                this.list.move(this.newIndex, this.oldIndex);
                                return CommandResult.newOKCommandResult((Object)element);
                            }
                        }
                        result.add(new MoveCommand(domain, "Move " + FacadeListProperty.this.getPropertyName(), containment, oldIndex, newIndex, this.val$source));
                    }
                }
            }

            public void handleRemove(int index, T element) {
                switch (element.getInheritanceKind()) {
                    case INHERITED: 
                    case REDEFINED: {
                        result.add(ExclusionCommand.getExclusionCommand((TransactionalEditingDomain)domain, (Element)element.toUML(), (boolean)true));
                        break;
                    }
                    case NONE: {
                        DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)element.toUML(), false);
                        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)element.toUML());
                        ICommand destroy = edit.getEditCommand((IEditCommandRequest)request);
                        result.add(destroy);
                        break;
                    }
                }
            }

            public void handleAdd(int index, T element) {
                final EList list = FacadeListProperty.this.eList(this.val$source);
                class AddCommand
                extends AbstractTransactionalCommand {
                    private T element;

                    AddCommand(TransactionalEditingDomain domain, String label, T element) {
                        super(domain, label, AddCommand.getWorkspaceFiles((EObject)var5_5.toUML()));
                        this.element = element;
                    }

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        if (!list.contains(this.element)) {
                            FacadeListProperty.this.eList(val$source.toUML()).add((Object)this.element.toUML());
                        }
                        return CommandResult.newOKCommandResult(this.element);
                    }
                }
                result.add(new AddCommand(domain, "Add " + FacadeListProperty.this.getPropertyName(), element));
            }
        });
        return result;
    }
}

