/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InitializationKind implements Enumerator
{
    ASSIGNMENT(0, "Assignment", "Assignment"),
    CONSTANT(1, "Constant", "Constant"),
    CONSTRUCTOR(2, "Constructor", "Constructor");

    public static final int ASSIGNMENT_VALUE = 0;
    public static final int CONSTANT_VALUE = 1;
    public static final int CONSTRUCTOR_VALUE = 2;
    private static final InitializationKind[] VALUES_ARRAY;
    public static final List<InitializationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InitializationKind[]{ASSIGNMENT, CONSTANT, CONSTRUCTOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InitializationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InitializationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InitializationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InitializationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InitializationKind get(int value) {
        switch (value) {
            case 0: {
                return ASSIGNMENT;
            }
            case 1: {
                return CONSTANT;
            }
            case 2: {
                return CONSTRUCTOR;
            }
        }
        return null;
    }

    private InitializationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

