/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.NewElementUtil;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RTPortEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        IElementType type;
        boolean result = false;
        result = request instanceof CreateRelationshipRequest ? ((type = ((CreateRelationshipRequest)request).getElementType()) != null && ElementTypeUtils.isTypeCompatible(type, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTConnector")) ? this.checkSourceAndTarget((CreateRelationshipRequest)request) : super.approveRequest(request)) : super.approveRequest(request);
        return result;
    }

    protected boolean checkSourceAndTarget(CreateRelationshipRequest createRelationshipRequest) {
        EObject source = createRelationshipRequest.getSource();
        EObject target = createRelationshipRequest.getTarget();
        if (source != null) {
            if (ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            if (ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint").booleanValue()) {
                return false;
            }
        }
        if (target != null) {
            if (ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            if (ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint").booleanValue()) {
                return false;
            }
        }
        return true;
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Port port = (Port)request.getElementToConfigure();
        NewElementUtil.elementCreated((EObject)port);
        CompositeCommand compositeCommand = new CompositeCommand("Before Configure RTPort");
        compositeCommand.add((IUndoableOperation)new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                port.setIsOrdered(true);
                return CommandResult.newOKCommandResult((Object)port);
            }
        });
        return compositeCommand.isEmpty() ? super.getBeforeConfigureCommand(request) : compositeCommand;
    }

    protected ICommand getAfterCreateCommand(CreateElementRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Default MultiplicityCommand RTPort");
        request.getNewElement();
        return compositeCommand.isEmpty() ? super.getAfterCreateCommand(request) : compositeCommand;
    }

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        ICommand setKindCommand;
        CompositeCommand compositeCommand = new CompositeCommand("Set RTPort");
        EStructuralFeature feature = request.getFeature();
        Port portToEdit = (Port)request.getElementToEdit();
        RTPort rtPortToEdit = (RTPort)UMLUtil.getStereotypeApplication((Element)portToEdit, RTPort.class);
        if (UMLPackage.eINSTANCE.getPort_IsService().equals(feature)) {
            ICommand publishedCommand;
            ICommand visibilityCommand = this.getVisibilityCommand(request, portToEdit);
            if (visibilityCommand != null && visibilityCommand.canExecute()) {
                compositeCommand.add((IUndoableOperation)visibilityCommand);
            }
            if ((publishedCommand = this.getPublishCommand(request, rtPortToEdit)) != null && publishedCommand.canExecute()) {
                compositeCommand.add((IUndoableOperation)publishedCommand);
            }
        }
        if ((setKindCommand = this.getSetKindCommand(request)) != null) {
            compositeCommand.add((IUndoableOperation)setKindCommand);
        }
        return compositeCommand.isEmpty() ? super.getAfterSetCommand(request) : compositeCommand;
    }

    protected ICommand getVisibilityCommand(SetRequest request, Port portToEdit) {
        boolean isService = (Boolean)request.getValue();
        EAttribute visibilityFeature = UMLPackage.eINSTANCE.getNamedElement_Visibility();
        VisibilityKind visibility = isService ? VisibilityKind.PUBLIC_LITERAL : VisibilityKind.PROTECTED_LITERAL;
        IElementEditService serviceEdit = ElementEditServiceUtils.getCommandProvider((Object)portToEdit);
        SetRequest setVisibilityRequest = new SetRequest((EObject)portToEdit, (EStructuralFeature)visibilityFeature, (Object)visibility);
        ICommand visibilityCommand = serviceEdit.getEditCommand((IEditCommandRequest)setVisibilityRequest);
        return visibilityCommand;
    }

    protected ICommand getPublishCommand(SetRequest request, RTPort rtPortToEdit) {
        boolean isWired = rtPortToEdit.isWired();
        boolean isService = (Boolean)request.getValue();
        boolean isPublish = !isWired && isService;
        IElementEditService serviceEdit = ElementEditServiceUtils.getCommandProvider((Object)rtPortToEdit);
        EAttribute featurePublish = UMLRealTimePackage.eINSTANCE.getRTPort_IsPublish();
        SetRequest requestPublish = new SetRequest((EObject)rtPortToEdit, (EStructuralFeature)featurePublish, (Object)isPublish);
        ICommand gmfCommand = serviceEdit.getEditCommand((IEditCommandRequest)requestPublish);
        return gmfCommand;
    }

    protected ICommand getSetKindCommand(SetRequest request) {
        ICommand cmd = null;
        EObject object = request.getElementToEdit();
        Object kindParameter = request.getParameter("RTPORT_KIND");
        if (object instanceof Port && kindParameter != null && kindParameter instanceof RTPortKindEnum) {
            Port rtPort = (Port)object;
            cmd = RTPortUtils.getChangePortKindCommand(rtPort, (RTPortKindEnum)kindParameter);
        }
        return cmd;
    }
}

