/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.tools.utils.CustomUMLUtil;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageService;
import org.eclipse.papyrusrt.umlrt.core.utils.ModelUtils;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTGuard;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public final class CodeSnippetUtils {
    private CodeSnippetUtils() {
    }

    public static IDefaultLanguage getDefaultLanguage(Element context) {
        IDefaultLanguage language = null;
        try {
            IDefaultLanguageService service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)context);
            language = service.getActiveDefaultLanguage(context);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return language;
    }

    public static Constraint createGuard(Namespace owner) {
        return CodeSnippetUtils.createGuard(owner, Collections.EMPTY_LIST);
    }

    public static Constraint createGuard(Namespace owner, List<Element> constrainedElements) {
        Constraint result = owner.createOwnedRule(null);
        result.getConstrainedElements().addAll(constrainedElements);
        result.setSpecification((ValueSpecification)CodeSnippetUtils.createOpaqueExpressionWithDefaultLanguage((Element)owner));
        CustomUMLUtil.StereotypeApplicationHelper.getInstance((Notifier)owner).applyStereotype((Element)result, UMLRTStateMachinesPackage.Literals.RT_GUARD);
        return result;
    }

    public static Constraint getTriggerGuard(Trigger trigger) {
        Optional<UMLRTTrigger> facade = Optional.ofNullable(UMLRTTrigger.getInstance((Trigger)trigger));
        return facade.map(UMLRTTrigger::getGuard).map(UMLRTGuard::toUML).orElse(null);
    }

    public static OpaqueExpression createOpaqueExpressionWithDefaultLanguage(Element context) {
        OpaqueExpression result = (OpaqueExpression)ModelUtils.create((EObject)context, UMLPackage.Literals.OPAQUE_EXPRESSION);
        result.getBodies().add((Object)"");
        IDefaultLanguage language = CodeSnippetUtils.getDefaultLanguage(context);
        if (language != null) {
            result.getLanguages().add((Object)language.getName());
        }
        return result;
    }

    public static OpaqueBehavior createOpaqueBehaviorWithDefaultLanguage(Element context) {
        OpaqueBehavior result = (OpaqueBehavior)ModelUtils.create((EObject)context, UMLPackage.Literals.OPAQUE_BEHAVIOR);
        result.getBodies().add((Object)"");
        IDefaultLanguage language = CodeSnippetUtils.getDefaultLanguage(context);
        if (language != null) {
            result.getLanguages().add((Object)language.getName());
        }
        return result;
    }
}

