/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.drop;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.system.profile.util.SystemElementsUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.drop.AbstractProtocolToRTPortDropStrategy;
import org.eclipse.uml2.uml.Collaboration;

public class ProtocolToExternalBehaviorPortDropStrategy
extends AbstractProtocolToRTPortDropStrategy {
    public String getLabel() {
        return "Protocol drop to create External Behavior Port";
    }

    public String getDescription() {
        return "Protocol drop to create External Behavior Port";
    }

    public String getID() {
        return "org.eclipse.papyrusrt.umlrt.tooling.diagram.common.protocolToExternalBehaviorPortDrop";
    }

    @Override
    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        List<Collaboration> droppedProtocols;
        boolean canHandle = false;
        if (!(targetEditPart instanceof DiagramEditPart || targetEditPart instanceof CompartmentEditPart || !(request instanceof DropObjectsRequest) || this.getSourceEObjects(request).isEmpty() || (droppedProtocols = this.getSourceEObjects(request).stream().filter(Collaboration.class::isInstance).map(Collaboration.class::cast).collect(Collectors.toList())).isEmpty())) {
            canHandle = this.canDrop(droppedProtocols);
        }
        return canHandle ? super.doGetCommand(request, targetEditPart) : null;
    }

    @Override
    protected RTPortKindEnum getRTPortKind() {
        return RTPortKindEnum.EXTERNAL;
    }

    private boolean canDrop(List<Collaboration> droppedObjects) {
        return !droppedObjects.stream().anyMatch(c -> SystemElementsUtils.isBaseProtocol((Collaboration)c) || SystemElementsUtils.isSystemProtocol((Collaboration)c));
    }
}

