/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.layout;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeOperation;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocationHelper;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleStructureDiagramUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TypedElement;

public class PortOnCapsulePartLayoutProvider
extends AbstractLayoutEditPartProvider {
    public boolean provides(IOperation operation) {
        IGraphicalEditPart container;
        EObject maybeCapsulePart;
        ILayoutNodeOperation layout;
        boolean result = false;
        if (operation instanceof ILayoutNodeOperation && "DEFAULT".equals((layout = (ILayoutNodeOperation)operation).getLayoutHint().getAdapter(String.class)) && (maybeCapsulePart = (container = (IGraphicalEditPart)layout.getLayoutHint().getAdapter(IGraphicalEditPart.class)).resolveSemanticElement()) instanceof Property && CapsulePartUtils.isCapsulePart((Property)((Property)maybeCapsulePart))) {
            List nodes = layout.getLayoutNodes();
            result = nodes.stream().map(ILayoutNode::getNode).allMatch(this::isRTPort);
        }
        return result;
    }

    private boolean isRTPort(Node node) {
        return node.getElement() instanceof Port && RTPortUtils.isRTPort((EObject)node.getElement());
    }

    public Command layoutEditParts(GraphicalEditPart containerEditPart, IAdaptable layoutHint) {
        IGraphicalEditPart capsulePart = (IGraphicalEditPart)layoutHint.getAdapter(IGraphicalEditPart.class);
        List<IGraphicalEditPart> ports = this.getPorts(capsulePart.getChildren());
        return this.getRelativePortLayoutCommand(capsulePart, ports);
    }

    private final List<IGraphicalEditPart> getPorts(List<?> editParts) {
        return editParts.stream().filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).filter(ep -> ep.resolveSemanticElement() instanceof Port).collect(Collectors.toList());
    }

    private Command getRelativePortLayoutCommand(IGraphicalEditPart capsulePart, List<IGraphicalEditPart> ports) {
        Optional<Diagram> capsuleStructureDiagram = Optional.ofNullable(capsulePart.getNotationView()).map(View::getElement).map(Property.class::cast).map(TypedElement::getType).map(Class.class::cast).map(UMLRTCapsuleStructureDiagramUtils::getCapsuleStructureDiagram);
        return capsuleStructureDiagram.map(diagram -> {
            Command result = null;
            View frame = ViewUtil.getChildBySemanticHint((View)diagram, (String)"Class_Shape");
            if (frame instanceof Node) {
                Bounds frameBounds = (Bounds)((Node)frame).getLayoutConstraint();
                RelativePortLocationHelper helper = new RelativePortLocationHelper((EditPart)capsulePart);
                EList frameChildren = frame.getChildren();
                for (IGraphicalEditPart portOnPart : ports) {
                    View view = portOnPart.getNotationView();
                    Port port = (Port)(view == null ? null : view.getElement());
                    Optional<Node> portOnCapsule = frameChildren.stream().filter(Node.class::isInstance).map(Node.class::cast).filter(node -> node.getElement() == port).findAny();
                    portOnCapsule.ifPresent(p -> helper.memoizeRelativePortLocation((EditPart)portOnPart, (Bounds)p.getLayoutConstraint(), frameBounds));
                }
                result = helper.getPortUpdateCommand();
            }
            return result;
        }).orElse(null);
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        IGraphicalEditPart capsulePart = (IGraphicalEditPart)layoutHint.getAdapter(IGraphicalEditPart.class);
        List<IGraphicalEditPart> ports = this.getPorts(selectedObjects);
        return this.getRelativePortLayoutCommand(capsulePart, ports);
    }
}

