/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomRegionEditPart;
import org.eclipse.papyrusrt.umlrt.core.utils.Either;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.InheritanceEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.RTSemanticEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IStateMachineInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Region;

public class RTRegionEditPart
extends CustomRegionEditPart
implements IStateMachineInheritableEditPart {
    public RTRegionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("umlrtInheritance", (EditPolicy)new InheritanceEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new RTSemanticEditPolicy());
    }

    public EObject resolveSemanticElement() {
        return EditPartInheritanceUtils.resolveSemanticElement((IInheritableEditPart)this, (EObject)super.resolveSemanticElement());
    }

    public Object getAdapter(Class key) {
        return EditPartInheritanceUtils.getAdapter((IGraphicalEditPart)this, (Class)key, (Object)super.getAdapter(key));
    }

    public boolean isSemanticInherited() {
        EObject semantic = this.resolveSemanticElement();
        return semantic instanceof Region && UMLRTExtensionUtil.isInherited((Element)((Region)semantic));
    }

    public Optional<UMLRTNamedElement> getUMLRTElement() {
        Optional<UMLRTNamedElement> result = Optional.empty();
        EObject semantic = this.resolveSemanticElement();
        if (semantic instanceof Region) {
            Region region = (Region)semantic;
            result = Optional.ofNullable((NamedElement)Either.or((Object)region.getStateMachine(), (Object)region.getState()).orElse(NamedElement.class, null)).map(UMLRTFactory::create);
        }
        return result;
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext(UMLRTNamedElement element) {
        Predicate<UMLRTNamedElement> same = element::equals;
        Predicate<UMLRTNamedElement> redefinition = e -> e.redefines(element);
        return this.getUMLRTElement().filter(same.or(redefinition)).map(__ -> element).orElseGet(() -> (UMLRTNamedElement)EditPartInheritanceUtils.getStateMachineContext((UMLRTNamedElement)element).getEither(UMLRTNamedElement.class));
    }
}

