/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.constraints;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;

public class IsElementTypeMatchingConstraint
extends AbstractConstraint {
    private String elementTypeID;

    public void setDescriptor(SimpleConstraint descriptor) {
        this.elementTypeID = this.getValue("elementTypeID");
    }

    public boolean match(Object selection) {
        IElementType type;
        Element objectSemantic = UMLUtil.resolveUMLElement((Object)selection);
        if (objectSemantic != null && (type = ElementTypeRegistry.getInstance().getType(this.elementTypeID)) != null) {
            EClass metamodelClass;
            if (type instanceof ISpecializationType) {
                IElementMatcher matcher = ((ISpecializationType)type).getMatcher();
                if (matcher != null) {
                    return matcher.matches((EObject)objectSemantic);
                }
            } else if (type instanceof IMetamodelType && (metamodelClass = ((IMetamodelType)type).getEClass()) != null) {
                return metamodelClass.isSuperTypeOf(objectSemantic.eClass());
            }
        }
        return false;
    }

    public boolean overrides(Constraint constraint) {
        boolean result;
        if (!(constraint instanceof IsElementTypeMatchingConstraint)) {
            return false;
        }
        IsElementTypeMatchingConstraint elementTypeConstraint = (IsElementTypeMatchingConstraint)constraint;
        boolean bl = result = !this.getElementTypeID().equals(elementTypeConstraint.getElementTypeID());
        return result || super.overrides(constraint);
    }

    public String toString() {
        return String.format("IsElementTypeMatchingConstraint %s (%s)", this.getElementTypeID(), this.getDisplayUnit().getElementMultiplicity() == 1 ? "Single" : "Multiple");
    }

    protected boolean equivalent(Constraint constraint) {
        if (this == constraint) {
            return true;
        }
        if (constraint == null) {
            return false;
        }
        if (!(constraint instanceof IsElementTypeMatchingConstraint)) {
            return false;
        }
        IsElementTypeMatchingConstraint other = (IsElementTypeMatchingConstraint)constraint;
        return !(this.getElementTypeID() == null ? other.getElementTypeID() != null : !this.getElementTypeID().equals(other.getElementTypeID()));
    }

    public String getElementTypeID() {
        return this.elementTypeID;
    }
}

