/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePartKind;

public enum CapsulePartKindEnum {
    FIXED(0, "Fixed", UMLRTCapsulePartKind.FIXED),
    OPTIONAL(1, "Optional", UMLRTCapsulePartKind.OPTIONAL),
    PLUGIN(2, "Plugin", UMLRTCapsulePartKind.PLUG_IN);

    private static final Map<UMLRTCapsulePartKind, CapsulePartKindEnum> FACADE_MAP;
    private final String label;
    private final int index;
    private final UMLRTCapsulePartKind facadeKind;

    static {
        FACADE_MAP = new EnumMap<UMLRTCapsulePartKind, CapsulePartKindEnum>(UMLRTCapsulePartKind.class);
        FACADE_MAP.put(UMLRTCapsulePartKind.NULL, null);
        Arrays.asList(CapsulePartKindEnum.values()).forEach(k -> {
            CapsulePartKindEnum capsulePartKindEnum = FACADE_MAP.put(k.toFacade(), (CapsulePartKindEnum)((Object)k));
        });
    }

    public String getLabel() {
        return this.label;
    }

    public int getIndex() {
        return this.index;
    }

    private CapsulePartKindEnum(int index, String label, UMLRTCapsulePartKind facadeKind) {
        this.label = label;
        this.index = index;
        this.facadeKind = facadeKind;
    }

    public static CapsulePartKindEnum fromFacade(UMLRTCapsulePartKind facadeKind) {
        return FACADE_MAP.get(facadeKind);
    }

    public UMLRTCapsulePartKind toFacade() {
        return this.facadeKind;
    }

    public static UMLRTCapsulePartKind toFacade(CapsulePartKindEnum kind) {
        return kind == null ? UMLRTCapsulePartKind.NULL : kind.toFacade();
    }

    public String toString() {
        return this.label;
    }
}

