/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.PortRegistrationType;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPortKind;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;

public final class RTPortUtils {
    public static final String RTPORT_KIND_REQUEST_PARAMETER = "RTPORT_KIND";

    private RTPortUtils() {
    }

    public static boolean isRTPort(EObject eObject) {
        if (eObject instanceof Port) {
            Port port = (Port)eObject;
            return RTPortUtils.getStereotypeApplication(port) != null;
        }
        return false;
    }

    public static boolean isConnected(Port port) {
        return RTPortUtils.isConnectedInside(port) || RTPortUtils.isConnectedOutside(port);
    }

    public static boolean isConnectedInside(Port port) {
        UMLRTPort rt = UMLRTPort.getInstance((Port)port);
        return rt != null && rt.isConnectedInside();
    }

    public static boolean isConnectedOutside(Port port) {
        UMLRTPort rt = UMLRTPort.getInstance((Port)port);
        return rt != null && rt.isConnectedOutside();
    }

    public static RTPort getStereotypeApplication(Port port) {
        RTPort RTport = null;
        if (port != null) {
            RTport = (RTPort)UMLUtil.getStereotypeApplication((Element)port, RTPort.class);
        }
        return RTport;
    }

    public static boolean isWired(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isWired());
    }

    public static boolean isPublish(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isPublish());
    }

    public static boolean isNotification(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isNotification());
    }

    public static PortRegistrationType getRegistration(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? null : RTPortUtils.getStereotypeApplication(port).getRegistration();
    }

    public static String getRegistrationOverride(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? null : RTPortUtils.getStereotypeApplication(port).getRegistrationOverride();
    }

    public static boolean isBehavior(Port port) {
        return port.isBehavior();
    }

    public static boolean isService(Port port) {
        return port.isService();
    }

    public static boolean isConjugated(Port port) {
        return port.isConjugated();
    }

    public static UMLRTPortKind getPortKind(Port port) {
        UMLRTPortKind kind = null;
        if (RTPortUtils.isRTPort((EObject)port)) {
            if (RTPortUtils.isService(port) && RTPortUtils.isWired(port) && RTPortUtils.isBehavior(port) && !RTPortUtils.isPublish(port)) {
                kind = UMLRTPortKind.EXTERNAL_BEHAVIOR;
            } else if (RTPortUtils.isBehavior(port) && RTPortUtils.isPublish(port) && !RTPortUtils.isWired(port)) {
                kind = UMLRTPortKind.SPP;
            } else if (RTPortUtils.isWired(port) && RTPortUtils.isBehavior(port) && !RTPortUtils.isService(port) && !RTPortUtils.isPublish(port)) {
                kind = UMLRTPortKind.INTERNAL_BEHAVIOR;
            } else if (RTPortUtils.isService(port) && RTPortUtils.isWired(port) && !RTPortUtils.isBehavior(port) && !RTPortUtils.isPublish(port)) {
                kind = UMLRTPortKind.RELAY;
            } else if (RTPortUtils.isBehavior(port) && !RTPortUtils.isWired(port) && !RTPortUtils.isPublish(port)) {
                kind = UMLRTPortKind.SAP;
            }
        }
        return kind;
    }

    @Deprecated
    public static RTPortKindEnum getKind(Port port) {
        return RTPortKindEnum.fromFacade(RTPortUtils.getPortKind(port));
    }

    public static UMLRTPortKind getPortKind(IElementType elementType) {
        UMLRTPortKind result = null;
        if (elementType != null && ElementTypeUtils.isTypeCompatible(elementType, (IElementType)UMLRTElementTypesEnumerator.RT_PORT)) {
            if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.InternalBehaviorPort"))) {
                result = UMLRTPortKind.INTERNAL_BEHAVIOR;
            } else if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ExternalBehaviorPort"))) {
                result = UMLRTPortKind.EXTERNAL_BEHAVIOR;
            } else if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint"))) {
                result = UMLRTPortKind.SPP;
            } else if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint"))) {
                result = UMLRTPortKind.SAP;
            } else if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RelayPort"))) {
                result = UMLRTPortKind.RELAY;
            }
        }
        return result;
    }

    public IHintedType getElementType(UMLRTPortKind portKind) {
        IHintedType result;
        switch (portKind) {
            case EXTERNAL_BEHAVIOR: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ExternalBehaviorPort");
                break;
            }
            case INTERNAL_BEHAVIOR: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.InternalBehaviorPort");
                break;
            }
            case RELAY: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RelayPort");
                break;
            }
            case SAP: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint");
                break;
            }
            case SPP: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint");
                break;
            }
            default: {
                result = UMLRTElementTypesEnumerator.RT_PORT;
            }
        }
        return result;
    }

    @Deprecated
    public static Command getChangeKindCommand(Port port, RTPortKindEnum newKind, boolean checkInitialStatus) {
        return RTPortUtils.getChangeKindCommand(port, newKind.toFacade(), checkInitialStatus);
    }

    public static Command getChangeKindCommand(Port port, UMLRTPortKind newKind, boolean checkInitialStatus) {
        return GMFtoEMFCommandWrapper.wrap((ICommand)RTPortUtils.getChangePortKindCommand(port, newKind, checkInitialStatus));
    }

    @Deprecated
    public static boolean isKindEditable(Port port, RTPortKindEnum newKind) {
        return RTPortUtils.isKindEditable(port, newKind.toFacade());
    }

    public static boolean isKindEditable(Port port, UMLRTPortKind newKind) {
        UMLRTPortKind currentKind;
        UMLRTPort portFacade;
        boolean result = true;
        UMLRTPort uMLRTPort = portFacade = port == null ? null : UMLRTPort.getInstance((Port)port);
        if (portFacade != null && newKind != (currentKind = portFacade.getKind())) {
            if (portFacade.isInherited()) {
                result = newKind.isExternal() == currentKind.isExternal() && newKind.isWired() == currentKind.isWired() && newKind.isPublish() == currentKind.isPublish();
            }
            switch (currentKind) {
                case EXTERNAL_BEHAVIOR: {
                    if (portFacade.isConnectedOutside()) {
                        result = result && newKind == UMLRTPortKind.RELAY;
                        break;
                    }
                    if (!portFacade.isConnectedInside()) break;
                    result = result && newKind.isWired();
                    break;
                }
                case INTERNAL_BEHAVIOR: {
                    if (portFacade.isConnectedInside()) {
                        result = result && newKind == UMLRTPortKind.RELAY;
                        break;
                    }
                    if (!portFacade.isConnectedOutside()) break;
                    result = result && newKind.isWired();
                    break;
                }
                case RELAY: {
                    if (portFacade.isConnectedInside()) {
                        boolean bl = result = result && newKind == UMLRTPortKind.INTERNAL_BEHAVIOR;
                    }
                    if (!portFacade.isConnectedOutside()) break;
                    result = result && newKind == UMLRTPortKind.EXTERNAL_BEHAVIOR;
                    break;
                }
                case SAP: {
                    break;
                }
                case SPP: {
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled port kind";
                    break;
                }
            }
        }
        return result;
    }

    public static ICommand getChangePortKindCommand(Port port, UMLRTPortKind newKind, boolean checkInitialStatus) {
        if (!checkInitialStatus) {
            return RTPortUtils.getChangePortKindCommand(port, newKind);
        }
        if (!RTPortUtils.isKindEditable(port, newKind)) {
            return UnexecutableCommand.INSTANCE;
        }
        return RTPortUtils.getChangePortKindCommand(port, newKind);
    }

    public static Command getChangeKindCommand(Port port, UMLRTPortKind newKind) {
        return GMFtoEMFCommandWrapper.wrap((ICommand)RTPortUtils.getChangePortKindCommand(port, newKind));
    }

    public static ICommand getChangePortKindCommand(Port port, UMLRTPortKind newKind) {
        ICommand command = null;
        switch (newKind) {
            case EXTERNAL_BEHAVIOR: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, true, true, true, VisibilityKind.PUBLIC_LITERAL);
                break;
            }
            case INTERNAL_BEHAVIOR: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, false, true, true, VisibilityKind.PROTECTED_LITERAL);
                break;
            }
            case RELAY: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, true, true, false, VisibilityKind.PUBLIC_LITERAL);
                break;
            }
            case SAP: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, false, false, true, VisibilityKind.PROTECTED_LITERAL);
                break;
            }
            case SPP: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, true, false, true, VisibilityKind.PUBLIC_LITERAL);
                break;
            }
            default: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, true, true, false, VisibilityKind.PUBLIC_LITERAL);
            }
        }
        return command;
    }

    @Deprecated
    public static ICommand getChangePortKindCommand(Port port, RTPortKindEnum newKind, boolean checkInitialStatus) {
        return RTPortUtils.getChangePortKindCommand(port, newKind.toFacade(), checkInitialStatus);
    }

    @Deprecated
    public static Command getChangeKindCommand(Port port, RTPortKindEnum newKind) {
        return RTPortUtils.getChangeKindCommand(port, newKind.toFacade());
    }

    @Deprecated
    public static ICommand getChangePortKindCommand(Port port, RTPortKindEnum newKind) {
        return RTPortUtils.getChangePortKindCommand(port, newKind.toFacade());
    }

    protected static ICommand getRTPortKindChangeCommand(Port port, boolean service, boolean wired, boolean behavior, VisibilityKind visibility) {
        RTPort rtPort = RTPortUtils.getStereotypeApplication(port);
        if (rtPort == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)port);
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(domain, "Setting RTPort Kind");
        if (port.isBehavior() != behavior) {
            command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)port, (EStructuralFeature)UMLPackage.eINSTANCE.getPort_IsBehavior(), (Object)behavior)));
        }
        if (port.isService() != service) {
            command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)port, (EStructuralFeature)UMLPackage.eINSTANCE.getPort_IsService(), (Object)service)));
        }
        if (port.getVisibility() != visibility) {
            command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)port, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Visibility(), (Object)visibility)));
        }
        if (rtPort.isWired() != wired) {
            command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)rtPort, (EStructuralFeature)UMLRealTimePackage.eINSTANCE.getRTPort_IsWired(), (Object)wired)));
        }
        if (rtPort.isWired() != wired || port.isService() != service) {
            command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)rtPort, (EStructuralFeature)UMLRealTimePackage.eINSTANCE.getRTPort_IsPublish(), (Object)(!wired && service ? 1 : 0))));
        }
        if (wired) {
            if (rtPort.getRegistration() != PortRegistrationType.AUTOMATIC) {
                command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)rtPort, (EStructuralFeature)UMLRealTimePackage.eINSTANCE.getRTPort_Registration(), (Object)PortRegistrationType.AUTOMATIC)));
            }
            if (!"".equals(rtPort.getRegistrationOverride())) {
                command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)rtPort, (EStructuralFeature)UMLRealTimePackage.eINSTANCE.getRTPort_RegistrationOverride(), (Object)"")));
            }
        }
        return command.reduce();
    }

    public static boolean isLegacySpp(Port port) {
        if (RTPortUtils.getPortKind(port) == UMLRTPortKind.SPP) {
            return !port.isService();
        }
        return false;
    }

    public static boolean isLegacySap(Port port) {
        if (RTPortUtils.getPortKind(port) == UMLRTPortKind.SAP) {
            return port.isService();
        }
        return false;
    }
}

