/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.tables.manager.cell;

import java.util.Collections;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.CodeSnippetUtils;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class TriggerGuardCellManager
extends AbstractCellManager {
    public boolean handles(Object columnElement, Object rowElement) {
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        Object column = AxisUtils.getRepresentedElement((Object)columnElement);
        return row instanceof Trigger && UMLPackage.Literals.TRANSITION__GUARD.equals(column);
    }

    public boolean isCellEditable(Object columnElement, Object rowElement) {
        return super.isCellEditable(columnElement, rowElement);
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ValueSpecification spec;
        Trigger trigger = (Trigger)AxisUtils.getRepresentedElement((Object)rowElement);
        Constraint guard = this.getTriggerGuard(trigger, false);
        if (guard != null && guard.getSpecification() != null && (spec = guard.getSpecification()) instanceof OpaqueExpression && !((OpaqueExpression)spec).getBodies().isEmpty()) {
            return ((OpaqueExpression)spec).getBodies().get(0);
        }
        return "";
    }

    private Constraint getTriggerGuard(Trigger trigger, boolean createOnDemand) {
        Transition transition = (Transition)trigger.eContainer();
        Constraint result = CodeSnippetUtils.getTriggerGuard((Trigger)trigger);
        if (result == null && createOnDemand) {
            result = CodeSnippetUtils.createGuard((Namespace)transition, Collections.singletonList(trigger));
        }
        return result;
    }

    public void setValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        Trigger trigger = (Trigger)AxisUtils.getRepresentedElement((Object)rowElement);
        if (UML2Util.isEmpty((String)newValue.toString())) {
            Constraint guard = this.getTriggerGuard(trigger, false);
            if (guard != null) {
                guard.destroy();
            }
        } else {
            OpaqueExpression op;
            Constraint guard = this.getTriggerGuard(trigger, true);
            ValueSpecification valueSpec = guard.getSpecification();
            if (valueSpec != null && !(valueSpec instanceof OpaqueExpression)) {
                valueSpec.destroy();
                valueSpec = null;
            }
            if (valueSpec == null) {
                valueSpec = CodeSnippetUtils.createOpaqueExpressionWithDefaultLanguage((Element)trigger);
                guard.setSpecification(valueSpec);
            }
            if ((op = (OpaqueExpression)valueSpec).getBodies().isEmpty()) {
                op.getBodies().add((Object)newValue.toString());
            } else {
                String oldValue = (String)op.getBodies().get(0);
                if (!oldValue.equals(newValue)) {
                    op.getBodies().set(0, (Object)newValue.toString());
                }
            }
        }
    }
}

