/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.providers;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.DelegatingItemLabelProvider;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocolMessage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.uml2.uml.MultiplicityElement;

public class FacadeLabelProvider
extends EMFFilteredLabelProvider {
    private final CopyOnWriteArrayList<ILabelProviderListener> listeners = new CopyOnWriteArrayList();
    private final IItemLabelProvider delegate;
    private final INotifyChangedListener changeForwarder = this::forwardChange;

    public FacadeLabelProvider() {
        this.delegate = new DelegatingItemLabelProvider();
        if (this.delegate instanceof IChangeNotifier) {
            ((IChangeNotifier)this.delegate).addListener(this.changeForwarder);
        }
    }

    public void dispose() {
        if (this.delegate instanceof IChangeNotifier) {
            ((IChangeNotifier)this.delegate).removeListener(this.changeForwarder);
        }
        super.dispose();
    }

    public boolean accept(Object element) {
        if (element instanceof IStructuredSelection) {
            return this.accept((IStructuredSelection)element);
        }
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject == null) {
            return false;
        }
        return eObject.eClass().getEPackage() == UMLRTUMLRTPackage.eINSTANCE;
    }

    protected String getText(EObject element) {
        if (element instanceof UMLRTProtocolMessage) {
            UMLRTProtocolMessage message = (UMLRTProtocolMessage)element;
            switch (message.getKind()) {
                case IN: {
                    return "in " + this.getText((EObject)message.toUML());
                }
                case OUT: {
                    return "out " + this.getText((EObject)message.toUML());
                }
                case IN_OUT: {
                    return "inout " + this.getText((EObject)message.toUML());
                }
            }
            return this.getText((EObject)message.toUML());
        }
        if (element instanceof FacadeObject) {
            element = ((FacadeObject)element).toUML();
        }
        if (element instanceof MultiplicityElement) {
            MultiplicityElement mult = (MultiplicityElement)element;
            if (mult.getLowerValue() != null) {
                this.getText((EObject)mult.getLowerValue());
            }
            if (mult.getUpperValue() != null) {
                this.getText((EObject)mult.getUpperValue());
            }
        }
        return this.delegate.getText((Object)element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    private void forwardChange(Notification notification) {
        ViewerNotification vnot;
        if (notification instanceof ViewerNotification && (vnot = (ViewerNotification)notification).isLabelUpdate() && !this.listeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, vnot.getElement());
            this.listeners.forEach(l -> {
                try {
                    l.labelProviderChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in label provider listener", (Throwable)e);
                }
            });
        }
    }
}

