/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.stmt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.CodeBlock;

public class ConditionalStatement
extends Statement {
    private final List<Branch> branches = new ArrayList<Branch>();
    private Branch defaultBranch = null;

    public CodeBlock add(Expression condition) {
        Branch branch = new Branch(condition);
        this.branches.add(branch);
        return branch;
    }

    public CodeBlock defaultBlock() {
        if (this.defaultBranch == null) {
            this.defaultBranch = new Branch(null);
        }
        return this.defaultBranch;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        for (Branch branch : this.branches) {
            if (branch.addDependencies(deps)) continue;
            return false;
        }
        return this.defaultBranch == null ? true : this.defaultBranch.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        boolean first = true;
        for (Branch branch : this.branches) {
            if (branch.getLast() instanceof ConditionalStatement) {
                branch.setForceBraces();
            }
            if (first) {
                first = false;
            } else if (!fmt.write("else ")) {
                return false;
            }
            if (fmt.write("if") && fmt.write('(') && fmt.space() && branch.condition.write(fmt) && fmt.space() && fmt.write(')') && fmt.newline() && branch.write(fmt)) continue;
            return false;
        }
        if (this.defaultBranch == null) {
            return true;
        }
        return fmt.write("else") && fmt.newline() && this.defaultBranch.write(fmt);
    }

    private static class Branch
    extends CodeBlock {
        public final Expression condition;

        public Branch(Expression condition) {
            super(new Statement[0]);
            this.condition = condition;
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return (this.condition == null || this.condition.addDependencies(deps)) && super.addDependencies(deps);
        }
    }
}

