/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.cdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.IEObjectLocator;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.papyrusrt.xtumlrt.util.NamesUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;

public class UMLEObjectLocator
implements IEObjectLocator {
    public static final String LANGUAGE = "C++";
    private ResourceSet rset;
    private Map<String, ResourceSet> modelSetMap = new HashMap<String, ResourceSet>();

    private Package getRoot(String uri) {
        Package result = null;
        URI resourceUri = URI.createURI((String)uri);
        ResourceSet resourceSet = this.rset;
        if (this.modelSetMap.containsKey(uri)) {
            resourceSet = this.modelSetMap.get(uri);
        }
        if ("uml".equals(resourceUri.fileExtension())) {
            Resource r = resourceSet.getResource(resourceUri, true);
            result = (Package)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        return result;
    }

    public EObject getEObject(UserEditableRegion.Label label) {
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        qualifiedNames.addAll(Arrays.asList(label.getQualifiedName().split("::")));
        Package nextPackage = this.getRoot(label.getUri());
        if (nextPackage == null) {
            return null;
        }
        Class capsuleOrClass = null;
        qualifiedNames.remove(0);
        while (!qualifiedNames.isEmpty()) {
            String qname = (String)qualifiedNames.remove(0);
            Package pkg = nextPackage.getNestedPackage(qname);
            if (pkg == null) {
                capsuleOrClass = (Class)nextPackage.getPackagedElement(qname, false, UMLPackage.Literals.CLASS, false);
                break;
            }
            nextPackage = pkg;
        }
        EObject result = null;
        if (capsuleOrClass != null) {
            if (label.getType().equals(UMLPackage.Literals.OPERATION.getName().toLowerCase())) {
                Operation op = capsuleOrClass.getOwnedOperation(label.getDetails(), null, null);
                if (op != null) {
                    OpaqueBehavior method = null;
                    if (op.getMethods().isEmpty()) {
                        method = (OpaqueBehavior)capsuleOrClass.createOwnedBehavior(null, UMLPackage.Literals.OPAQUE_BEHAVIOR);
                        op.getMethods().add((Object)method);
                    } else {
                        method = (OpaqueBehavior)op.getMethods().get(0);
                    }
                    if (!method.getLanguages().contains((Object)LANGUAGE)) {
                        method.getLanguages().add((Object)LANGUAGE);
                    }
                    result = method;
                }
            } else {
                EObject smElement = this.getSMElement(capsuleOrClass, qualifiedNames);
                result = this.getUserCodeElement(smElement, label.getType(), label.getDetails());
            }
        }
        return result;
    }

    private EObject getUserCodeElement(EObject container, String type, String details) {
        UMLRTTrigger rtTrigger;
        UserEditableRegion.TriggerDetail tdetail;
        Trigger trigger;
        String[] tokens;
        Transition transition;
        Behavior result = null;
        if (type.equals(UMLPackage.Literals.TRANSITION.getName().toLowerCase())) {
            Transition t = this.getTransition(container, details);
            if (t != null) {
                result = t.getEffect();
            }
        } else if (type.equals(UMLPackage.Literals.STATE__ENTRY.getName())) {
            if (container instanceof State) {
                State s = (State)container;
                result = s.getEntry();
            }
        } else if (type.equals(UMLPackage.Literals.STATE__EXIT.getName())) {
            if (container instanceof State) {
                State s = (State)container;
                result = s.getExit();
            }
        } else if (type.equals(UMLPackage.Literals.TRANSITION__GUARD.getName())) {
            Transition t = this.getTransition(container, details);
            if (t != null) {
                result = t.getGuard();
            }
        } else if (type.equals(UMLPackage.Literals.TRANSITION__TRIGGER.getName()) && (transition = this.getTransition(container, (tokens = details.split(">>"))[0])) != null && (trigger = this.findTrigger(transition, tdetail = new UserEditableRegion.TriggerDetail(tokens[1]))) != null && (rtTrigger = UMLRTTrigger.getInstance((Trigger)trigger)).getGuard() != null) {
            result = rtTrigger.getGuard().toUML();
        }
        return result;
    }

    private EObject getSMElement(Class capsuleOrClass, List<String> qnameRelativeToSM) {
        Region r;
        StateMachine sm = (StateMachine)capsuleOrClass.getOwnedBehaviors().get(0);
        Region nextRegion = r = (Region)sm.getRegions().get(0);
        StateMachine result = sm;
        while (!qnameRelativeToSM.isEmpty()) {
            Vertex v = nextRegion.getSubvertex(qnameRelativeToSM.remove(0));
            if (v == null) {
                CodeGenPlugin.debug((String)"No matching element found.");
                break;
            }
            if (!((State)v).getRegions().isEmpty()) {
                nextRegion = (Region)((State)v).getRegions().get(0);
            }
            result = v;
        }
        if (!qnameRelativeToSM.isEmpty()) {
            CodeGenPlugin.debug((String)"No matching element found");
            result = null;
        }
        return result;
    }

    private Transition getTransition(EObject container, String transitionDetails) {
        Transition result = null;
        Region region = null;
        region = container instanceof StateMachine ? (Region)((StateMachine)container).getRegions().get(0) : (Region)((State)container).getRegions().get(0);
        if (region != null) {
            UserEditableRegion.TransitionDetails details = new UserEditableRegion.TransitionDetails(transitionDetails);
            for (Transition t : region.getTransitions()) {
                if (!UMLEObjectLocator.getSMQualifiedName((EObject)t.getSource()).equals(details.getSourceQname()) || !UMLEObjectLocator.getSMQualifiedName((EObject)t.getTarget()).equals(details.getTargetQname())) continue;
                if (details.getTriggerDetails().isEmpty()) {
                    result = t;
                    break;
                }
                if (details.getTriggerDetails().size() != t.getTriggers().size()) continue;
                Trigger trigger = null;
                for (UserEditableRegion.TriggerDetail detail : details.getTriggerDetails()) {
                    trigger = this.findTrigger(t, detail);
                    if (trigger == null) break;
                }
                if (trigger == null) continue;
                result = t;
                break;
            }
        }
        return result;
    }

    private Trigger findTrigger(Transition transition, UserEditableRegion.TriggerDetail detail) {
        Trigger result = null;
        for (Trigger trigger : transition.getTriggers()) {
            Event event = trigger.getEvent();
            if (event == null || !(event instanceof CallEvent) && !(event instanceof AnyReceiveEvent)) continue;
            String signalName = "*";
            if (event instanceof CallEvent) {
                Operation message = ((CallEvent)event).getOperation();
                signalName = message.getName();
            }
            if (!detail.getSignal().equals(signalName) || !this.comparetriggerPorts((List<Port>)trigger.getPorts(), detail.getPorts())) continue;
            result = trigger;
            break;
        }
        return result;
    }

    private boolean comparetriggerPorts(List<Port> ports, List<String> expectedPorts) {
        ArrayList<String> actualPorts = new ArrayList<String>();
        for (Port p : ports) {
            actualPorts.add(p.getName());
        }
        actualPorts.retainAll(expectedPorts);
        return actualPorts.size() == expectedPorts.size();
    }

    public static String getSMQualifiedName(EObject eObject) {
        String result = "";
        EObject container = eObject;
        while (container != null && !(container instanceof StateMachine)) {
            if (container instanceof Vertex) {
                if (result.length() != 0) {
                    result = "::" + result;
                }
                result = String.valueOf(NamesUtil.getEffectiveName((EObject)container)) + result;
            }
            container = container.eContainer();
        }
        return result;
    }

    public UserEditableRegion.CommitResult saveSource(UserEditableRegion.Label label, String source) {
        Constraint guard;
        ValueSpecification value;
        EObject eo = this.getEObject(label);
        UserEditableRegion.CommitResult result = null;
        if (eo instanceof OpaqueBehavior) {
            result = this.saveOpaqueBehaviour(eo, (OpaqueBehavior)eo, source);
        } else if (eo instanceof Constraint && (value = (guard = (Constraint)eo).getSpecification()) instanceof OpaqueExpression) {
            result = this.saveOpaqueExpression(eo, (OpaqueExpression)value, source);
        }
        if (result == null) {
            result = new UserEditableRegion.CommitResult(eo, null, false);
        }
        return result;
    }

    private String trimSource(String source) {
        String pattern = "\\r *|\\n *|\\t";
        String replaceString = "";
        return source.trim().replaceAll(pattern, replaceString);
    }

    private UserEditableRegion.CommitResult saveOpaqueExpression(EObject context, final OpaqueExpression oe, final String source) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)oe);
        boolean updated = false;
        final int bodyIndex = oe.getLanguages().indexOf((Object)LANGUAGE);
        if (!oe.getBodies().isEmpty()) {
            String body = (String)oe.getBodies().get(0);
            if (!this.trimSource(source).equals(this.trimSource(body))) {
                updated = true;
            }
        } else {
            updated = true;
        }
        RecordingCommand command = null;
        if (updated) {
            if (domain != null) {
                command = new RecordingCommand(domain){

                    protected void doExecute() {
                        if (bodyIndex != -1) {
                            oe.getBodies().remove(bodyIndex);
                            oe.getBodies().add(bodyIndex, (Object)source);
                        } else {
                            oe.getLanguages().add((Object)UMLEObjectLocator.LANGUAGE);
                            oe.getBodies().add((Object)source);
                        }
                    }
                };
            } else if (bodyIndex != -1) {
                oe.getBodies().remove(bodyIndex);
                oe.getBodies().add(bodyIndex, (Object)source);
            } else {
                oe.getLanguages().add((Object)LANGUAGE);
                oe.getBodies().add((Object)source);
            }
        }
        return new UserEditableRegion.CommitResult(context, command, updated);
    }

    private UserEditableRegion.CommitResult saveOpaqueBehaviour(EObject context, final OpaqueBehavior ob, final String source) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)ob);
        boolean updated = false;
        final int bodyIndex = ob.getLanguages().indexOf((Object)LANGUAGE);
        if (!ob.getBodies().isEmpty()) {
            if (bodyIndex >= 0 && ob.getBodies().size() > bodyIndex) {
                String body = (String)ob.getBodies().get(bodyIndex);
                if (!this.trimSource(source).equals(this.trimSource(body))) {
                    updated = true;
                }
            }
        } else {
            updated = true;
        }
        RecordingCommand command = null;
        if (updated) {
            if (domain != null) {
                command = new RecordingCommand(domain){

                    protected void doExecute() {
                        if (bodyIndex != -1) {
                            ob.getBodies().remove(bodyIndex);
                            ob.getBodies().add(bodyIndex, (Object)source);
                        } else {
                            ob.getLanguages().add((Object)UMLEObjectLocator.LANGUAGE);
                            ob.getBodies().add((Object)source);
                        }
                    }
                };
            } else if (bodyIndex != -1) {
                ob.getBodies().remove(bodyIndex);
                ob.getBodies().add(bodyIndex, (Object)source);
            } else {
                ob.getLanguages().add((Object)LANGUAGE);
                ob.getBodies().add((Object)source);
            }
        }
        return new UserEditableRegion.CommitResult(context, command, updated);
    }

    public void initialize() {
        this.modelSetMap.clear();
        ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>();
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorReference editor = iEditorReferenceArray[n6];
                        IEditorPart part = editor.getEditor(false);
                        if (part instanceof PapyrusMultiDiagramEditor) {
                            editors.add(editor);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (IllegalStateException illegalStateException) {}
        for (IEditorReference ref : editors) {
            PapyrusMultiDiagramEditor editor = (PapyrusMultiDiagramEditor)ref.getEditor(false);
            ServicesRegistry reg = editor.getServicesRegistry();
            try {
                ModelSet modelSet = (ModelSet)reg.getService(ModelSet.class);
                UmlModel model = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                this.modelSetMap.put(model.getResourceURI().toString(), model.getResource().getResourceSet());
            }
            catch (ServiceException serviceException) {}
        }
        this.rset = new ResourceSetImpl();
    }
}

