/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;

public class OperationAsMessageInOutEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        boolean approve = false;
        if (request instanceof CreateElementRequest) {
            EObject container = ((CreateElementRequest)request).getContainer();
            if (container instanceof Operation) {
                approve = ElementTypeUtils.isTypeCompatible(((CreateElementRequest)request).getElementType(), (IElementType)UMLElementTypes.PARAMETER);
            } else if (container instanceof Interface) {
                approve = true;
            }
            IElementType messageSetType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTMessageSet");
            if (messageSetType instanceof ISpecializationType) {
                if (((ISpecializationType)messageSetType).getMatcher().matches(container)) {
                    approve = true;
                } else if (RTMessageKind.IN_OUT == MessageSetUtils.getMessageKind(container)) {
                    approve = true;
                }
            }
        } else {
            approve = super.approveRequest(request);
        }
        return approve;
    }

    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        EObject container = request.getContainer();
        if (container instanceof Operation && ElementTypeUtils.isTypeCompatible(request.getElementType(), (IElementType)UMLElementTypes.PARAMETER)) {
            command = null;
        } else if (container instanceof Interface) {
            command = null;
        }
        IElementType messageSetType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTMessageSet");
        if (messageSetType instanceof ISpecializationType) {
            if (((ISpecializationType)messageSetType).getMatcher().matches(container)) {
                command = null;
            } else if (RTMessageKind.IN_OUT == MessageSetUtils.getMessageKind(container)) {
                command = super.getBeforeCreateCommand(request);
            }
        }
        return command;
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        final Operation operationAsMessageIn = (Operation)request.getElementToConfigure();
        final String name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)"InOutProtocolMessage", (Collection)operationAsMessageIn.eContainer().eContents());
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                operationAsMessageIn.setName(name);
                return CommandResult.newOKCommandResult((Object)operationAsMessageIn);
            }
        };
    }
}

