/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.properties.ui.creation.CreateInDialog;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public abstract class AbstractElementTypeBasedValueFactory
extends UMLPropertyEditorFactory {
    private Object context;
    private IElementType elementType;

    public AbstractElementTypeBasedValueFactory(EReference eReference) {
        super(eReference);
    }

    public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
        return objectsToValidate;
    }

    protected EObject createObjectInDifferentContainer(Control widget) {
        this.elementType = this.chooseElementType(widget);
        if (this.elementType == null) {
            return null;
        }
        EObject container = this.chooseNewContainer(widget);
        if (container == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)container);
        if (service == null) {
            return null;
        }
        ICommand editCommand = service.getEditCommand((IEditCommandRequest)new CreateElementRequest(container, this.elementType));
        if (editCommand != null && editCommand.canExecute()) {
            try {
                CommandResult result;
                IStatus status = editCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (status != null && status.isOK() && (result = editCommand.getCommandResult()).getReturnValue() instanceof EObject) {
                    return (EObject)result.getReturnValue();
                }
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    protected EObject simpleCreateObject(Control widget) {
        this.elementType = this.chooseElementType(widget);
        if (this.elementType == null) {
            return null;
        }
        EObject container = this.chooseNewContainer(widget);
        if (container == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)container);
        if (service == null) {
            return null;
        }
        ICommand editCommand = service.getEditCommand((IEditCommandRequest)new CreateElementRequest(container, this.elementType));
        if (editCommand != null && editCommand.canExecute()) {
            try {
                CommandResult result;
                IStatus status = editCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (status != null && status.isOK() && (result = editCommand.getCommandResult()).getReturnValue() instanceof EObject) {
                    return (EObject)result.getReturnValue();
                }
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    protected EObject chooseNewContainer(Control widget) {
        Package result = null;
        if (this.context instanceof Element) {
            result = ((Element)this.context).getNearestPackage();
        }
        if (result == null) {
            EObject virtualElement = this.getVirtualElementToCreate();
            CreateInDialog dialog = new CreateInDialog(widget.getShell(), (Object)virtualElement);
            dialog.setProviders(this.containerContentProvider, (IStaticContentProvider)this.referenceContentProvider, this.containerLabelProvider, this.referenceLabelProvider);
            dialog.setTitle(this.getCreationDialogTitle());
            if (dialog.open() == 0) {
                result = dialog.getContainer();
            }
        }
        return result;
    }

    protected abstract EObject getVirtualElementToCreate();

    protected abstract IElementType chooseElementType(Control var1);

    public String getCreationDialogTitle() {
        String typeName = this.elementType == null ? "Element" : this.elementType.getDisplayName();
        return NLS.bind((String)"Create a New {0}", (Object)typeName);
    }

    protected Object doCreateObject(Control widget, Object context) {
        Object result;
        this.context = context;
        try {
            result = super.doCreateObject(widget, context);
        }
        finally {
            this.context = null;
            this.elementType = null;
        }
        return result;
    }
}

