/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MultipleAdapter;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.internal.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.internal.ICodeSnippetPage;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.ChoicePointTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.ICodeSnippetTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.OperationTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.StateEntryTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.StateExitTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TransitionEffectTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TransitionGuardTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TriggerGuardTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.descriptors.CodeSnippetTabDescriptor;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.descriptors.ICodeSnippetTabDescriptor;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.utils.CodeSnippetTabUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.uml2.uml.Pseudostate;

public class CodeSnippetPage
extends Page
implements ICodeSnippetPage {
    private static IStructuredSelection currentWorkbenchSelection = StructuredSelection.EMPTY;
    private static EObject currentSelectedEObject;
    private Composite pageControl;
    private Control defaultPage;
    private List<ICodeSnippetTabDescriptor> tabDescriptors = new ArrayList<ICodeSnippetTabDescriptor>();
    private Map<IElementType, Control> elementTypeToPage = new HashMap<IElementType, Control>();
    private Multimap<CTabFolder, ICodeSnippetTab> tabFolderToTabs = ArrayListMultimap.create();
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private PageBook pageBook;
    private SelectionAdapter adapter = new SelectionAdapter();
    private boolean ignoreNotification = false;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String partId = part.getSite().getId();
        if ("org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet".equals(partId)) {
            this.fireSelectionChange();
            return;
        }
        if (selection instanceof IStructuredSelection) {
            if (currentSelectedEObject != null) {
                this.ignoreNotification = true;
                currentSelectedEObject.eAdapters().remove((Object)this.adapter);
                this.ignoreNotification = false;
            }
            if (!"org.eclipse.ui.views.PropertySheet".equals(partId)) {
                currentWorkbenchSelection = new StructuredSelection(((IStructuredSelection)selection).toList());
            }
            if (selection.isEmpty()) {
                currentSelectedEObject = null;
            } else {
                EObject eo = EMFHelper.getEObject((Object)((IStructuredSelection)selection).getFirstElement());
                if (eo != null && !eo.equals(currentSelectedEObject)) {
                    currentSelectedEObject = eo;
                }
            }
            CTabFolder tabFolder = this.getPageFolder(currentSelectedEObject);
            if (tabFolder != null) {
                for (ICodeSnippetTabDescriptor tabDescriptor : this.tabDescriptors) {
                    if (tabDescriptor.shouldShowThisTab(currentSelectedEObject)) {
                        ICodeSnippetTab tab = this.getTabContent(tabFolder, tabDescriptor);
                        if (tab == null) continue;
                        tab.setInput(currentSelectedEObject);
                        continue;
                    }
                    this.removeTabContent(tabFolder, tabDescriptor);
                }
            }
            if (tabFolder != null && tabFolder.getItemCount() > 0) {
                if (tabFolder.getSelection() == null) {
                    tabFolder.setSelection(0);
                }
                this.pageBook.showPage((Control)tabFolder);
                currentSelectedEObject.eAdapters().add((Object)this.adapter);
            } else {
                this.pageBook.showPage(this.defaultPage);
                currentSelectedEObject = null;
            }
        }
    }

    private ICodeSnippetTab getTabContent(CTabFolder tabComposite, ICodeSnippetTabDescriptor descriptor) {
        ICodeSnippetTab tab = this.tabFolderToTabs.get((Object)tabComposite).stream().filter(t -> descriptor.isTabInstance((ICodeSnippetTab)t)).findFirst().orElse(null);
        if (tab == null && (tab = descriptor.createTab()) != null) {
            tab.createControl(tabComposite);
            this.tabFolderToTabs.put((Object)tabComposite, (Object)tab);
        }
        return tab;
    }

    private void removeTabContent(CTabFolder tabComposite, ICodeSnippetTabDescriptor descriptor) {
        ICodeSnippetTab tab = this.tabFolderToTabs.get((Object)tabComposite).stream().filter(t -> descriptor.isTabInstance((ICodeSnippetTab)t)).findFirst().orElse(null);
        if (tab != null) {
            this.tabFolderToTabs.remove((Object)tabComposite, (Object)tab);
            tab.dispose();
        }
    }

    private void fireSelectionChange() {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (final ISelectionChangedListener l : this.listeners) {
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    l.selectionChanged(event);
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        }
    }

    private CTabFolder getPageFolder(EObject context) {
        if (context == null) {
            return null;
        }
        IElementType type = null;
        try {
            type = ElementTypeRegistry.getInstance().getElementType(context, TypeContext.getContext((EObject)context));
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        Control folder = this.elementTypeToPage.get(type);
        if (folder != null) {
            return (CTabFolder)folder;
        }
        CTabFolder tabFolder = new CTabFolder((Composite)this.pageBook, 1024);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.elementTypeToPage.put(type, (Control)tabFolder);
        return tabFolder;
    }

    public void createControl(Composite parent) {
        this.tabDescriptors.add(new CodeSnippetTabDescriptor(StateEntryTab.class, e -> CodeSnippetTabUtil.getState(e) != null));
        this.tabDescriptors.add(new CodeSnippetTabDescriptor(StateExitTab.class, e -> CodeSnippetTabUtil.getState(e) != null));
        this.tabDescriptors.add(new CodeSnippetTabDescriptor(TransitionEffectTab.class, e -> CodeSnippetTabUtil.getTransition(e) != null));
        this.tabDescriptors.add(new CodeSnippetTabDescriptor(TransitionGuardTab.class, e -> CodeSnippetTabUtil.getTransition(e) != null));
        this.tabDescriptors.add(new CodeSnippetTabDescriptor(TriggerGuardTab.class, e -> CodeSnippetTabUtil.getTrigger(e) != null));
        this.tabDescriptors.add(new CodeSnippetTabDescriptor(ChoicePointTab.class, e -> e instanceof Pseudostate && ElementTypeUtils.matches((EObject)e, (String)"org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Choice") != false));
        this.tabDescriptors.add(new CodeSnippetTabDescriptor(OperationTab.class, e -> CodeSnippetTabUtil.getOperation(e) != null));
        this.pageControl = new Composite(parent, 0);
        this.pageControl.setLayout((Layout)new FillLayout());
        this.pageBook = new PageBook(this.pageControl, 0);
        this.createDefaultPage();
    }

    private void createDefaultPage() {
        Composite page = new Composite((Composite)this.pageBook, 0);
        page.setLayoutData((Object)new GridData(1808));
        page.setLayout((Layout)new GridLayout());
        CLabel label = new CLabel(page, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText("Code snippet view is not available for the current selection.");
        this.defaultPage = page;
    }

    public Control getControl() {
        return this.pageControl;
    }

    public void setFocus() {
        this.pageControl.setFocus();
    }

    public void dispose() {
        if (this.adapter != null) {
            this.adapter.dispose();
        }
        this.tabDescriptors.clear();
        this.tabFolderToTabs.values().stream().filter(Objects::nonNull).forEach(ICodeSnippetTab::dispose);
        super.dispose();
    }

    public ISelection getSelection() {
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (currentWorkbenchSelection != null && !currentWorkbenchSelection.isEmpty()) {
            EObject eo = EMFHelper.getEObject((Object)currentWorkbenchSelection.getFirstElement());
            if (eo == null || eo.eIsProxy() || eo.eResource() == null) {
                currentWorkbenchSelection = null;
            } else {
                selection = currentWorkbenchSelection;
            }
        }
        return selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    private class SelectionAdapter
    extends MultipleAdapter {
        SelectionAdapter() {
            super(1);
        }

        public void notifyChanged(Notification notification) {
            if (!CodeSnippetPage.this.ignoreNotification && notification.getEventType() == 8) {
                currentSelectedEObject = null;
                currentWorkbenchSelection = null;
                CodeSnippetPage.this.fireSelectionChange();
            }
        }
    }
}

