/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.NoDefautLanguage;
import org.eclipse.papyrusrt.umlrt.core.utils.ModelUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.UMLRTExtModelElementFactory;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.editors.ILanguageEditor;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.editors.LanguageEditorRegistry;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.internal.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.ICodeSnippetTab;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;

public abstract class AbstractCodeSnippetTab
implements ICodeSnippetTab,
IChangeListener {
    private static Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private static Font italic = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
    protected EObject input;
    protected Composite tabComposite;
    protected CTabItem tabItem;
    protected CLabel label;
    protected CLabel languageLabel;
    protected boolean controlCreated = false;
    protected String defaultLanguage = "";
    protected ModelElement meForFeatureObservable;
    protected ModelElement meForSpecificationObservable;
    protected ExpressionList expressionObservableList;
    protected ModelElement meForExpressionObservable;
    protected String selectedLanguage;
    protected ILanguageEditor languageEditor;
    protected UMLRTExtModelElementFactory rtModelFactory = new UMLRTExtModelElementFactory();
    protected boolean defaultSelection = false;
    private ILabelProvider labelProvider;
    private boolean ignoreChanges = false;

    protected void doSetInput(EObject input) {
        this.input = input;
    }

    @Override
    public void setInput(EObject input) {
        this.defaultSelection = false;
        this.doSetInput(input);
        if (this.input == null) {
            throw new IllegalArgumentException();
        }
        this.handleNewInput();
    }

    protected void handleNewInput() {
        this.selectedLanguage = this.defaultLanguage = ModelUtils.getDefaultLanguage((Element)((Element)this.input)).getName();
        this.updateFeatureObservable();
        this.updateExpressionObservableList();
        this.updateLabel();
        this.updateLanguageEditor();
        this.refresh();
        if (this.defaultSelection) {
            CTabFolder folder = this.tabItem.getParent();
            folder.setSelection(this.tabItem);
        }
    }

    protected void updateLanguageEditor() {
        if (this.languageEditor != null) {
            this.languageEditor.dispose();
        }
        this.languageEditor = LanguageEditorRegistry.getInstance().getNewLanguageEditorInstance(this.selectedLanguage);
        this.languageEditor.createControl(this.tabComposite);
        this.languageEditor.addValueChangeListener((IValueChangeListener)new IValueChangeListener<ExpressionList.Expression>(){

            public void handleValueChange(ValueChangeEvent<? extends ExpressionList.Expression> event) {
                AbstractCodeSnippetTab.this.commit();
            }
        });
        this.tabComposite.layout();
    }

    private void disposeFeatureObservable() {
        if (this.meForFeatureObservable != null) {
            this.meForFeatureObservable.dispose();
            this.meForFeatureObservable = null;
        }
    }

    private void disposeExpressionObservableList() {
        if (this.meForSpecificationObservable != null) {
            this.meForSpecificationObservable.dispose();
            this.meForSpecificationObservable = null;
        }
        if (this.expressionObservableList != null) {
            this.expressionObservableList.dispose();
            this.expressionObservableList = null;
        }
        if (this.meForExpressionObservable != null) {
            this.meForExpressionObservable.dispose();
            this.meForExpressionObservable = null;
        }
    }

    protected void updateFeatureObservable() {
        this.disposeFeatureObservable();
        IObservable featureObservable = this.getFeatureObservable();
        if (featureObservable != null) {
            featureObservable.addChangeListener((IChangeListener)this);
        }
    }

    protected void updateExpressionObservableList() {
        this.disposeExpressionObservableList();
        IObservable specificationObservable = this.getSpecificationObservable();
        if (specificationObservable != null) {
            specificationObservable.addChangeListener((IChangeListener)this);
        }
        this.expressionObservableList = this.getExpressionObservableList();
        if (this.expressionObservableList != null) {
            this.expressionObservableList.addChangeListener((IChangeListener)this);
        }
    }

    @Override
    public CTabItem createControl(CTabFolder parent) {
        this.controlCreated = true;
        this.tabComposite = new Composite((Composite)parent, 0);
        this.tabComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabComposite.setLayout((Layout)new GridLayout());
        Composite labelComposite = new Composite(this.tabComposite, 0);
        GridData data = new GridData(16384, 128, false, false);
        labelComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        labelComposite.setLayout((Layout)layout);
        this.label = new CLabel(labelComposite, 0);
        this.languageLabel = new CLabel(labelComposite, 0);
        this.languageEditor = LanguageEditorRegistry.getInstance().getNewLanguageEditorInstance(NoDefautLanguage.INSTANCE.getName());
        this.languageEditor.createControl(this.tabComposite);
        this.tabItem = new CTabItem(parent, 0);
        this.tabItem.setControl((Control)this.tabComposite);
        return this.tabItem;
    }

    public void handleChange(ChangeEvent event) {
        if (!this.ignoreChanges && this.tabItem != null && !this.tabItem.isDisposed()) {
            IObservable observable = event.getObservable();
            if (!(observable instanceof ExpressionList.Expression) && !(observable instanceof ExpressionList)) {
                this.updateExpressionObservableList();
            }
            this.refresh();
        }
    }

    protected void updateLabel() {
        if (this.controlCreated && this.input != null) {
            this.label.setImage(this.getLabelProvider().getImage((Object)this.input));
            this.label.setText(this.getLabelProvider().getText((Object)this.input));
            this.languageLabel.setText("(" + this.selectedLanguage + ")");
            this.tabComposite.layout();
        }
    }

    protected ILabelProvider getLabelProvider() {
        try {
            this.labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.input)).getLabelProvider();
        }
        catch (ServiceException e) {
            Activator.getDefault().error(e.getMessage(), (Exception)((Object)e));
            this.labelProvider = new UMLLabelProvider();
        }
        return this.labelProvider;
    }

    @Override
    public boolean controlCreated() {
        return this.controlCreated;
    }

    @Override
    public void dispose() {
        this.disposeFeatureObservable();
        this.disposeExpressionObservableList();
        if (this.tabItem != null && !this.tabItem.isDisposed()) {
            this.tabItem.dispose();
        }
        if (this.tabComposite != null && !this.tabComposite.isDisposed()) {
            this.tabComposite.dispose();
        }
        this.tabComposite = null;
        this.controlCreated = false;
        this.input = null;
    }

    protected void refresh() {
        int index;
        this.tabItem.setText(this.getTitle());
        this.tabItem.setImage(this.getImage());
        this.tabItem.setFont(italic);
        final ExpressionList.Expression ex = new ExpressionList.Expression();
        ex.setLanguage(this.selectedLanguage);
        ex.setBody("");
        if (this.expressionObservableList != null && (index = this.expressionObservableList.indexOf((Object)ex)) != -1) {
            ex.setBody(((ExpressionList.Expression)this.expressionObservableList.get(index)).getBody());
            this.tabItem.setFont(bold);
        }
        SafeRunnable runnable = new SafeRunnable(){

            public void run() throws Exception {
                AbstractCodeSnippetTab.this.languageEditor.setValue(ex);
            }
        };
        SafeRunnable.run((ISafeRunnable)runnable);
    }

    protected void commit() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.input);
        AbstractTransactionalCommand cmd = null;
        final ExpressionList.Expression ex = (ExpressionList.Expression)this.languageEditor.getValue();
        String commandLabel = "Save " + this.getTitle() + " Code";
        if (this.expressionObservableList != null) {
            int index = this.expressionObservableList.indexOf((Object)ex);
            if (index != -1) {
                ExpressionList.Expression expression = (ExpressionList.Expression)this.expressionObservableList.get(index);
                if (ex.getBody().equals(expression.getBody())) {
                    return;
                }
                expression.setBody(ex.getBody());
            } else {
                this.expressionObservableList.add((Object)ex);
            }
            cmd = new AbstractTransactionalCommand(domain, commandLabel, Collections.EMPTY_LIST){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    AbstractCodeSnippetTab.this.expressionObservableList.commit(null);
                    return CommandResult.newOKCommandResult();
                }
            };
        } else if (!UML2Util.isEmpty((String)ex.getBody())) {
            cmd = new AbstractTransactionalCommand(domain, commandLabel, Collections.EMPTY_LIST){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    AbstractCodeSnippetTab.this.saveInitialExpression(ex);
                    return CommandResult.newOKCommandResult();
                }
            };
        }
        if (cmd != null && cmd.canExecute()) {
            this.ignoreChanges = true;
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
            this.ignoreChanges = false;
            this.setInput(this.input);
        }
    }

    protected ExpressionList getExpressionList(EObject element) {
        if (element instanceof OpaqueBehavior || element instanceof OpaqueExpression) {
            if (this.meForExpressionObservable == null) {
                this.meForExpressionObservable = this.rtModelFactory.createFromSource((Object)element, null);
            }
            IObservableList languages = (IObservableList)this.meForExpressionObservable.getObservable("language");
            IObservableList bodies = (IObservableList)this.meForExpressionObservable.getObservable("body");
            ExpressionList el = new ExpressionList(languages, bodies, (IChangeListener)this);
            return el;
        }
        return null;
    }

    protected IObservable getSpecificationObservable(EObject element) {
        IObservable result = null;
        if (element != null) {
            if (this.meForSpecificationObservable == null) {
                this.meForSpecificationObservable = this.rtModelFactory.createFromSource((Object)element, null);
            }
            result = this.meForSpecificationObservable.getObservable("specification");
        }
        return result;
    }

    protected String getTitle() {
        return "";
    }

    protected Image getImage() {
        return null;
    }

    protected abstract IObservable getFeatureObservable();

    protected abstract IObservable getSpecificationObservable();

    protected abstract ExpressionList getExpressionObservableList();

    protected abstract void saveInitialExpression(ExpressionList.Expression var1);
}

