/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.utils.ModelUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MultipleAdapter;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.ChoicePointTransitionGuardTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.ICodeSnippetTab;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTGuard;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class ChoicePointTab
implements ICodeSnippetTab {
    protected Pseudostate choice;
    protected Map<CTabItem, ICodeSnippetTab> tabs = new HashMap<CTabItem, ICodeSnippetTab>();
    protected Map<ICodeSnippetTab, Transition> tabsToTransition = new HashMap<ICodeSnippetTab, Transition>();
    protected CTabItem defaultTabItem;
    protected Composite defaultTabPage;
    protected CTabFolder tabFolder;
    protected Map<Pseudostate, Transition> selectionMap = new HashMap<Pseudostate, Transition>();
    private SelectionListener selectionListener;
    private ChoiceAdapter choiceListener = new ChoiceAdapter();
    private boolean controlCreated = false;

    public ChoicePointTab() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                ICodeSnippetTab tab = ChoicePointTab.this.tabs.get(item);
                Transition selectedTransition = ChoicePointTab.this.tabsToTransition.get(tab);
                ChoicePointTab.this.selectionMap.put(ChoicePointTab.this.choice, selectedTransition);
                ChoicePointTab.this.choice.eAdapters().add((Object)ChoicePointTab.this.choiceListener);
            }
        };
    }

    @Override
    public CTabItem createControl(CTabFolder parent) {
        this.controlCreated = true;
        this.tabFolder = parent;
        this.defaultTabPage = new Composite((Composite)this.tabFolder, 0);
        this.defaultTabPage.setLayoutData((Object)new GridData());
        this.defaultTabPage.setLayout((Layout)new GridLayout());
        CLabel label = new CLabel(this.defaultTabPage, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText("No outgoing transitions for this choice point.");
        this.createDefaultTabItem();
        return this.defaultTabItem;
    }

    private void createDefaultTabItem() {
        if (this.defaultTabItem == null && this.tabFolder != null) {
            this.defaultTabItem = new CTabItem(this.tabFolder, 0);
            this.defaultTabItem.setControl((Control)this.defaultTabPage);
        }
    }

    @Override
    public void setInput(EObject input) {
        this.disposeTabs();
        this.choice = (Pseudostate)input;
        Transition selectedTransition = this.selectionMap.get(this.choice);
        CTabItem firstTabWithGuardSet = null;
        for (Transition t : this.choice.getOutgoings()) {
            ChoicePointTransitionGuardTab tab = new ChoicePointTransitionGuardTab(this.choice);
            CTabItem tabItem = tab.createControl(this.tabFolder);
            tab.setInput((EObject)t);
            this.tabs.put(tabItem, tab);
            this.tabsToTransition.put(tab, t);
            if (this.tabFolder.getSelection() == null && firstTabWithGuardSet == null) {
                IDefaultLanguage defaultLanguage = ModelUtils.getDefaultLanguage((Element)this.choice);
                UMLRTTransition rtTransition = UMLRTFactory.createTransition((Transition)t);
                UMLRTGuard guard = rtTransition.getGuard();
                if (guard != null && defaultLanguage != null && guard.getBodies().get(defaultLanguage.getName()) != null) {
                    firstTabWithGuardSet = tabItem;
                }
            }
            if (!t.equals(selectedTransition)) continue;
            this.tabFolder.setSelection(tabItem);
        }
        if (this.tabs.isEmpty()) {
            this.createDefaultTabItem();
        } else {
            if (this.tabFolder.getSelection() == null) {
                if (firstTabWithGuardSet != null) {
                    this.tabFolder.setSelection(firstTabWithGuardSet);
                } else {
                    this.tabFolder.setSelection(0);
                }
            }
            this.tabFolder.addSelectionListener(this.selectionListener);
        }
        this.tabFolder.layout();
    }

    @Override
    public boolean controlCreated() {
        return this.controlCreated;
    }

    @Override
    public void dispose() {
        this.choiceListener.dispose();
        this.disposeTabs();
    }

    private void disposeTabs() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            this.tabFolder.removeSelectionListener(this.selectionListener);
        }
        this.tabs.values().forEach(ICodeSnippetTab::dispose);
        this.tabs.clear();
        if (this.defaultTabItem != null) {
            this.defaultTabItem.dispose();
            this.defaultTabItem = null;
        }
        this.tabsToTransition.clear();
    }

    private class ChoiceAdapter
    extends MultipleAdapter {
        ChoiceAdapter() {
        }

        public void notifyChanged(Notification notification) {
            int eventType = notification.getEventType();
            Object notifier = notification.getNotifier();
            Object feature = notification.getFeature();
            if (eventType == 8) {
                ChoicePointTab.this.selectionMap.remove(notifier);
            } else if (eventType == 1 && UMLPackage.Literals.VERTEX__CONTAINER.equals(feature) && notification.getNewValue() == null) {
                ChoicePointTab.this.selectionMap.remove(notifier);
            }
        }
    }
}

