/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ElementRTOperations
extends UMLUtil {
    protected ElementRTOperations() {
    }

    public static <T extends InternalUMLRTElement & Element> boolean rtApplyStereotype(T element, T prototype) {
        boolean result = false;
        for (EObject next : ((Element)prototype).getStereotypeApplications()) {
            EClass stereotype = next.eClass();
            if (stereotype == UMLRealTimePackage.Literals.RT_REDEFINED_ELEMENT || stereotype.getEPackage() != UMLRealTimePackage.eINSTANCE && stereotype.getEPackage() != UMLRTStateMachinesPackage.eINSTANCE) continue;
            ElementRTOperations.applyStereotype((Element)element, (EClass)stereotype);
            result = true;
        }
        return result;
    }

    public static <T extends InternalUMLRTElement & Element> void destroyAll(T element, EList<? extends Element> contents) {
        if (!contents.isEmpty()) {
            new ArrayList<Element>((Collection<? extends Element>)contents).forEach((Consumer<? extends Element>)((Consumer<Element>)ElementRTOperations::delete));
        }
    }

    public static void delete(EObject object) {
        if (object.eContents().isEmpty()) {
            if (object instanceof Element) {
                ((Element)object).getStereotypeApplications().forEach(ElementRTOperations::delete);
            }
            ElementRTOperations.removeReferences((EObject)object, (EObject)object);
        } else {
            TreeIterator allContents = ElementRTOperations.getAllContents((EObject)object, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                EObject next = (EObject)allContents.next();
                if (next instanceof Element) {
                    ((Element)next).getStereotypeApplications().forEach(ElementRTOperations::delete);
                }
                ElementRTOperations.removeReferences((EObject)next, (EObject)object);
            }
        }
        EcoreUtil.remove((EObject)object);
    }

    public static <T extends InternalUMLRTElement & Element> String toString(T element, String baseToString) {
        String result = baseToString;
        UMLRTInheritanceKind inheritance = UMLRTInheritanceKind.of(element);
        if (inheritance != UMLRTInheritanceKind.NONE) {
            String inhMarker;
            StringBuilder buf = new StringBuilder(baseToString.length() + 32);
            int at = baseToString.indexOf(64);
            int paren = baseToString.indexOf(40, at + 1);
            Object redefined = element.rtGetRedefinedElement();
            String redef = redefined instanceof NamedElement ? ElementRTOperations.getQualifiedName((NamedElement)((NamedElement)redefined), (String)"::") : (redefined != null ? redefined.eClass().getName() : null);
            switch (inheritance) {
                case INHERITED: {
                    inhMarker = "[I]";
                    break;
                }
                case REDEFINED: {
                    inhMarker = "[R]";
                    break;
                }
                case EXCLUDED: {
                    inhMarker = "[X]";
                    break;
                }
                default: {
                    inhMarker = "[L]";
                }
            }
            if (at < 0) {
                buf.append(baseToString);
                buf.append(inhMarker);
                if (redefined != null) {
                    buf.append(" {redefines ").append(redef).append("}");
                }
            } else {
                buf.append(baseToString.substring(0, at));
                buf.append(inhMarker);
                if (paren < 0) {
                    buf.append(baseToString.substring(at));
                } else {
                    buf.append(baseToString.substring(at, paren));
                }
                if (redefined != null) {
                    buf.append("{redefines ").append(redef).append("} ");
                }
                if (paren >= 0) {
                    buf.append(baseToString.substring(paren));
                }
            }
            result = buf.toString();
        }
        return result;
    }
}

