/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Macro;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class MacroExpansion
extends Expression {
    private final Macro macro;
    private List<Expression> arguments = null;

    public MacroExpansion(Macro macro) {
        this.macro = macro;
    }

    public void addArgument(Expression arg) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Expression>();
        }
        this.arguments.add(arg);
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        for (Expression expr : this.arguments) {
            if (expr.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Type createType() {
        Expression replacement = this.macro.getReplacement();
        return replacement == null ? null : replacement.getType();
    }

    @Override
    public Expression.Precedence getPrecedence() {
        Expression replacement = this.macro.getReplacement();
        return replacement == null ? Expression.Precedence.Default : replacement.getPrecedence();
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!fmt.write(this.macro.getName())) {
            return false;
        }
        if (this.arguments == null) {
            return !this.macro.expectsArguments() || fmt.write("()");
        }
        if (!fmt.write('(')) {
            return false;
        }
        boolean first = true;
        for (Expression arg : this.arguments) {
            if (first) {
                first = false;
            } else if (!fmt.write(',')) {
                return false;
            }
            if (fmt.space() && arg.write(fmt)) continue;
            return false;
        }
        return fmt.spaceUnless('(') && fmt.write(')');
    }
}

