/*****************************************************************************
 * Copyright (c) 2014, 2017 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *  Young-Soo Roh - bug 510024
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.IUMLRTElementTypes;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;

/**
 * State machine utils
 */
public class StateMachineUtils {

	/** View name for the RT state machine diagram */
	public static final String UMLRT_STATE_MACHINE_DIAGRAM = "UML-RT State Machine Diagram";

	/** View id for the RT state machine diagram */
	public static final String UMLRT_STATE_MACHINE_DIAGRAM_ID = "UMLRTStateMachine";

	public static boolean isRTStateMachine(StateMachine stateMachine) {
		return ElementTypeUtils.matches(stateMachine, IUMLRTElementTypes.RT_STATE_MACHINE_ID);
	}

	/**
	 * Re-target move request to the first region if copied elements are vertices.
	 * 
	 * @param request
	 *            Move request
	 */
	public static void retargetToRegion(MoveRequest request) {
		// Retarget move request to first region
		EObject target = request.getTargetContainer();
		if (target instanceof StateMachine && !((StateMachine) target).getRegions().isEmpty()) {
			request.setTargetContainer(((StateMachine) target).getRegions().get(0));
		} else if (target instanceof State && !((State) target).getRegions().isEmpty()) {
			request.setTargetContainer(((State) target).getRegions().get(0));
		}
	}

}
