/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.AutoDiagramChangeMarker;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.IAutoDiagramChangeMarker;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.ProtocolChange;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.ProtocolMessageChange;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;

public final class UMLRTCompareUtil {
    public static final Predicate<Diff> PROTOCOL_RENAME_ATTRIBUTE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return UMLRTCompareUtil.isProtocolRenameAttributeChange(input);
        }
    };
    public static final Predicate<Diff> PROTOCOL_MESSAGE_RENAME_ATTRIBUTE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return UMLRTCompareUtil.isProtocolMessageRenameAttributeChange(input);
        }
    };
    public static final Predicate<Diff> NAME_ATTRIBUTE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return UMLRTCompareUtil.isNameAttributeChange(input);
        }
    };
    public static final Predicate<Diff> AUTO_DIAGRAM_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return UMLRTCompareUtil.isAutoDiagramChange((EObject)input);
        }
    };
    public static final Predicate<Match> CAPSULE_DIAGRAM_MATCH = new Predicate<Match>(){

        public boolean apply(Match input) {
            if (input != null && UMLRTCompareUtil.getAnyMatchValue(input) instanceof Diagram) {
                Diagram diagram = (Diagram)UMLRTCompareUtil.getAnyMatchValue(input);
                return diagram.getElement() instanceof Classifier && CapsuleUtils.isCapsule((Classifier)((Classifier)diagram.getElement()));
            }
            return false;
        }
    };
    public static final Predicate<Diff> PROTOCOL_MESSAGE_REFERENCE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return UMLRTCompareUtil.isProtocolMessageReferenceChange(input);
        }
    };

    private UMLRTCompareUtil() {
    }

    public static boolean isAttributeChangeOfProtocol(Diff diff) {
        if (diff instanceof AttributeChange) {
            return ProtocolUtils.isProtocol((EObject)UMLRTCompareUtil.getChangedEObject(diff));
        }
        return false;
    }

    public static boolean isAttributeChangeOfProtocolMessage(Diff diff) {
        if (diff instanceof AttributeChange) {
            return RTMessageUtils.isRTMessage((EObject)UMLRTCompareUtil.getChangedEObject(diff));
        }
        return false;
    }

    public static boolean isNameAttributeChange(Diff diff) {
        if (diff instanceof AttributeChange) {
            AttributeChange attributeChange = (AttributeChange)diff;
            return UMLPackage.Literals.NAMED_ELEMENT__NAME.equals(attributeChange.getAttribute());
        }
        return false;
    }

    public static EObject getChangedEObject(Diff diff) {
        return MatchUtil.getContainer((Comparison)ComparisonUtil.getComparison((Diff)diff), (Diff)diff);
    }

    public static boolean isProtocolRenameAttributeChange(Diff diff) {
        return UMLRTCompareUtil.isAttributeChangeOfProtocol(diff) && NAME_ATTRIBUTE_CHANGE.apply((Object)diff) && DifferenceKind.CHANGE.equals((Object)diff.getKind());
    }

    public static boolean isProtocolMessageRenameAttributeChange(Diff diff) {
        return UMLRTCompareUtil.isAttributeChangeOfProtocolMessage(diff) && NAME_ATTRIBUTE_CHANGE.apply((Object)diff) && DifferenceKind.CHANGE.equals((Object)diff.getKind());
    }

    public static Optional<Diff> getProtocolRenameAttributeChange(ProtocolChange protocolChange) {
        if (DifferenceKind.CHANGE.equals((Object)protocolChange.getKind())) {
            return Iterables.tryFind((Iterable)protocolChange.getRefinedBy(), PROTOCOL_RENAME_ATTRIBUTE_CHANGE);
        }
        return Optional.absent();
    }

    public static Optional<Diff> getProtocolMessageRenameAttributeChange(ProtocolMessageChange protocolMessageChange) {
        if (DifferenceKind.CHANGE.equals((Object)protocolMessageChange.getKind())) {
            return Iterables.tryFind((Iterable)protocolMessageChange.getRefinedBy(), PROTOCOL_RENAME_ATTRIBUTE_CHANGE);
        }
        return Optional.absent();
    }

    public static boolean isProtocolMessageReferenceChange(Diff input) {
        if (!(input instanceof ReferenceChange)) {
            return false;
        }
        ReferenceChange referenceChange = (ReferenceChange)input;
        if (UMLPackage.Literals.INTERFACE__OWNED_OPERATION != referenceChange.getReference()) {
            return false;
        }
        return RTMessageUtils.isRTMessage((EObject)referenceChange.getValue());
    }

    public static Optional<Diff> getProtocolMessageReferenceChange(ProtocolMessageChange protocolMessageChange) {
        if (protocolMessageChange == null) {
            return Optional.absent();
        }
        return Iterables.tryFind((Iterable)protocolMessageChange.getRefinedBy(), PROTOCOL_MESSAGE_REFERENCE_CHANGE);
    }

    public static Operation getRTProtocolMessage(ProtocolMessageChange protocolMessageChange) {
        Optional<Diff> optional = UMLRTCompareUtil.getProtocolMessageReferenceChange(protocolMessageChange);
        if (optional.isPresent() && optional.get() instanceof ReferenceChange) {
            return (Operation)((ReferenceChange)optional.get()).getValue();
        }
        return null;
    }

    public static EObject getAnyMatchValue(Match match) {
        if (match.getLeft() != null) {
            return match.getLeft();
        }
        if (match.getRight() != null) {
            return match.getRight();
        }
        return match.getOrigin();
    }

    public static boolean isViewPersistedChildrenReference(EReference reference) {
        return NotationPackage.eINSTANCE.getView_PersistedChildren().equals(reference);
    }

    public static Object getChangedValue(Diff diff) {
        if (diff instanceof AttributeChange) {
            return ((AttributeChange)diff).getValue();
        }
        if (diff instanceof ReferenceChange) {
            return ((ReferenceChange)diff).getValue();
        }
        if (diff instanceof FeatureMapChange) {
            return ((FeatureMapChange)diff).getValue();
        }
        if (diff instanceof DiagramDiff) {
            return ((DiagramDiff)diff).getView();
        }
        if (diff instanceof UMLDiff) {
            return ((UMLDiff)diff).getDiscriminant();
        }
        return null;
    }

    public static void markAsAutoDiagramChange(Diff diff) {
        diff.eAdapters().add((Object)new AutoDiagramChangeMarker());
    }

    public static void markAsAutoDiagramChanges(Collection<Diff> diffs) {
        for (Diff diff : diffs) {
            UMLRTCompareUtil.markAsAutoDiagramChange(diff);
        }
    }

    public static boolean isAutoDiagramChange(EObject diff) {
        return EcoreUtil.getExistingAdapter((Notifier)diff, IAutoDiagramChangeMarker.class) != null;
    }
}

