/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.canonical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ISemanticChildrenStrategy;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.composite.custom.canonical.StructuredClassifierSemanticChildrenStrategy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnector;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class RTPortSemanticChildrenStrategy
extends StructuredClassifierSemanticChildrenStrategy {
    public Collection<? extends EObject> getCanonicalDependents(EObject semanticFromEditPart, View viewFromEditPart) {
        List<Class> result = super.getCanonicalDependents(semanticFromEditPart, viewFromEditPart);
        UMLRTCapsule capsule = EditPartInheritanceUtils.getContextCapsule(viewFromEditPart);
        if (capsule != null) {
            if (result == null) {
                result = Collections.singletonList(capsule.toUML());
            } else {
                ArrayList<Class> newResult = new ArrayList<Class>(result.size() + 1);
                newResult.add(capsule.toUML());
                newResult.addAll(result);
                result = newResult;
            }
        }
        return result;
    }

    public List<? extends EObject> getCanonicalSemanticConnections(EObject semanticFromEditPart, View viewFromEditPart) {
        UMLRTPort port;
        List result = null;
        UMLRTCapsule capsule = EditPartInheritanceUtils.getContextCapsule(viewFromEditPart);
        if (capsule != null && (port = EditPartInheritanceUtils.resolvePort((Port)semanticFromEditPart, capsule, viewFromEditPart)) != null) {
            List connectors;
            Predicate<UMLRTConnector> partWithPortFilter = __ -> true;
            Property partWithPort = (Property)TypeUtils.as((Object)ViewUtil.getViewContainer((EObject)viewFromEditPart).getElement(), Property.class);
            if (partWithPort != null) {
                connectors = port.getOutsideConnectors();
                UMLRTCapsulePart part = UMLRTCapsulePart.getInstance((Property)partWithPort);
                if (part != null) {
                    UMLRTCapsulePart localPart = (UMLRTCapsulePart)capsule.getRedefinitionOf((UMLRTNamedElement)part);
                    partWithPortFilter = connector -> connector.getSourcePartWithPort() == localPart || connector.getTargetPartWithPort() == localPart;
                }
            } else {
                connectors = port.getInsideConnectors();
            }
            result = connectors.stream().filter(partWithPortFilter).map(conn -> this.resolveConnector((UMLRTConnector)conn, capsule)).filter(Objects::nonNull).map(UMLRTExtensionUtil::getRootDefinition).distinct().collect(Collectors.toList());
        }
        return result;
    }

    Connector resolveConnector(UMLRTConnector connector, UMLRTCapsule capsule) {
        Connector result = connector.toUML();
        if (connector.getCapsule() != capsule) {
            result = Optional.ofNullable((UMLRTConnector)capsule.getRedefinitionOf((UMLRTNamedElement)connector)).map(UMLRTConnector::toUML).orElse(null);
        } else if (connector.isExcluded()) {
            result = null;
        }
        return result;
    }

    public IGraphicalEditPart resolveSourceEditPart(EObject connectionElement, IGraphicalEditPart context) {
        if (connectionElement instanceof Connector) {
            connectionElement = this.resolveConnector((Connector)connectionElement, context);
        }
        return super.resolveSourceEditPart(connectionElement, context);
    }

    public IGraphicalEditPart resolveTargetEditPart(EObject connectionElement, IGraphicalEditPart context) {
        if (connectionElement instanceof Connector) {
            connectionElement = this.resolveConnector((Connector)connectionElement, context);
        }
        return super.resolveTargetEditPart(connectionElement, context);
    }

    private Connector resolveConnector(Connector umlConnector, IGraphicalEditPart context) {
        Connector result = umlConnector;
        UMLRTConnector connector = UMLRTConnector.getInstance((Connector)umlConnector);
        UMLRTCapsule capsule = EditPartInheritanceUtils.getContextCapsule(context.getNotationView());
        if (connector != null && capsule != null) {
            result = ((UMLRTConnector)capsule.getRedefinitionOf((UMLRTNamedElement)connector)).toUML();
        }
        return result;
    }

    public Object getSource(EObject connectionElement) {
        Connector connector;
        Object source;
        Object result = super.getSource(connectionElement);
        if (connectionElement instanceof Connector && (source = this.getPort(connector = (Connector)connectionElement, UMLRTConnector::getSource, UMLRTConnector::getSourcePartWithPort)) != null) {
            result = source;
        }
        return result;
    }

    private Object getPort(Connector uml, Function<UMLRTConnector, UMLRTPort> roleFunction, Function<UMLRTConnector, UMLRTCapsulePart> partWithPortFunction) {
        UMLRTPort port;
        UMLRTCapsule capsule;
        Port result = null;
        UMLRTConnector connector = UMLRTConnector.getInstance((Connector)uml);
        if (connector != null && (capsule = connector.getCapsule()) != null && (port = roleFunction.apply(connector)) != null) {
            UMLRTCapsulePart part = partWithPortFunction.apply(connector);
            if (part == null) {
                result = ((UMLRTPort)capsule.getRedefinitionOf((UMLRTNamedElement)port)).toUML();
            } else {
                part = (UMLRTCapsulePart)capsule.getRedefinitionOf((UMLRTNamedElement)part);
                port = (UMLRTPort)part.getType().getRedefinitionOf((UMLRTNamedElement)port);
                result = ISemanticChildrenStrategy.createVisualStack((EObject)part.toUML(), (EObject)port.toUML(), (EObject[])new EObject[0]);
            }
        }
        return result;
    }

    public Object getTarget(EObject connectionElement) {
        Object target;
        Object result = super.getTarget(connectionElement);
        if (connectionElement instanceof Connector && (target = this.getPort((Connector)connectionElement, UMLRTConnector::getTarget, UMLRTConnector::getTargetPartWithPort)) != null) {
            result = target;
        }
        return result;
    }
}

