/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomStateEditPart;
import org.eclipse.papyrusrt.umlrt.core.utils.StateUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.InheritanceEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.RTSemanticEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.DrawFigureUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IRTPseudostateEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IStateMachineInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies.CustomStateShowHideCompartmentEditPolicy;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class RTStateEditPart
extends CustomStateEditPart
implements IStateMachineInheritableEditPart {
    public RTStateEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("umlrtInheritance", (EditPolicy)new InheritanceEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new RTSemanticEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new CustomStateShowHideCompartmentEditPolicy());
    }

    public EObject resolveSemanticElement() {
        return EditPartInheritanceUtils.resolveSemanticElement((IInheritableEditPart)this, (EObject)super.resolveSemanticElement());
    }

    public Object getAdapter(Class key) {
        return EditPartInheritanceUtils.getAdapter((IGraphicalEditPart)this, (Class)key, (Object)super.getAdapter(key));
    }

    protected void refreshForegroundColor() {
        super.refreshForegroundColor();
        UMLRTEditPartUtils.updateForegroundColor((IInheritableEditPart)this, (Figure)this.getPrimaryShape());
    }

    protected void refreshBackgroundColor() {
        if (this.getPrimaryView() != null && !this.getVisibleChildren(this.getPrimaryView()).stream().filter(BasicCompartment.class::isInstance).findFirst().isPresent()) {
            String labelColor = NotationUtils.getStringValue((View)this.getPrimaryView(), (String)"nameBackgroundColor", null);
            if (labelColor != null && !"-1".equals(labelColor)) {
                this.setBackgroundColor(DrawFigureUtils.getColorFromString((String)labelColor));
            } else {
                super.refreshBackgroundColor();
            }
        } else {
            super.refreshBackgroundColor();
        }
        UMLRTEditPartUtils.updateBackgroundColor((IInheritableEditPart)this, (NodeFigure)this.getPrimaryShape());
    }

    protected void refreshChildren() {
        super.refreshChildren();
    }

    protected List<View> getVisibleChildren(View view) {
        ArrayList<View> children = new ArrayList<View>((Collection<View>)view.getVisibleChildren());
        if (!children.stream().filter(e -> "InternalTransitions".equals(e.getType())).findFirst().isPresent()) {
            View compartmentView = view.getChildren().stream().map(View.class::cast).filter(e -> "InternalTransitions".equals(((View)e).getType())).findFirst().orElse(null);
            if (compartmentView != null) {
                boolean isForced = UMLRTEditPartUtils.isVisibilityForced((View)compartmentView);
                if (isForced) {
                    if (compartmentView.isVisible()) {
                        children.add(compartmentView);
                    }
                } else {
                    EObject semantic = this.resolveSemanticElement();
                    if (compartmentView.isVisible() && semantic instanceof State && StateUtils.hasInternalTransitions((State)((State)semantic))) {
                        children.add(compartmentView);
                    }
                }
            }
        } else {
            View compartmentView = children.stream().filter(e -> "InternalTransitions".equals(e.getType())).findFirst().get();
            boolean isForced = UMLRTEditPartUtils.isVisibilityForced((View)compartmentView);
            if (isForced) {
                if (!compartmentView.isVisible()) {
                    children.remove(compartmentView);
                }
            } else {
                EObject semantic = this.resolveSemanticElement();
                if (compartmentView.isVisible() && semantic instanceof State && !StateUtils.hasInternalTransitions((State)((State)semantic))) {
                    children.remove(compartmentView);
                }
            }
        }
        return children;
    }

    protected void removeTransitionListener(Transition transition) {
        DiagramEventBroker.getInstance((TransactionalEditingDomain)this.getEditingDomain()).removeNotificationListener((EObject)transition, (Object)UMLPackage.Literals.TRANSITION__KIND, (NotificationListener)this);
    }

    protected void removeRegionListener(Region region) {
        region.getTransitions().forEach(t -> this.removeTransitionListener((Transition)t));
        DiagramEventBroker.getInstance((TransactionalEditingDomain)this.getEditingDomain()).removeNotificationListener((EObject)region, (Object)UMLPackage.Literals.REGION__TRANSITION, (NotificationListener)this);
    }

    protected void addTransitionListener(Transition transition) {
        DiagramEventBroker.getInstance((TransactionalEditingDomain)this.getEditingDomain()).addNotificationListener((EObject)transition, (EStructuralFeature)UMLPackage.Literals.TRANSITION__KIND, (NotificationListener)this);
    }

    protected void addRegionListener(Region region) {
        DiagramEventBroker.getInstance((TransactionalEditingDomain)this.getEditingDomain()).addNotificationListener((EObject)region, (EStructuralFeature)UMLPackage.Literals.REGION__TRANSITION, (NotificationListener)this);
        region.getTransitions().forEach(t -> this.addTransitionListener((Transition)t));
    }

    protected void addStateListener(State state) {
        state.getRegions().forEach(r -> this.addRegionListener((Region)r));
    }

    protected void removeStateListener(State state) {
        state.getRegions().forEach(r -> this.removeRegionListener((Region)r));
    }

    protected void removeSemanticListeners() {
        EObject semantic = this.resolveSemanticElement();
        if (semantic instanceof State) {
            this.removeStateListener((State)semantic);
        }
        super.removeSemanticListeners();
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        EObject semantic = this.resolveSemanticElement();
        if (semantic instanceof State) {
            this.addStateListener((State)semantic);
        }
    }

    protected void handleNotificationEvent(Notification notification) {
        Object notifier = notification.getNotifier();
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        switch (notification.getEventType()) {
            case 3: {
                if (notifier instanceof State) {
                    if (UMLPackage.Literals.STATE__REGION == notification.getFeature() && newValue instanceof Region) {
                        this.addRegionListener((Region)newValue);
                    }
                } else if (notifier instanceof Region && UMLPackage.Literals.REGION__TRANSITION == notification.getFeature() && newValue instanceof Transition) {
                    this.addTransitionListener((Transition)newValue);
                }
                this.refreshChildren();
                this.refreshBackgroundColor();
                break;
            }
            case 4: {
                if (notifier instanceof State) {
                    if (UMLPackage.Literals.STATE__REGION == notification.getFeature() && oldValue instanceof Region) {
                        this.removeRegionListener((Region)oldValue);
                    }
                } else if (notifier instanceof Region && UMLPackage.Literals.REGION__TRANSITION == notification.getFeature() && oldValue instanceof Transition) {
                    this.removeTransitionListener((Transition)oldValue);
                }
                this.refreshChildren();
                this.refreshBackgroundColor();
                break;
            }
            case 5: {
                if (notifier instanceof State) {
                    if (UMLPackage.Literals.STATE__REGION != notification.getFeature()) break;
                    ((Collection)newValue).forEach(r -> this.addRegionListener((Region)r));
                    break;
                }
                if (!(notifier instanceof Region) || UMLPackage.Literals.REGION__TRANSITION != notification.getFeature()) break;
                ((Collection)newValue).forEach(t -> this.addTransitionListener((Transition)t));
                break;
            }
            case 6: {
                if (notifier instanceof State) {
                    if (UMLPackage.Literals.STATE__REGION != notification.getFeature() || UMLPackage.Literals.STATE__REGION != notification.getFeature()) break;
                    ((Collection)oldValue).forEach(r -> this.removeRegionListener((Region)r));
                    break;
                }
                if (!(notifier instanceof Region) || UMLPackage.Literals.REGION__TRANSITION != notification.getFeature()) break;
                ((Collection)oldValue).forEach(t -> this.removeTransitionListener((Transition)t));
                break;
            }
            case 1: {
                if (!(notifier instanceof Transition) || UMLPackage.Literals.TRANSITION__KIND != notification.getFeature()) break;
                this.refreshChildren();
                this.refreshBackgroundColor();
                break;
            }
        }
        super.handleNotificationEvent(notification);
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        boolean result;
        if (IRTPseudostateEditPart.isConnectionPoint(childEditPart)) {
            IRTPseudostateEditPart connPt = (IRTPseudostateEditPart)childEditPart;
            if (this.hasNotationView() && this.getNotationView().isSetElement()) {
                RTPortPositionLocator locator = new RTPortPositionLocator((Element)connPt.resolveSemanticElement(), this.getMainFigure(), 0, connPt.getDefaultScaleFactor());
                this.getBorderedFigure().getBorderItemContainer().add(connPt.getFigure(), (Object)locator);
            }
            result = true;
        } else {
            result = super.addFixedChild(childEditPart);
        }
        return result;
    }

    protected List<View> getModelChildren() {
        Object model = this.getModel();
        if (model != null && model instanceof View) {
            return this.getVisibleChildren((View)model);
        }
        return Collections.EMPTY_LIST;
    }
}

