/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.creation.CreationContext;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties.RTPropertyEditorFactory;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.NamedElement;

public abstract class FacadeListPropertyEditorFactory<E extends UMLRTNamedElement>
extends RTPropertyEditorFactory<E> {
    private static final URI CREATION_DIALOGS_CONTEXT_URI = URI.createPlatformPluginURI((String)"org.eclipse.papyrusrt.umlrt.tooling.ui/dialogs/CreationDialogs.ctx", (boolean)true);
    private static final ResourceSet viewModelResourceSet = new ResourceSetImpl();

    public FacadeListPropertyEditorFactory(EReference referenceIn, IObservableList<E> modelProperty) {
        super(referenceIn, modelProperty);
    }

    protected abstract Set<View> getCreationDialogViews();

    protected Set<View> getEditDialogViews(Object source) {
        return PropertiesRuntime.getConstraintEngine().getDisplayUnits((Object)new StructuredSelection(source));
    }

    protected static Set<View> loadDialogViews(URI contextURI, Predicate<? super View> viewSelector) {
        Set result = Collections.emptySet();
        Resource contextResource = viewModelResourceSet.getResource(contextURI, true);
        if (contextResource != null) {
            result = ((Stream)contextResource.getContents().stream().sequential()).filter(Context.class::isInstance).map(Context.class::cast).flatMap(ctx -> (Stream)ctx.getViews().stream().sequential()).filter(viewSelector).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return result;
    }

    protected static Set<View> loadDialogViews(Predicate<? super View> viewSelector) {
        return FacadeListPropertyEditorFactory.loadDialogViews(CREATION_DIALOGS_CONTEXT_URI, viewSelector);
    }

    protected static Set<View> loadDialogViews(String viewName) {
        return FacadeListPropertyEditorFactory.loadDialogViews(CREATION_DIALOGS_CONTEXT_URI, v -> viewName.equals(v.getName()));
    }

    public Object edit(Control widget, Object source) {
        Set<View> views = this.getEditDialogViews(source);
        if (views.isEmpty() && source instanceof FacadeObject) {
            return this.asUMLRT(this.edit(widget, ((FacadeObject)source).toUML()));
        }
        if (!views.isEmpty()) {
            return this.doEdit(widget, source, views, this.getEditionDialogTitle(source));
        }
        return this.asUMLRT(source);
    }

    @Override
    protected Function<EObject, Predicate<Object>> filterFunction() {
        return v -> o -> this.asUML(o) != v;
    }

    protected Object asUMLRT(Object object) {
        UMLRTNamedElement facade;
        Object result = object;
        if (object instanceof NamedElement && (facade = UMLRTFactory.create((NamedElement)((NamedElement)object))) != null) {
            result = facade;
        }
        return result;
    }

    protected Object asUML(Object object) {
        Object result = object;
        if (object instanceof UMLRTNamedElement) {
            result = ((UMLRTNamedElement)object).toUML();
        }
        return result;
    }

    @Override
    protected Object doCreateObject(Control widget, Object context) {
        Object result;
        EObject container = (EObject)PlatformHelper.getAdapter((Object)context, EObject.class);
        IEditCommandRequest customCreationRequest = this.getCustomCreationRequest(container);
        if (customCreationRequest != null) {
            IElementEditService edit = ElementEditServiceUtils.getCommandProvider((EObject)container);
            ICommand create = edit.getEditCommand(customCreationRequest);
            Predicate<UMLRTNamedElement> filter = new HashSet(this.getModelProperty())::contains;
            try {
                try {
                    this.getFilteredObservableList().addFilter(filter);
                    TransactionalEditingDomain domain = customCreationRequest.getEditingDomain();
                    Command emfCreate = (Command)ICommandWrapper.wrap((Object)create, Command.class);
                    domain.getCommandStack().execute(emfCreate);
                    result = this.asUMLRT(emfCreate.getResult().iterator().next());
                }
                catch (OperationCanceledException operationCanceledException) {
                    result = null;
                    this.getFilteredObservableList().removeFilter(filter);
                }
                catch (Exception e) {
                    Activator.log.error("Failed to create new element", (Throwable)e);
                    result = null;
                    this.getFilteredObservableList().removeFilter(filter);
                }
            }
            finally {
                this.getFilteredObservableList().removeFilter(filter);
            }
        } else {
            result = super.doCreateObject(widget, context);
        }
        return result;
    }

    protected IEditCommandRequest getCustomCreationRequest(EObject container) {
        return null;
    }

    protected Object createObject(Control widget, Object context, Object source) {
        if (source == null) {
            return null;
        }
        Set<View> views = this.getCreationDialogViews();
        if (!views.isEmpty()) {
            CreationContext creationContext = this.getCreationContext(context);
            creationContext.pushCreatedElement(source);
            try {
                Object object = this.asUMLRT(this.doEdit(widget, source, views, this.getCreationDialogTitle()));
                return object;
            }
            finally {
                creationContext.popCreatedElement(source);
            }
        }
        return this.asUMLRT(source);
    }

    @Override
    protected CreationContext basicGetCreationContext(Object element) {
        if (element instanceof UMLRTNamedElement) {
            element = ((UMLRTNamedElement)element).toUML();
        }
        return super.basicGetCreationContext(element);
    }
}

