/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.interactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MessageKind implements Enumerator
{
    UNKNOWN(0, "unknown", "UNKNOWN"),
    COMPLETE(1, "complete", "COMPLETE"),
    LOST(2, "lost", "LOST"),
    FOUND(3, "found", "FOUND");

    public static final int UNKNOWN_VALUE = 0;
    public static final int COMPLETE_VALUE = 1;
    public static final int LOST_VALUE = 2;
    public static final int FOUND_VALUE = 3;
    private static final MessageKind[] VALUES_ARRAY;
    public static final List<MessageKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageKind[]{UNKNOWN, COMPLETE, LOST, FOUND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageKind get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return COMPLETE;
            }
            case 2: {
                return LOST;
            }
            case 3: {
                return FOUND;
            }
        }
        return null;
    }

    private MessageKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

