/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.to.uml;

import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrusrt.xtumlrt.trans.to.uml.IXtumlrt2UMLTranslator;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTModel;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTLogger;
import org.eclipse.xtext.resource.XtextResourceSet;

public class TextToModelGeneration {
    private IXtumlrt2UMLTranslator generator;

    @Inject
    public void setGenerator(IXtumlrt2UMLTranslator translator) {
        this.generator = translator;
    }

    public IStatus generate(URI textUri) {
        XtextResourceSet rset = new XtextResourceSet();
        Resource resource = rset.getResource(textUri, true);
        EObject model = (EObject)resource.getContents().get(0);
        IStatus result = Status.OK_STATUS;
        try {
            if (this.generator.generate((RTModel)model) != 0) {
                result = Status.CANCEL_STATUS;
            }
        }
        catch (Exception e) {
            XTUMLRTLogger.error((String)"Text to Model transformation failed", (Throwable)e);
            return new Status(4, "org.eclipse.papyrusrt.xtumlrt.trans.to.uml", e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

